/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.WasmStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalFileChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmExternalFileChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmExternalFileChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalFileChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n295#2,2:42\n*S KotlinDebug\n*F\n+ 1 FirWasmExternalFileChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalFileChecker\n*L\n29#1:42,2\n*E\n"})
public final class FirWasmExternalFileChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirWasmExternalFileChecker INSTANCE = new FirWasmExternalFileChecker();

    private FirWasmExternalFileChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirAnnotation targetAnnotations;
        FirAnnotation firAnnotation;
        List<FirAnnotation> list;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirHelpersKt.isTopLevel(context2) || FirWebCommonHelpersKt.isEffectivelyExternal(declaration2.getSymbol(), context2.getSession())) {
            return;
        }
        FirFile firFile = context2.getContainingFile();
        if (firFile != null && (list = firFile.getAnnotations()) != null) {
            Object v0;
            block5: {
                void $this$firstOrNull$iv;
                Iterable iterable = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirAnnotation it = (FirAnnotation)element$iv;
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)WasmStandardClassIds.Annotations.annotationsRequiringExternal, (Object)FirAnnotationUtilsKt.toAnnotationClassId(it, context2.getSession()))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            firAnnotation = v0;
        } else {
            firAnnotation = targetAnnotations = null;
        }
        if (targetAnnotations != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWasmErrors.INSTANCE.getNON_EXTERNAL_DECLARATION_IN_INAPPROPRIATE_FILE(), (Object)FirTypeUtilsKt.getResolvedType(targetAnnotations), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

