/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.kotlinx.collections.immutable.PersistentMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import ksp.org.jetbrains.kotlin.contracts.description.MarkedEventOccurrencesRange;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "analyze", "", "data", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "ReassignedVariableCollector", "checkers"})
@SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1#2:73\n1782#3,4:74\n1797#3,3:78\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker\n*L\n37#1:74,4\n41#1:78,3\n*E\n"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();

    private CanBeValChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull VariableInitializationInfoData data, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Iterator<FirVariableSymbol<?>> iterator2;
        ReassignedVariableCollector reassignedVariableCollector;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ReassignedVariableCollector $this$analyze_u24lambda_u240 = reassignedVariableCollector = new ReassignedVariableCollector(data);
        boolean bl = false;
        data.getGraph().traverse($this$analyze_u24lambda_u240);
        ReassignedVariableCollector collector2 = reassignedVariableCollector;
        Iterator<FirVariableSymbol<?>> iterator3 = iterator2 = data.getProperties().iterator();
        while (iterator3.hasNext()) {
            boolean canBeVal;
            boolean bl2;
            KtSourceElement source;
            FirVariableSymbol<?> symbol2 = iterator3.next();
            if (symbol2.getSource() == null) continue;
            if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                void $this$fold$iv;
                int n;
                Iterable $this$count$iv = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int count = n;
                $this$count$iv = (Iterable)RangesKt.until((int)0, (int)count);
                boolean initial$iv = true;
                boolean $i$f$fold = false;
                boolean accumulator$iv = initial$iv;
                Iterator iterator4 = $this$fold$iv.iterator();
                while (iterator4.hasNext()) {
                    int element$iv = ((IntIterator)iterator4).nextInt();
                    boolean acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = iterator2.hasNext() && collector2.canBeVal(iterator2.next()) && acc;
                }
                bl2 = accumulator$iv;
            } else {
                bl2 = collector2.canBeVal(symbol2);
            }
            if (!(canBeVal = bl2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCAN_BE_VAL(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector;", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;)V", "getData", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "reassigned", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "visitNode", "", "node", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitVariableAssignmentNode", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "canBeVal", "", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1755#2,3:73\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector\n*L\n60#1:73,3\n*E\n"})
    private static final class ReassignedVariableCollector
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final VariableInitializationInfoData data;
        @NotNull
        private final Set<FirPropertySymbol> reassigned;

        public ReassignedVariableCollector(@NotNull VariableInitializationInfoData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
            this.reassigned = new LinkedHashSet();
        }

        @NotNull
        public final VariableInitializationInfoData getData() {
            return this.data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            block9: {
                Object symbol2;
                block10: {
                    boolean bl;
                    block8: {
                        boolean isForInitialization;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Object object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                        if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                            return;
                        }
                        symbol2 = object;
                        if (!((FirVariableSymbol)symbol2).isVar()) break block9;
                        KtSourceElement ktSourceElement = ((FirBasedSymbol)symbol2).getSource();
                        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind || !this.data.getProperties().contains(symbol2)) break block9;
                        boolean bl2 = isForInitialization = this.data.getGraph().getKind() == ControlFlowGraph.Kind.Class || this.data.getGraph().getKind() == ControlFlowGraph.Kind.File;
                        if (!FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)symbol2, isForInitialization)) break block10;
                        Iterable $this$any$iv = this.data.getValue(node).values();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PersistentMap it = (PersistentMap)element$iv;
                                boolean bl3 = false;
                                MarkedEventOccurrencesRange markedEventOccurrencesRange = (MarkedEventOccurrencesRange)it.get(symbol2);
                                boolean bl4 = markedEventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(markedEventOccurrencesRange) : false;
                                if (!bl4) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block9;
                }
                this.reassigned.add((FirPropertySymbol)symbol2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canBeVal(@NotNull FirVariableSymbol<?> symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
            if (!(symbol2 instanceof FirPropertySymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!((FirPropertySymbol)symbol2).isVar()) return false;
            if (((FirPropertySymbol)symbol2).getHasDelegate()) return false;
            KtSourceElement ktSourceElement = ((FirPropertySymbol)symbol2).getSource();
            if (ktSourceElement == null) return false;
            KtSourceElementKind ktSourceElementKind = ktSourceElement.getKind();
            if (ktSourceElementKind == null) {
                return false;
            }
            boolean bl = ktSourceElementKind instanceof KtFakeSourceElementKind;
            if (bl) return false;
            if (this.reassigned.contains(symbol2)) return false;
            return true;
        }
    }
}

