/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmInventNamesForLocalClasses;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmInventNamesForLocalClassesImpl;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.RemoveDuplicatedInlinedLocalClassesLowering;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="InventNamesForInlinedLocalClasses", description="Invent names for INLINED local classes and anonymous objects", prerequisite={JvmInventNamesForLocalClasses.class, RemoveDuplicatedInlinedLocalClassesLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForInlinedAnonymousObjects;", "Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForLocalClassesImpl;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "putLocalClassName", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "", "backend.jvm.lower"})
public final class JvmInventNamesForInlinedAnonymousObjects
extends JvmInventNamesForLocalClassesImpl {
    public JvmInventNamesForInlinedAnonymousObjects(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, true);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.getContext().getConfig().getEnableIrInliner()) {
            super.lower(irFile);
        }
    }

    @Override
    protected void putLocalClassName(@NotNull IrAttributeContainer declaration2, @NotNull String localClassName) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)localClassName, (String)"localClassName");
        if (declaration2.getOriginalBeforeInline() == null) {
            return;
        }
        JvmIrAttributesKt.setLocalClassType(declaration2, Type.getObjectType(localClassName));
    }
}

