/*
 * Decompiled with CFR 0.152.
 */
package ksp.javaslang.collection;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import ksp.javaslang.Tuple;
import ksp.javaslang.Tuple2;
import ksp.javaslang.collection.Collections;
import ksp.javaslang.collection.Iterator;
import ksp.javaslang.collection.Map;
import ksp.javaslang.control.Option;

final class Maps {
    Maps() {
    }

    static <K, V, M extends Map<K, V>> M distinct(M map) {
        return map;
    }

    static <K, V, M extends Map<K, V>> M distinctBy(M map, OfEntries<K, V, M> ofEntries, Comparator<? super Tuple2<K, V>> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return (M)((Map)ofEntries.apply(map.iterator().distinctBy(comparator)));
    }

    static <K, V, U, M extends Map<K, V>> M distinctBy(M map, OfEntries<K, V, M> ofEntries, Function<? super Tuple2<K, V>, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return (M)((Map)ofEntries.apply(map.iterator().distinctBy(keyExtractor)));
    }

    static <K, V, M extends Map<K, V>> M drop(M map, OfEntries<K, V, M> ofEntries, Supplier<M> emptySupplier, long n) {
        if (n <= 0L) {
            return map;
        }
        if (n >= (long)map.size()) {
            return (M)((Map)emptySupplier.get());
        }
        return (M)((Map)ofEntries.apply(map.iterator().drop(n)));
    }

    static <K, V, M extends Map<K, V>> M dropRight(M map, OfEntries<K, V, M> ofEntries, Supplier<M> emptySupplier, long n) {
        if (n <= 0L) {
            return map;
        }
        if (n >= (long)map.size()) {
            return (M)((Map)emptySupplier.get());
        }
        return (M)((Map)ofEntries.apply(map.iterator().dropRight(n)));
    }

    static <K, V, M extends Map<K, V>> M dropUntil(M map, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.dropWhile(map, ofEntries, predicate.negate());
    }

    static <K, V, M extends Map<K, V>> M dropWhile(M map, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (M)((Map)ofEntries.apply(map.iterator().dropWhile(predicate)));
    }

    static <K, V, M extends Map<K, V>> M filter(M map, OfEntries<K, V, M> ofEntries, BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.filter(map, ofEntries, (? super Tuple2<K, V> t) -> predicate.test((Object)t._1, (Object)t._2));
    }

    static <K, V, M extends Map<K, V>> M filter(M map, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (M)((Map)ofEntries.apply(map.iterator().filter(predicate)));
    }

    static <K, V, M extends Map<K, V>> M filterKeys(M map, OfEntries<K, V, M> ofEntries, Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.filter(map, ofEntries, (? super Tuple2<K, V> t) -> predicate.test((Object)t._1));
    }

    static <K, V, M extends Map<K, V>> M filterValues(M map, OfEntries<K, V, M> ofEntries, Predicate<? super V> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.filter(map, ofEntries, (? super Tuple2<K, V> t) -> predicate.test((Object)t._2));
    }

    static <K, V, C, M extends Map<K, V>> Map<C, M> groupBy(M map, OfEntries<K, V, M> ofEntries, Function<? super Tuple2<K, V>, ? extends C> classifier) {
        return Collections.groupBy(map, classifier, ofEntries);
    }

    static <K, V, M extends Map<K, V>> Iterator<M> grouped(M map, OfEntries<K, V, M> ofEntries, long size) {
        return Maps.sliding(map, ofEntries, size, size);
    }

    static <K, V, M extends Map<K, V>> Option<M> initOption(M map) {
        return map.isEmpty() ? Option.none() : Option.some(map.init());
    }

    static <K, V, M extends Map<K, V>> M merge(M map, OfEntries<K, V, M> ofEntries, Map<? extends K, ? extends V> that) {
        Objects.requireNonNull(that, "that is null");
        if (map.isEmpty()) {
            return (M)((Map)ofEntries.apply(Map.narrow(that)));
        }
        if (that.isEmpty()) {
            return map;
        }
        return (M)that.foldLeft(map, (result2, entry) -> !result2.containsKey(entry._1) ? Maps.put(result2, entry) : result2);
    }

    static <K, V, U extends V, M extends Map<K, V>> M merge(M map, OfEntries<K, V, M> ofEntries, Map<? extends K, U> that, BiFunction<? super V, ? super U, ? extends V> collisionResolution) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(collisionResolution, "collisionResolution is null");
        if (map.isEmpty()) {
            return (M)((Map)ofEntries.apply(Map.narrow(that)));
        }
        if (that.isEmpty()) {
            return map;
        }
        return (M)that.foldLeft(map, (result2, entry) -> {
            Object key = entry._1;
            Object value2 = entry._2;
            Object newValue = result2.get(key).map(v -> collisionResolution.apply((Object)v, (Object)value2)).getOrElse(value2);
            return result2.put(key, newValue);
        });
    }

    static <K, V, M extends Map<K, V>> Tuple2<M, M> partition(M map, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super Tuple2<K, V>>, Iterator<? super Tuple2<K, V>>> p = map.iterator().partition(predicate);
        return Tuple.of(ofEntries.apply(p._1), ofEntries.apply(p._2));
    }

    static <K, V, M extends Map<K, V>> M peek(M map, Consumer<? super Tuple2<K, V>> action) {
        Objects.requireNonNull(action, "action is null");
        if (!map.isEmpty()) {
            action.accept((Tuple2<K, V>)map.head());
        }
        return map;
    }

    static <K, V, U extends V, M extends Map<K, V>> M put(M map, K key, U value2, BiFunction<? super V, ? super U, ? extends V> merge) {
        Objects.requireNonNull(merge, "the merge function is null");
        Option<V> currentValue = map.get(key);
        if (currentValue.isEmpty()) {
            return (M)map.put(key, value2);
        }
        return (M)map.put(key, merge.apply(currentValue.get(), value2));
    }

    static <K, V, M extends Map<K, V>> M put(M map, Tuple2<? extends K, ? extends V> entry) {
        Objects.requireNonNull(entry, "entry is null");
        return (M)map.put(entry._1, entry._2);
    }

    static <K, V, U extends V, M extends Map<K, V>> M put(M map, Tuple2<? extends K, U> entry, BiFunction<? super V, ? super U, ? extends V> merge) {
        Objects.requireNonNull(merge, "the merge function is null");
        Option currentValue = map.get(entry._1);
        if (currentValue.isEmpty()) {
            return Maps.put(map, entry);
        }
        return Maps.put(map, entry.map2(value2 -> merge.apply((Object)currentValue.get(), (Object)value2)));
    }

    static <K, V, M extends Map<K, V>> M removeAll(M map, OfEntries<K, V, M> ofEntries, BiPredicate<? super K, ? super V> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.filter(map, ofEntries, predicate.negate());
    }

    static <K, V, M extends Map<K, V>> M removeKeys(M map, OfEntries<K, V, M> ofEntries, Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.filterKeys(map, ofEntries, predicate.negate());
    }

    static <K, V, M extends Map<K, V>> M removeValues(M map, OfEntries<K, V, M> ofEntries, Predicate<? super V> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.filterValues(map, ofEntries, predicate.negate());
    }

    static <K, V, M extends Map<K, V>> M replace(M map, Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        Objects.requireNonNull(currentElement, "currentElement is null");
        Objects.requireNonNull(newElement, "newElement is null");
        return (M)(map.containsKey(currentElement._1) ? map.remove(currentElement._1).put(newElement) : map);
    }

    static <K, V, M extends Map<K, V>> M replaceAll(M map, Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replace(map, currentElement, newElement);
    }

    static <K, V, M extends Map<K, V>> M scan(M map, Supplier<M> emptySupplier, Tuple2<K, V> zero, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return (M)((Map)Collections.scanLeft(map, zero, operation, (Iterable)emptySupplier.get(), Maps::put, Function.identity()));
    }

    static <K, V, M extends Map<K, V>> Iterator<M> sliding(M map, OfEntries<K, V, M> ofEntries, long size) {
        return Maps.sliding(map, ofEntries, size, 1L);
    }

    static <K, V, M extends Map<K, V>> Iterator<M> sliding(M map, OfEntries<K, V, M> ofEntries, long size, long step) {
        return map.iterator().sliding(size, step).map(ofEntries);
    }

    static <K, V, M extends Map<K, V>> Tuple2<M, M> span(M map, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super Tuple2<K, V>>, Iterator<? super Tuple2<K, V>>> t = map.iterator().span(predicate);
        return Tuple.of(ofEntries.apply(t._1), ofEntries.apply(t._2));
    }

    static <K, V, M extends Map<K, V>> Option<M> tailOption(M map) {
        return map.isEmpty() ? Option.none() : Option.some(map.tail());
    }

    static <K, V, M extends Map<K, V>> M take(M map, OfEntries<K, V, M> ofEntries, long n) {
        if (n >= (long)map.size()) {
            return map;
        }
        return (M)((Map)ofEntries.apply(map.iterator().take(n)));
    }

    static <K, V, M extends Map<K, V>> M takeRight(M map, OfEntries<K, V, M> ofEntries, long n) {
        if (n >= (long)map.size()) {
            return map;
        }
        return (M)((Map)ofEntries.apply(map.iterator().takeRight(n)));
    }

    static <K, V, M extends Map<K, V>> M takeUntil(M map, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.takeWhile(map, ofEntries, predicate.negate());
    }

    static <K, V, M extends Map<K, V>> M takeWhile(M map, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Map taken = (Map)ofEntries.apply(map.iterator().takeWhile(predicate));
        return (M)(taken.size() == map.size() ? map : taken);
    }

    @FunctionalInterface
    static interface OfEntries<K, V, M extends Map<K, V>>
    extends Function<Iterable<Tuple2<K, V>>, M> {
    }
}

