/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.impl;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.ForeignLeafType;
import ksp.com.intellij.lang.ITokenTypeRemapper;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.lang.LighterASTTokenNode;
import ksp.com.intellij.lang.LighterLazyParseableNode;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.TokenWrapper;
import ksp.com.intellij.lang.WhitespaceSkippedCallback;
import ksp.com.intellij.lang.WhitespacesAndCommentsBinder;
import ksp.com.intellij.lang.WhitespacesBinders;
import ksp.com.intellij.lang.impl.MarkerOptionalData;
import ksp.com.intellij.lang.impl.MarkerPool;
import ksp.com.intellij.lang.impl.MarkerProduction;
import ksp.com.intellij.lang.impl.PsiBuilderDiagnostics;
import ksp.com.intellij.lang.impl.TokenSequence;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.EmptyProgressIndicator;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.com.intellij.openapi.progress.ProgressIndicatorProvider;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.NlsContexts;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.openapi.util.UnprotectedUserDataHolder;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiErrorElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.TokenType;
import ksp.com.intellij.psi.impl.BlockSupportImpl;
import ksp.com.intellij.psi.impl.DiffLog;
import ksp.com.intellij.psi.impl.PsiDocumentManagerBase;
import ksp.com.intellij.psi.impl.source.CharTableImpl;
import ksp.com.intellij.psi.impl.source.resolve.FileContextUtil;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.Factory;
import ksp.com.intellij.psi.impl.source.tree.FileElement;
import ksp.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import ksp.com.intellij.psi.impl.source.tree.LazyParseableElement;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.text.BlockSupport;
import ksp.com.intellij.psi.tree.CustomLanguageASTComparator;
import ksp.com.intellij.psi.tree.ICustomParsingType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.com.intellij.psi.tree.ILazyParseableElementType;
import ksp.com.intellij.psi.tree.ILazyParseableElementTypeBase;
import ksp.com.intellij.psi.tree.ILeafElementType;
import ksp.com.intellij.psi.tree.ILightLazyParseableElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.CharTable;
import ksp.com.intellij.util.ThreeState;
import ksp.com.intellij.util.TripleFunction;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.Interner;
import ksp.com.intellij.util.containers.LimitedPool;
import ksp.com.intellij.util.diff.DiffTreeChangeBuilder;
import ksp.com.intellij.util.diff.FlyweightCapableTreeStructure;
import ksp.com.intellij.util.diff.ShallowNodeComparator;
import ksp.com.intellij.util.text.CharArrayUtil;
import ksp.com.intellij.util.text.CharSequenceSubSequence;
import ksp.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import ksp.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import ksp.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiBuilderImpl
extends UnprotectedUserDataHolder
implements PsiBuilder {
    private static final Logger LOG = Logger.getInstance(PsiBuilderImpl.class);
    static PsiBuilderDiagnostics DIAGNOSTICS;
    public static final Key<TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>> CUSTOM_COMPARATOR;
    private static final Key<TokenSequence> LAZY_PARSEABLE_TOKENS;
    private static TokenSet ourAnyLanguageWhitespaceTokens;
    private final Project myProject;
    private PsiFile myFile;
    private final int[] myLexStarts;
    private final IElementType[] myLexTypes;
    private int myCurrentLexeme;
    private final ParserDefinition myParserDefinition;
    private final Lexer myLexer;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private final CharSequence myText;
    private final CharSequence myLastCommittedText;
    private final char[] myTextArray;
    private boolean myDebugMode;
    private final int myLexemeCount;
    private boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private final ASTNode myOriginalTree;
    private final MyTreeStructure myParentLightTree;
    private final int myOffset;
    private final Interner<String> myErrorInterner;
    private IElementType myCachedTokenType;
    private final Int2ObjectMap<LazyParseableToken> myChameleonCache;
    private final MarkerPool myPool;
    private final MarkerOptionalData myOptionalData;
    private final MarkerProduction myProduction;
    @NonNls
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";

    public static void registerWhitespaceToken(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(0);
        }
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet(ourAnyLanguageWhitespaceTokens, TokenSet.create(type2));
    }

    public PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile2, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(1);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(2);
        }
        if (text == null) {
            PsiBuilderImpl.$$$reportNull$$$0(3);
        }
        this(project, containingFile2, parserDefinition, lexer, charTable, text, originalTree, originalTree == null ? null : originalTree.getText(), parentLightTree, null);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text) {
        if (project == null) {
            PsiBuilderImpl.$$$reportNull$$$0(4);
        }
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(5);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(6);
        }
        if (chameleon == null) {
            PsiBuilderImpl.$$$reportNull$$$0(7);
        }
        if (text == null) {
            PsiBuilderImpl.$$$reportNull$$$0(8);
        }
        this(project, SharedImplUtil.getContainingFile(chameleon), parserDefinition, lexer, SharedImplUtil.findCharTableByTree(chameleon), text, Pair.getFirst(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), Pair.getSecond(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), null, chameleon);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text) {
        if (project == null) {
            PsiBuilderImpl.$$$reportNull$$$0(9);
        }
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(10);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(11);
        }
        if (chameleon == null) {
            PsiBuilderImpl.$$$reportNull$$$0(12);
        }
        if (text == null) {
            PsiBuilderImpl.$$$reportNull$$$0(13);
        }
        this(project, chameleon.getContainingFile(), parserDefinition, lexer, chameleon.getCharTable(), text, null, null, ((LazyParseableToken)chameleon).myParentStructure, chameleon);
    }

    private PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile2, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable CharSequence lastCommittedText, @Nullable MyTreeStructure parentLightTree, @Nullable Object parentCachingNode) {
        if (parserDefinition == null) {
            PsiBuilderImpl.$$$reportNull$$$0(14);
        }
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(15);
        }
        if (text == null) {
            PsiBuilderImpl.$$$reportNull$$$0(16);
        }
        this.myErrorInterner = Interner.createStringInterner();
        this.myChameleonCache = new Int2ObjectOpenHashMap<LazyParseableToken>();
        this.myPool = new MarkerPool(this);
        this.myOptionalData = new MarkerOptionalData();
        this.myProduction = new MarkerProduction(this.myPool, this.myOptionalData);
        this.myProject = project;
        this.myFile = containingFile2;
        this.myParserDefinition = parserDefinition;
        this.myText = text;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying(text);
        this.myLexer = lexer;
        this.myWhitespaces = parserDefinition.getWhitespaceTokens();
        this.myComments = parserDefinition.getCommentTokens();
        this.myCharTable = charTable;
        this.myOriginalTree = originalTree;
        this.myLastCommittedText = lastCommittedText;
        if (originalTree == null != (lastCommittedText == null)) {
            throw new IllegalArgumentException("originalTree and lastCommittedText must be null/notnull together but got: originalTree=" + originalTree + "; lastCommittedText=" + (lastCommittedText == null ? null : "'" + StringUtil.first(lastCommittedText, 80, true) + "'"));
        }
        this.myParentLightTree = parentLightTree;
        this.myOffset = parentCachingNode instanceof LazyParseableToken ? ((LazyParseableToken)parentCachingNode).getStartOffset() : 0;
        TokenSequence tokens = this.performLexing(parentCachingNode);
        this.myLexStarts = tokens.lexStarts;
        this.myLexTypes = tokens.lexTypes;
        this.myLexemeCount = tokens.lexemeCount;
        if (DIAGNOSTICS != null) {
            DIAGNOSTICS.registerPass(text.length(), this.myLexemeCount);
        }
    }

    @NotNull
    private TokenSequence performLexing(@Nullable Object parentCachingNode) {
        TokenSequence fromParent = null;
        if (parentCachingNode instanceof LazyParseableToken && PsiBuilderImpl.shouldReuseCollapsedTokens(((LazyParseableToken)parentCachingNode).getTokenType())) {
            fromParent = ((LazyParseableToken)parentCachingNode).getParsedTokenSequence();
            assert (fromParent == null || fromParent.lexStarts[fromParent.lexemeCount] == this.myText.length());
            ProgressIndicatorProvider.checkCanceled();
        } else if (parentCachingNode instanceof LazyParseableElement) {
            LazyParseableElement parentElement = (LazyParseableElement)parentCachingNode;
            fromParent = parentElement.getUserData(LAZY_PARSEABLE_TOKENS);
            parentElement.putUserData(LAZY_PARSEABLE_TOKENS, null);
        }
        if (fromParent != null) {
            if (PsiBuilderImpl.doLexingOptimizationCorrectionCheck()) {
                fromParent.assertMatches(this.myText, this.myLexer);
            }
            TokenSequence tokenSequence = fromParent;
            if (tokenSequence == null) {
                PsiBuilderImpl.$$$reportNull$$$0(17);
            }
            return tokenSequence;
        }
        TokenSequence tokenSequence = TokenSequence.performLexing(this.myText, this.myLexer);
        if (tokenSequence == null) {
            PsiBuilderImpl.$$$reportNull$$$0(18);
        }
        return tokenSequence;
    }

    private static boolean doLexingOptimizationCorrectionCheck() {
        return false;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        if (tokens == null) {
            PsiBuilderImpl.$$$reportNull$$$0(19);
        }
        this.myComments = tokens;
    }

    @Override
    @Nullable
    public StartMarker getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            StartMarker marker = this.myProduction.getDoneMarkerAt(index);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @NotNull
    public List<ProductionMarker> getProductions() {
        return new AbstractList<ProductionMarker>(){

            @Override
            public ProductionMarker get(int index) {
                return PsiBuilderImpl.this.myProduction.getMarkerAt(index);
            }

            @Override
            public int size() {
                return PsiBuilderImpl.this.myProduction.size();
            }
        };
    }

    @NotNull
    private PsiBuilder.Marker precede(@NotNull StartMarker marker) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(20);
        }
        assert (marker.myLexemeIndex >= 0) : "Preceding disposed marker";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.addBefore(pre, marker);
        StartMarker startMarker = pre;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(21);
        }
        return startMarker;
    }

    @Override
    @NotNull
    public CharSequence getOriginalText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            PsiBuilderImpl.$$$reportNull$$$0(22);
        }
        return charSequence;
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    @Override
    public boolean isWhitespaceOrComment(@NotNull IElementType elementType) {
        if (elementType == null) {
            PsiBuilderImpl.$$$reportNull$$$0(23);
        }
        return this.myWhitespaces.contains(elementType) || this.myComments.contains(elementType);
    }

    private void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1], this.myText));
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    @Override
    public void setTokenTypeRemapper(ITokenTypeRemapper remapper2) {
        this.myRemapper = remapper2;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    @Override
    public void remapCurrentToken(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(24);
        }
        this.myLexTypes[this.myCurrentLexeme] = type2;
        this.clearCachedTokenType();
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        int cur = this.shiftOverWhitespaceForward(this.myCurrentLexeme);
        while (steps > 0) {
            cur = this.shiftOverWhitespaceForward(cur + 1);
            --steps;
        }
        return cur < this.myLexemeCount ? this.myLexTypes[cur] : null;
    }

    private int shiftOverWhitespaceForward(int lexIndex) {
        while (lexIndex < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[lexIndex])) {
            ++lexIndex;
        }
        return lexIndex;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexeme + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.myLexTypes[cur] : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexeme + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[cur];
    }

    @Override
    public int rawTokenIndex() {
        return this.myCurrentLexeme;
    }

    @Override
    public void rawAdvanceLexer(int steps) {
        ProgressIndicatorProvider.checkCanceled();
        if (steps < 0) {
            throw new IllegalArgumentException("Steps must be a positive integer - lexer can only be advanced. Use Marker.rollbackTo if you want to rollback PSI building.");
        }
        if (steps == 0) {
            return;
        }
        this.myCurrentLexeme += steps;
        if (this.myCurrentLexeme > this.myLexemeCount || this.myCurrentLexeme < 0) {
            this.myCurrentLexeme = this.myLexemeCount;
        }
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    @Override
    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback) {
        this.myWhitespaceSkippedCallback = callback;
    }

    @Override
    public void advanceLexer() {
        ProgressIndicatorProvider.checkCanceled();
        if (this.eof()) {
            return;
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexeme;
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexeme < this.myLexemeCount && this.whitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myCurrentLexeme + 1 < this.myLexemeCount ? this.myLexStarts[this.myCurrentLexeme + 1] : this.myText.length());
            ++this.myCurrentLexeme;
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type2, int start, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type2, start, end);
        }
    }

    @Override
    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexeme];
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type2 = this.getTokenType();
        if (type2 instanceof TokenWrapper) {
            return ((TokenWrapper)type2).getValue();
        }
        return this.myText.subSequence(this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1]).toString();
    }

    public boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexeme);
        this.myProduction.addMarker(marker);
        StartMarker startMarker = marker;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(25);
        }
        return startMarker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.myPool.allocateStartMarker();
        marker.myLexemeIndex = lexemeIndex;
        if (this.myDebugMode) {
            this.myOptionalData.notifyAllocated(marker.markerId);
        }
        StartMarker startMarker = marker;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(26);
        }
        return startMarker;
    }

    @Override
    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexeme >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull StartMarker marker) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(27);
        }
        assert (marker.myLexemeIndex >= 0) : "The marker is already disposed";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        if (DIAGNOSTICS != null) {
            DIAGNOSTICS.registerRollback(this.myCurrentLexeme - marker.myLexemeIndex);
        }
        this.myCurrentLexeme = marker.myLexemeIndex;
        this.myTokenTypeChecked = true;
        this.myProduction.rollbackTo(marker);
        this.clearCachedTokenType();
    }

    public boolean hasErrorsAfter(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(28);
        }
        return this.myProduction.hasErrorsAfter((StartMarker)marker);
    }

    private void processDone(@NotNull StartMarker marker, @Nullable @Nls String errorMessage, @Nullable StartMarker before) {
        int doneLexeme;
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(29);
        }
        this.doValidityChecks(marker, before);
        if (errorMessage != null) {
            this.myOptionalData.setErrorMessage(marker.markerId, errorMessage);
        }
        int n = doneLexeme = before == null ? this.myCurrentLexeme : before.myLexemeIndex;
        if (marker.myType.isLeftBound() && this.isEmpty(marker.myLexemeIndex, doneLexeme)) {
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        }
        marker.myDoneLexeme = doneLexeme;
        this.myProduction.addDone(marker, before);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.myLexTypes[i];
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    private void doValidityChecks(@NotNull StartMarker marker, @Nullable StartMarker before) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(30);
        }
        if (marker.isDone()) {
            LOG.error("Marker already done.");
        }
        if (this.myDebugMode) {
            this.myProduction.doHeavyChecksOnMarkerDone(marker, before);
        }
    }

    @Override
    public void error(@NotNull String messageText) {
        ProductionMarker lastMarker;
        if (messageText == null) {
            PsiBuilderImpl.$$$reportNull$$$0(31);
        }
        if ((lastMarker = this.myProduction.getStartMarkerAt(this.myProduction.size() - 1)) instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexeme) {
            return;
        }
        ErrorItem marker = this.myPool.allocateErrorItem();
        marker.setMessage(messageText);
        marker.myLexemeIndex = this.myCurrentLexeme;
        this.myProduction.addMarker(marker);
    }

    @Override
    @NotNull
    public ASTNode getTreeBuilt() {
        return this.buildTree();
    }

    @NotNull
    private ASTNode buildTree() {
        TreeElement childNode;
        boolean possiblyTooDeep;
        StartMarker rootMarker = this.prepareLightTree();
        boolean bl = possiblyTooDeep = this.myFile != null && BlockSupport.isTooDeep(this.myFile.getOriginalFile());
        if (this.myOriginalTree != null && !possiblyTooDeep) {
            DiffLog diffLog = this.merge(this.myOriginalTree, rootMarker, this.myLastCommittedText);
            throw new BlockSupport.ReparsedSuccessfullyException(diffLog);
        }
        TreeElement rootNode = this.createRootAST(rootMarker);
        this.bind(rootMarker, (CompositeElement)rootNode);
        if (possiblyTooDeep && !(rootNode instanceof FileElement) && (childNode = rootNode.getFirstChildNode()) != null) {
            childNode.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        if (rootNode.getTextLength() != this.myText.length()) {
            LOG.error("Inconsistent root node. ; node type: " + rootNode.getElementType() + "; text length: " + this.myText.length() + "; node length: " + rootNode.getTextLength() + "; partial text: " + StringUtil.shortenTextWithEllipsis(this.myText.toString(), 512, 256) + "; partial node text: " + StringUtil.shortenTextWithEllipsis(rootNode.getText(), 512, 256));
        }
        TreeElement treeElement = rootNode;
        if (treeElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(32);
        }
        return treeElement;
    }

    @Override
    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        return new MyTreeStructure(rootMarker, this.myParentLightTree);
    }

    @NotNull
    private TreeElement createRootAST(@NotNull StartMarker rootMarker) {
        IElementType type2;
        CompositeElement rootNode;
        if (rootMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(33);
        }
        CompositeElement compositeElement = rootNode = (type2 = rootMarker.getTokenType()) instanceof ILazyParseableElementType ? PsiBuilderImpl.createLazy((ILazyParseableElementType)type2, null, this.getASTFactory()) : PsiBuilderImpl.createComposite(rootMarker, this.getASTFactory());
        if (this.myCharTable == null) {
            CharTable charTable = this.myCharTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        CompositeElement compositeElement2 = rootNode;
        if (compositeElement2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(34);
        }
        return compositeElement2;
    }

    @Nullable
    private ASTFactory getASTFactory() {
        return this.myParserDefinition instanceof ASTFactory ? (ASTFactory)((Object)this.myParserDefinition) : null;
    }

    @NotNull
    private DiffLog merge(@NotNull ASTNode oldRoot, @NotNull StartMarker newRoot, @NotNull CharSequence lastCommittedText) {
        if (oldRoot == null) {
            PsiBuilderImpl.$$$reportNull$$$0(35);
        }
        if (newRoot == null) {
            PsiBuilderImpl.$$$reportNull$$$0(36);
        }
        if (lastCommittedText == null) {
            PsiBuilderImpl.$$$reportNull$$$0(37);
        }
        DiffLog diffLog = new DiffLog();
        ConvertFromTokensToASTBuilder builder2 = new ConvertFromTokensToASTBuilder(newRoot, diffLog);
        MyTreeStructure treeStructure = new MyTreeStructure(newRoot, null);
        List<CustomLanguageASTComparator> customLanguageASTComparators = CustomLanguageASTComparator.getMatchingComparators(this.myFile);
        MyComparator comparator = new MyComparator(treeStructure, customLanguageASTComparators, this.getUserData(CUSTOM_COMPARATOR));
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        BlockSupportImpl.diffTrees(oldRoot, builder2, comparator, treeStructure, indicator, lastCommittedText);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(38);
        }
        return diffLog2;
    }

    @NotNull
    private StartMarker prepareLightTree() {
        StartMarker rootMarker;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if ((rootMarker = (StartMarker)Objects.requireNonNull(this.myProduction.getStartMarkerAt(0))).myFirstChild != null) {
            StartMarker startMarker = rootMarker;
            if (startMarker == null) {
                PsiBuilderImpl.$$$reportNull$$$0(39);
            }
            return startMarker;
        }
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        rootMarker.myNext = null;
        rootMarker.myParent = rootMarker.myFirstChild = (rootMarker.myLastChild = null);
        StartMarker curNode = rootMarker;
        ObjectArrayList<StartMarker> nodes = new ObjectArrayList<StartMarker>();
        nodes.push(rootMarker);
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        boolean hasCollapsedChameleons = false;
        int[] productions = this.myProduction.elements();
        K[] markers = this.myPool.elements();
        int size = this.myProduction.size();
        for (int i = 1; i < size; ++i) {
            ProductionMarker item;
            int id = productions[i];
            ProductionMarker productionMarker = item = id > 0 ? (ProductionMarker)markers[id] : null;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                marker.myParent = curNode;
                marker.myNext = null;
                marker.myFirstChild = (marker.myLastChild = null);
                curNode.addChild(marker);
                nodes.push(curNode);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof ErrorItem) {
                item.myParent = curNode;
                int curToken = item.myLexemeIndex;
                if (curToken == lastErrorIndex) continue;
                lastErrorIndex = curToken;
                curNode.addChild(item);
                continue;
            }
            if (PsiBuilderImpl.isCollapsedChameleon(curNode)) {
                hasCollapsedChameleons = true;
            }
            this.assertMarkersBalanced(id < 0 && markers[-id] == curNode, item);
            curNode = (StartMarker)nodes.pop();
            --curDepth;
        }
        if (this.myCurrentLexeme < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.subArrayAsList(this.myLexTypes, this.myCurrentLexeme, this.myLexemeCount);
            LOG.error("Tokens " + missed + " were not inserted into the tree. " + (this.myFile != null ? this.myFile.getLanguage() + ", " : "") + "Text:\n" + this.myText);
        }
        if (rootMarker.getEndIndex() < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.subArrayAsList(this.myLexTypes, rootMarker.getEndIndex(), this.myLexemeCount);
            LOG.error("Tokens " + missed + " are outside of root element \"" + rootMarker.myType + "\". Text:\n" + this.myText);
        }
        this.assertMarkersBalanced(curNode == rootMarker, curNode);
        this.checkTreeDepth(maxDepth, rootMarker.getTokenType() instanceof IFileElementType, hasCollapsedChameleons);
        this.clearCachedTokenType();
        StartMarker startMarker = rootMarker;
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(40);
        }
        return startMarker;
    }

    private static boolean isCollapsedChameleon(@NotNull StartMarker marker) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(41);
        }
        return marker.getTokenType() instanceof ILazyParseableElementTypeBase && marker.myFirstChild == null && marker.getTextLength() > 0;
    }

    private void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        this.reportUnbalancedMarkers(marker);
    }

    private void reportUnbalancedMarkers(@Nullable ProductionMarker marker) {
        int index = marker != null ? marker.getStartIndex() + 1 : this.myLexStarts.length;
        String context2 = index < this.myLexStarts.length ? this.myText.subSequence(Math.max(0, this.myLexStarts[index] - 1000), this.myLexStarts[index]) : "<none>";
        String language = this.myFile != null ? this.myFile.getLanguage() + ", " : "";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\nlanguage: " + language + "\ncontext: '" + context2 + "'\nmarker id: " + (marker == null ? "n/a" : Integer.valueOf(marker.markerId)));
    }

    private void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int[] productions = this.myProduction.elements();
        K[] markers = this.myPool.elements();
        int size = this.myProduction.size() - 1;
        for (int i = 1; i < size; ++i) {
            int wsStartIndex;
            int prevProductionLexIndex;
            WhitespacesAndCommentsBinder binder;
            ProductionMarker item;
            ProductionMarker starting;
            int id = productions[i];
            ProductionMarker productionMarker = starting = id > 0 ? (ProductionMarker)markers[id] : null;
            if (starting instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)starting).isDone(), starting);
            }
            boolean done = starting == null;
            ProductionMarker productionMarker2 = item = starting != null ? starting : (ProductionMarker)markers[-id];
            if (item instanceof ErrorItem) {
                assert (!done);
                binder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
            } else {
                binder = this.myOptionalData.getBinder(item.markerId, done);
            }
            int lexemeIndex = item.getLexemeIndex(done);
            boolean recursive = binder instanceof WhitespacesAndCommentsBinder.RecursiveBinder;
            if (recursive) {
                prevProductionLexIndex = 0;
            } else {
                int prevId = productions[i - 1];
                prevProductionLexIndex = ((ProductionMarker)markers[Math.abs(prevId)]).getLexemeIndex(prevId < 0);
            }
            for (wsStartIndex = Math.max(lexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.whitespaceOrComment(this.myLexTypes[wsStartIndex - 1]); --wsStartIndex) {
            }
            int wsEndIndex = this.shiftOverWhitespaceForward(lexemeIndex);
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                lexemeIndex = wsStartIndex + binder.getEdgePosition(wsTokens, atEnd, tokenTextGetter);
                item.setLexemeIndex(lexemeIndex, done);
                if (recursive) {
                    this.myProduction.confineMarkersToMaxLexeme(i, lexemeIndex);
                }
            } else if (lexemeIndex < wsStartIndex) {
                lexemeIndex = wsStartIndex;
                item.setLexemeIndex(wsStartIndex, done);
            }
            lastIndex = lexemeIndex;
        }
    }

    private void checkTreeDepth(int maxDepth, boolean isFileRoot, boolean hasCollapsedChameleons) {
        if (this.myFile == null) {
            return;
        }
        PsiFile file2 = this.myFile.getOriginalFile();
        Boolean flag = file2.getUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED);
        if (maxDepth > BlockSupport.INCREMENTAL_REPARSE_DEPTH_LIMIT) {
            if (!Boolean.TRUE.equals(flag)) {
                file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
            }
        } else if (isFileRoot && flag != null && !hasCollapsedChameleons) {
            file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, null);
        }
    }

    private void bind(@NotNull StartMarker rootMarker, @NotNull CompositeElement rootNode) {
        if (rootMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(42);
        }
        if (rootNode == null) {
            PsiBuilderImpl.$$$reportNull$$$0(43);
        }
        ASTFactory astFactory = this.getASTFactory();
        StartMarker curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker.myLexemeIndex;
        ProductionMarker item = rootMarker.myFirstChild != null ? rootMarker.myFirstChild : rootMarker;
        boolean itemDone = rootMarker.myFirstChild == null;
        while (true) {
            lexIndex = this.insertLeaves(lexIndex, item.getLexemeIndex(itemDone), curNode);
            if (item == rootMarker && itemDone) break;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                if (itemDone) {
                    curMarker = (StartMarker)marker.myParent;
                    curNode = curNode.getTreeParent();
                    item = marker.myNext;
                    itemDone = false;
                } else {
                    if (!this.isCollapsed(marker)) {
                        curMarker = marker;
                        CompositeElement childNode = PsiBuilderImpl.createComposite(marker, astFactory);
                        curNode.rawAddChildrenWithoutNotifications(childNode);
                        curNode = childNode;
                        item = marker.myFirstChild != null ? marker.myFirstChild : marker;
                        itemDone = marker.myFirstChild == null;
                        continue;
                    }
                    lexIndex = this.collapseLeaves(curNode, marker);
                    item = marker.myNext;
                }
            } else if (item instanceof ErrorItem) {
                CompositeElement errorElement = Factory.createErrorElement(((ErrorItem)item).myMessage);
                curNode.rawAddChildrenWithoutNotifications(errorElement);
                item = item.myNext;
            }
            if (item != null) continue;
            item = curMarker;
            itemDone = true;
        }
    }

    public boolean isCollapsed(@NotNull ProductionMarker marker) {
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(44);
        }
        return this.myOptionalData.isCollapsed(marker.markerId);
    }

    private int insertLeaves(int curToken, int lastIdx, @NotNull CompositeElement curNode) {
        if (curNode == null) {
            PsiBuilderImpl.$$$reportNull$$$0(45);
        }
        lastIdx = Math.min(lastIdx, this.myLexemeCount);
        while (curToken < lastIdx) {
            ProgressIndicatorProvider.checkCanceled();
            int start = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type2 = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type2, start, end);
                curNode.rawAddChildrenWithoutNotifications(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private int collapseLeaves(@NotNull CompositeElement ast, @NotNull StartMarker startMarker) {
        if (ast == null) {
            PsiBuilderImpl.$$$reportNull$$$0(46);
        }
        if (startMarker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(47);
        }
        int start = this.myLexStarts[startMarker.myLexemeIndex];
        int end = this.myLexStarts[startMarker.getEndIndex()];
        IElementType markerType = startMarker.myType;
        TreeElement leaf = this.createLeaf(markerType, start, end);
        if (PsiBuilderImpl.shouldReuseCollapsedTokens(markerType) && startMarker.myLexemeIndex < startMarker.getEndIndex()) {
            int length = startMarker.getEndIndex() - startMarker.myLexemeIndex;
            int[] relativeStarts = new int[length + 1];
            IElementType[] types2 = new IElementType[length + 1];
            for (int i = startMarker.myLexemeIndex; i < startMarker.getEndIndex(); ++i) {
                relativeStarts[i - startMarker.myLexemeIndex] = this.myLexStarts[i] - start;
                types2[i - startMarker.myLexemeIndex] = this.myLexTypes[i];
            }
            relativeStarts[length] = end - start;
            leaf.putUserData(LAZY_PARSEABLE_TOKENS, new TokenSequence(relativeStarts, types2, length, leaf.getChars()));
        }
        ast.rawAddChildrenWithoutNotifications(leaf);
        return startMarker.getEndIndex();
    }

    private static boolean shouldReuseCollapsedTokens(IElementType collapsed) {
        return collapsed instanceof ILazyParseableElementTypeBase && ((ILazyParseableElementTypeBase)((Object)collapsed)).reuseCollapsedTokens();
    }

    @NotNull
    private static CompositeElement createComposite(@NotNull StartMarker marker, @Nullable ASTFactory astFactory) {
        CompositeElement composite;
        IElementType type2;
        if (marker == null) {
            PsiBuilderImpl.$$$reportNull$$$0(48);
        }
        if ((type2 = marker.myType) == TokenType.ERROR_ELEMENT) {
            String error = marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
            Objects.requireNonNull(error);
            CompositeElement compositeElement = Factory.createErrorElement(error);
            if (compositeElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(49);
            }
            return compositeElement;
        }
        if (type2 == null) {
            throw new RuntimeException(UNBALANCED_MESSAGE);
        }
        if (astFactory != null && (composite = astFactory.createComposite(marker.getTokenType())) != null) {
            CompositeElement compositeElement = composite;
            if (compositeElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(50);
            }
            return compositeElement;
        }
        CompositeElement compositeElement = ASTFactory.composite(type2);
        if (compositeElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(51);
        }
        return compositeElement;
    }

    @NotNull
    private static LazyParseableElement createLazy(@NotNull ILazyParseableElementType type2, @Nullable CharSequence text, @Nullable ASTFactory astFactory) {
        LazyParseableElement element2;
        if (type2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(52);
        }
        if (astFactory != null && (element2 = astFactory.createLazy(type2, text)) != null) {
            LazyParseableElement lazyParseableElement = element2;
            if (lazyParseableElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(53);
            }
            return lazyParseableElement;
        }
        LazyParseableElement lazyParseableElement = ASTFactory.lazy(type2, text);
        if (lazyParseableElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(54);
        }
        return lazyParseableElement;
    }

    @Nullable
    @NlsContexts.DetailedDescription
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        StartMarker marker;
        if (node == null) {
            PsiBuilderImpl.$$$reportNull$$$0(55);
        }
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker && (marker = (StartMarker)node).myType == TokenType.ERROR_ELEMENT) {
            return marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
        }
        return null;
    }

    @Override
    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    public int getLexemeCount() {
        return this.myLexemeCount;
    }

    @NotNull
    public Lexer getLexer() {
        Lexer lexer = this.myLexer;
        if (lexer == null) {
            PsiBuilderImpl.$$$reportNull$$$0(56);
        }
        return lexer;
    }

    @NotNull
    protected TreeElement createLeaf(@NotNull IElementType type2, int start, int end) {
        LeafElement element2;
        if (type2 == null) {
            PsiBuilderImpl.$$$reportNull$$$0(57);
        }
        CharSequence text = this.getInternedText(start, end);
        if (this.myWhitespaces.contains(type2)) {
            return new PsiWhiteSpaceImpl(text);
        }
        if (type2 instanceof ICustomParsingType) {
            TreeElement treeElement = (TreeElement)((ICustomParsingType)((Object)type2)).parse(text, this.myCharTable);
            if (treeElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(58);
            }
            return treeElement;
        }
        ASTFactory astFactory = this.getASTFactory();
        if (type2 instanceof ILazyParseableElementType) {
            return PsiBuilderImpl.createLazy((ILazyParseableElementType)type2, text, astFactory);
        }
        if (astFactory != null && (element2 = astFactory.createLeaf(type2, text)) != null) {
            LeafElement leafElement = element2;
            if (leafElement == null) {
                PsiBuilderImpl.$$$reportNull$$$0(59);
            }
            return leafElement;
        }
        LeafElement leafElement = ASTFactory.leaf(type2, text);
        if (leafElement == null) {
            PsiBuilderImpl.$$$reportNull$$$0(60);
        }
        return leafElement;
    }

    @NotNull
    protected CharSequence getInternedText(int start, int end) {
        CharSequence charSequence = this.myCharTable.intern(this.myText, start, end);
        if (charSequence == null) {
            PsiBuilderImpl.$$$reportNull$$$0(61);
        }
        return charSequence;
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PsiBuilderImpl.$$$reportNull$$$0(62);
        }
        return (T)(key == FileContextUtil.CONTAINING_FILE_KEY ? this.myFile : super.getUserData(key));
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            PsiBuilderImpl.$$$reportNull$$$0(63);
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            this.myFile = (PsiFile)value2;
        } else {
            super.putUserData(key, value2);
        }
    }

    static {
        CUSTOM_COMPARATOR = Key.create("CUSTOM_COMPARATOR");
        LAZY_PARSEABLE_TOKENS = Key.create("LAZY_PARSEABLE_TOKENS");
        ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/impl/PsiBuilderImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageText";
                break;
            }
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootMarker";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommittedText";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curNode";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ast";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startMarker";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "performLexing";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "precede";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "mark";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarker";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTree";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootAST";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLightTree";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createComposite";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazy";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexer";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeaf";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerWhitespaceToken";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "enforceCommentTokens";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "precede";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceOrComment";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "remapCurrentToken";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "rollbackTo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorsAfter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processDone";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doValidityChecks";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createRootAST";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedChameleon";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsed";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "insertLeaves";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "collapseLeaves";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createLazy";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createLeaf";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        private IElementType myType;
        private int myDoneLexeme;
        private ProductionMarker myFirstChild;
        private ProductionMarker myLastChild;

        StartMarker(int markerId, @NotNull PsiBuilderImpl builder2) {
            if (builder2 == null) {
                StartMarker.$$$reportNull$$$0(0);
            }
            super(markerId, builder2);
            this.myDoneLexeme = -1;
        }

        @Override
        void clean() {
            super.clean();
            this.myBuilder.myOptionalData.clean(this.markerId);
            this.myType = null;
            this.myDoneLexeme = -1;
            this.myLastChild = null;
            this.myFirstChild = null;
        }

        @Override
        public boolean tokenTextMatches(@NotNull CharSequence chars) {
            if (chars == null) {
                StartMarker.$$$reportNull$$$0(1);
            }
            if (this.myFirstChild != null) {
                throw new IllegalStateException("textMatches shouldn't be called on non-empty composite nodes");
            }
            return chars.length() == 0;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.getEndIndex()] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndIndex() {
            return this.myDoneLexeme;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            if (done) {
                this.myDoneLexeme = lexemeIndex;
            } else {
                this.myLexemeIndex = lexemeIndex;
            }
        }

        @Override
        int getLexemeIndex(boolean done) {
            return done ? this.myDoneLexeme : this.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (node == null) {
                StartMarker.$$$reportNull$$$0(2);
            }
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
            } else {
                this.myLastChild.myNext = node;
            }
            this.myLastChild = node;
        }

        @Override
        @NotNull
        public PsiBuilder.Marker precede() {
            PsiBuilder.Marker marker = this.myBuilder.precede(this);
            if (marker == null) {
                StartMarker.$$$reportNull$$$0(3);
            }
            return marker;
        }

        @Override
        public void drop() {
            this.myBuilder.myProduction.dropMarker(this);
        }

        @Override
        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        @Override
        public void done(@NotNull IElementType type2) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(4);
            }
            if (type2 == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.error() instead", new RuntimeException());
            }
            this.myType = type2;
            this.myBuilder.processDone(this, null, null);
        }

        @Override
        public void collapse(@NotNull IElementType type2) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(5);
            }
            this.done(type2);
            this.myBuilder.myOptionalData.markCollapsed(this.markerId);
        }

        @Override
        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(6);
            }
            if (before == null) {
                StartMarker.$$$reportNull$$$0(7);
            }
            if (type2 == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.errorBefore() instead", new RuntimeException());
            }
            this.myType = type2;
            this.myBuilder.processDone(this, null, (StartMarker)before);
        }

        @Override
        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before, @NotNull @Nls String errorMessage) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(8);
            }
            if (before == null) {
                StartMarker.$$$reportNull$$$0(9);
            }
            if (errorMessage == null) {
                StartMarker.$$$reportNull$$$0(10);
            }
            StartMarker marker = (StartMarker)before;
            ErrorItem errorItem = this.myBuilder.myPool.allocateErrorItem();
            errorItem.setMessage(errorMessage);
            errorItem.myLexemeIndex = marker.myLexemeIndex;
            this.myBuilder.myProduction.addBefore(errorItem, marker);
            this.doneBefore(type2, before);
        }

        @Override
        public void error(@NotNull @Nls String message) {
            if (message == null) {
                StartMarker.$$$reportNull$$$0(11);
            }
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, null);
        }

        @Override
        public void errorBefore(@NotNull @Nls String message, @NotNull PsiBuilder.Marker before) {
            if (message == null) {
                StartMarker.$$$reportNull$$$0(12);
            }
            if (before == null) {
                StartMarker.$$$reportNull$$$0(13);
            }
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, (StartMarker)before);
        }

        @Override
        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void remapTokenType(@NotNull IElementType type2) {
            if (type2 == null) {
                StartMarker.$$$reportNull$$$0(14);
            }
            this.myType = type2;
        }

        @Override
        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, left, false);
            }
            if (right != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, right, true);
            }
        }

        public String toString() {
            if (this.myLexemeIndex < 0) {
                return "<dropped>";
            }
            boolean isDone = this.isDone();
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset() - this.myBuilder.myOffset;
            int endOffset = isDone ? this.getEndOffset() - this.myBuilder.myOffset : this.myBuilder.getCurrentOffset();
            CharSequence text = originalText.subSequence(startOffset, endOffset);
            return isDone ? text.toString() : text + "\u2026";
        }

        boolean isDone() {
            return this.myDoneLexeme != -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$StartMarker";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 7: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "before";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$StartMarker";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "precede";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "tokenTextMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "doneBefore";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "errorBefore";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "remapTokenType";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<TokenRangeNode> myRangePool;
        private final LimitedPool<SingleLexemeNode> myLexemePool;
        private final StartMarker myRoot;
        private int count;
        private LighterASTNode[] nodes;

        MyTreeStructure(@NotNull StartMarker root, @Nullable MyTreeStructure parentTree) {
            if (root == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            if (parentTree == null) {
                this.myRangePool = new LimitedPool<TokenRangeNode>(1000, new LimitedPool.ObjectFactory<TokenRangeNode>(){

                    @Override
                    public void cleanup(@NotNull TokenRangeNode token) {
                        if (token == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        token.clean();
                    }

                    @Override
                    @NotNull
                    public TokenRangeNode create() {
                        return new TokenRangeNode();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "ksp/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$1", "cleanup"));
                    }
                });
                this.myLexemePool = new LimitedPool<SingleLexemeNode>(1000, new LimitedPool.ObjectFactory<SingleLexemeNode>(){

                    @Override
                    @NotNull
                    public SingleLexemeNode create() {
                        return new SingleLexemeNode();
                    }

                    @Override
                    public void cleanup(@NotNull SingleLexemeNode node) {
                        if (node == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        node.clean();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "ksp/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$2", "cleanup"));
                    }
                });
            } else {
                this.myRangePool = parentTree.myRangePool;
                this.myLexemePool = parentTree.myLexemePool;
            }
            this.myRoot = root;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            StartMarker startMarker = this.myRoot;
            if (startMarker == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            return startMarker;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(2);
            }
            if (node instanceof ProductionMarker) {
                return ((ProductionMarker)node).myParent;
            }
            if (node instanceof Token) {
                return ((Token)node).myParentNode;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node);
        }

        @Override
        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item == null) {
                MyTreeStructure.$$$reportNull$$$0(3);
            }
            if (into == null) {
                MyTreeStructure.$$$reportNull$$$0(4);
            }
            if (item instanceof LazyParseableToken) {
                FlyweightCapableTreeStructure<LighterASTNode> tree = ((LazyParseableToken)item).parseContents();
                LighterASTNode root = tree.getRoot();
                if (root instanceof ProductionMarker) {
                    ((ProductionMarker)root).myParent = ((Token)item).myParentNode;
                }
                return tree.getChildren(root, into);
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child = marker.myFirstChild;
            int lexIndex = marker.myLexemeIndex;
            while (child != null) {
                lexIndex = this.insertLeaves(lexIndex, child.myLexemeIndex, marker.myBuilder, marker);
                if (child instanceof StartMarker && child.myBuilder.isCollapsed(child)) {
                    int lastIndex = child.getEndIndex();
                    this.insertLeaf(child.getTokenType(), marker.myBuilder, child.myLexemeIndex, lastIndex, true, marker);
                } else {
                    this.ensureCapacity();
                    this.nodes[this.count++] = child;
                }
                if (child instanceof StartMarker) {
                    lexIndex = child.getEndIndex();
                }
                child = child.myNext;
            }
            this.insertLeaves(lexIndex, marker.getEndIndex(), marker.myBuilder, marker);
            into.set(this.nodes == null ? LighterASTNode.EMPTY_ARRAY : this.nodes);
            this.nodes = null;
            return this.count;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count) {
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                LighterASTNode node = nodes[i];
                if (node instanceof TokenRangeNode) {
                    this.myRangePool.recycle((TokenRangeNode)node);
                    continue;
                }
                if (!(node instanceof SingleLexemeNode)) continue;
                this.myLexemePool.recycle((SingleLexemeNode)node);
            }
        }

        private void ensureCapacity() {
            LighterASTNode[] old = this.nodes;
            if (old == null) {
                this.nodes = old = new LighterASTNode[10];
            } else if (this.count >= old.length) {
                this.nodes = Arrays.copyOf(old, this.count * 3 / 2);
            }
        }

        private int insertLeaves(int curToken, int lastIdx, @NotNull PsiBuilderImpl builder2, @NotNull StartMarker parent2) {
            if (builder2 == null) {
                MyTreeStructure.$$$reportNull$$$0(5);
            }
            if (parent2 == null) {
                MyTreeStructure.$$$reportNull$$$0(6);
            }
            lastIdx = Math.min(lastIdx, builder2.myLexemeCount);
            while (curToken < lastIdx) {
                this.insertLeaf(builder2.myLexTypes[curToken], builder2, curToken, curToken + 1, false, parent2);
                ++curToken;
            }
            return curToken;
        }

        private void insertLeaf(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder2, int startLexemeIndex, int endLexemeIndex, boolean forceInsertion, @NotNull StartMarker parent2) {
            Token lexeme;
            int end;
            int start;
            if (type2 == null) {
                MyTreeStructure.$$$reportNull$$$0(7);
            }
            if (builder2 == null) {
                MyTreeStructure.$$$reportNull$$$0(8);
            }
            if (parent2 == null) {
                MyTreeStructure.$$$reportNull$$$0(9);
            }
            if ((start = builder2.myLexStarts[startLexemeIndex]) > (end = builder2.myLexStarts[endLexemeIndex]) || !forceInsertion && start == end && !(type2 instanceof ILeafElementType)) {
                return;
            }
            if (type2 instanceof ILightLazyParseableElementType) {
                int startInFile = start + builder2.myOffset;
                LazyParseableToken token = (LazyParseableToken)builder2.myChameleonCache.get(startInFile);
                if (token == null) {
                    token = new LazyParseableToken(this, startLexemeIndex, endLexemeIndex);
                    token.initToken(type2, parent2, start, end);
                    builder2.myChameleonCache.put(startInFile, token);
                } else if (token.getBuilder() != builder2 || token.myStartIndex != startLexemeIndex || token.myEndIndex != endLexemeIndex) {
                    throw new AssertionError((Object)"Wrong chameleon cached");
                }
                lexeme = token;
            } else if (startLexemeIndex == endLexemeIndex - 1 && type2 == builder2.myLexTypes[startLexemeIndex]) {
                SingleLexemeNode single = this.myLexemePool.alloc();
                single.myParentNode = parent2;
                single.myLexemeIndex = startLexemeIndex;
                lexeme = single;
            } else {
                TokenRangeNode collapsed = this.myRangePool.alloc();
                collapsed.initToken(type2, parent2, start, end);
                lexeme = collapsed;
            }
            this.ensureCapacity();
            this.nodes[this.count++] = lexeme;
        }

        @Override
        @NotNull
        public CharSequence toString(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(10);
            }
            CharSequence charSequence = this.myRoot.myBuilder.myText.subSequence(node.getStartOffset(), node.getEndOffset());
            if (charSequence == null) {
                MyTreeStructure.$$$reportNull$$$0(11);
            }
            return charSequence;
        }

        @Override
        public int getStartOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(12);
            }
            return node.getStartOffset();
        }

        @Override
        public int getEndOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                MyTreeStructure.$$$reportNull$$$0(13);
            }
            return node.getEndOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 11: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure";
                    break;
                }
                case 2: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "into";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 11: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "insertLeaves";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "insertLeaf";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartOffset";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndOffset";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 11: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LazyParseableToken
    extends TokenRange
    implements LighterLazyParseableNode {
        private final MyTreeStructure myParentStructure;
        private final int myStartIndex;
        private final int myEndIndex;
        private FlyweightCapableTreeStructure<LighterASTNode> myParsed;

        LazyParseableToken(@NotNull MyTreeStructure parentStructure, int startIndex, int endIndex) {
            if (parentStructure == null) {
                LazyParseableToken.$$$reportNull$$$0(0);
            }
            this.myParentStructure = parentStructure;
            this.myStartIndex = startIndex;
            this.myEndIndex = endIndex;
        }

        @Override
        public PsiFile getContainingFile() {
            return this.getBuilder().myFile;
        }

        @Override
        public CharTable getCharTable() {
            return this.getBuilder().myCharTable;
        }

        @NotNull
        public FlyweightCapableTreeStructure<LighterASTNode> parseContents() {
            FlyweightCapableTreeStructure<LighterASTNode> parsed = this.myParsed;
            if (parsed == null) {
                this.myParsed = parsed = ((ILightLazyParseableElementType)((Object)this.getTokenType())).parseContents(this);
            }
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = parsed;
            if (flyweightCapableTreeStructure == null) {
                LazyParseableToken.$$$reportNull$$$0(1);
            }
            return flyweightCapableTreeStructure;
        }

        @Override
        public boolean accept(@NotNull LighterLazyParseableNode.Visitor visitor2) {
            if (visitor2 == null) {
                LazyParseableToken.$$$reportNull$$$0(2);
            }
            for (int i = this.myStartIndex; i < this.myEndIndex; ++i) {
                IElementType type2 = this.getBuilder().myLexTypes[i];
                if (visitor2.visit(type2)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private TokenSequence getParsedTokenSequence() {
            int tokenCount = this.myEndIndex - this.myStartIndex;
            if (tokenCount == 1) {
                return null;
            }
            int[] lexStarts = new int[tokenCount + 1];
            System.arraycopy(this.getBuilder().myLexStarts, this.myStartIndex, lexStarts, 0, tokenCount);
            int diff = this.getBuilder().myLexStarts[this.myStartIndex];
            int i = 0;
            while (i < tokenCount) {
                int n = i++;
                lexStarts[n] = lexStarts[n] - diff;
            }
            lexStarts[tokenCount] = this.getEndOffset() - this.getStartOffset();
            IElementType[] lexTypes = new IElementType[tokenCount + 1];
            System.arraycopy(this.getBuilder().myLexTypes, this.myStartIndex, lexTypes, 0, tokenCount);
            return new TokenSequence(lexStarts, lexTypes, tokenCount, this.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentStructure";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$LazyParseableToken";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$LazyParseableToken";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseContents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ProductionMarker
    implements Node {
        final int markerId;
        protected final PsiBuilderImpl myBuilder;
        protected int myLexemeIndex;
        protected ProductionMarker myParent;
        protected ProductionMarker myNext;

        ProductionMarker(int markerId, @NotNull PsiBuilderImpl builder2) {
            if (builder2 == null) {
                ProductionMarker.$$$reportNull$$$0(0);
            }
            this.myLexemeIndex = -1;
            this.markerId = markerId;
            this.myBuilder = builder2;
        }

        void clean() {
            this.myLexemeIndex = -1;
            this.myNext = null;
            this.myParent = null;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        public void remapTokenType(@NotNull IElementType type2) {
            if (type2 == null) {
                ProductionMarker.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        abstract void setLexemeIndex(int var1, boolean var2);

        abstract int getLexemeIndex(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$ProductionMarker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remapTokenType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ErrorItem
    extends ProductionMarker {
        private @NlsContexts.DetailedDescription String myMessage;

        ErrorItem(int markerId, @NotNull PsiBuilderImpl builder2) {
            if (builder2 == null) {
                ErrorItem.$$$reportNull$$$0(0);
            }
            super(markerId, builder2);
        }

        @Override
        void clean() {
            super.clean();
            this.myMessage = null;
        }

        void setMessage(@NlsContexts.DetailedDescription String message) {
            this.myMessage = this.myBuilder.myErrorInterner.intern(message);
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            assert (!done);
            this.myLexemeIndex = lexemeIndex;
        }

        @Override
        int getLexemeIndex(boolean done) {
            assert (!done);
            return this.myLexemeIndex;
        }

        @Override
        public boolean tokenTextMatches(@NotNull CharSequence chars) {
            if (chars == null) {
                ErrorItem.$$$reportNull$$$0(1);
            }
            return chars.length() == 0;
        }

        @Override
        public int getEndOffset() {
            return this.getStartOffset();
        }

        @Override
        public int getEndIndex() {
            return this.getStartIndex();
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = TokenType.ERROR_ELEMENT;
            if (iElementType == null) {
                ErrorItem.$$$reportNull$$$0(2);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$ErrorItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$ErrorItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "tokenTextMatches";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ConvertFromTokensToASTBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> myDelegate;
        private final ASTConverter myConverter;

        private ConvertFromTokensToASTBuilder(@NotNull StartMarker rootNode, @NotNull DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> delegate) {
            if (rootNode == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(1);
            }
            this.myDelegate = delegate;
            this.myConverter = new ASTConverter(rootNode);
        }

        @Override
        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(2);
            }
            if (oldNode == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(3);
            }
            this.myDelegate.nodeDeleted(oldParent, oldNode);
        }

        @Override
        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            if (oldParent == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(4);
            }
            if (newNode == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(5);
            }
            this.myDelegate.nodeInserted(oldParent, this.myConverter.apply((Node)newNode), pos);
        }

        @Override
        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            if (oldChild == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(6);
            }
            if (newChild == null) {
                ConvertFromTokensToASTBuilder.$$$reportNull$$$0(7);
            }
            ASTNode converted = this.myConverter.apply((Node)newChild);
            this.myDelegate.nodeReplaced(oldChild, converted);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldChild";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChild";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeDeleted";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeInserted";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeReplaced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private final TripleFunction<? super ASTNode, ? super LighterASTNode, ? super FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> myCustom;
        @NotNull
        private final List<? extends CustomLanguageASTComparator> myCustomLanguageASTComparators;
        private final MyTreeStructure myTreeStructure;

        private MyComparator(@NotNull MyTreeStructure treeStructure, @NotNull List<? extends CustomLanguageASTComparator> customLanguageASTComparators, @Nullable TripleFunction<? super ASTNode, ? super LighterASTNode, ? super FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom) {
            if (treeStructure == null) {
                MyComparator.$$$reportNull$$$0(0);
            }
            if (customLanguageASTComparators == null) {
                MyComparator.$$$reportNull$$$0(1);
            }
            this.myCustom = custom;
            this.myCustomLanguageASTComparators = customLanguageASTComparators;
            this.myTreeStructure = treeStructure;
        }

        @Override
        @NotNull
        public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            boolean newIsErrorElement;
            if (oldNode == null) {
                MyComparator.$$$reportNull$$$0(2);
            }
            if (newNode == null) {
                MyComparator.$$$reportNull$$$0(3);
            }
            ProgressIndicatorProvider.checkCanceled();
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(4);
                }
                return threeState;
            }
            if (oldIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)((Object)oldNode);
                ThreeState threeState = Objects.equals(e1.getErrorDescription(), PsiBuilderImpl.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(5);
                }
                return threeState;
            }
            ThreeState customResult = this.customCompare(oldNode, newNode);
            if (customResult != ThreeState.UNSURE) {
                ThreeState threeState = customResult;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (newNode instanceof Token) {
                IElementType type2 = newNode.getTokenType();
                Token token = (Token)newNode;
                if (oldNode instanceof ForeignLeafPsiElement) {
                    ThreeState threeState = type2 instanceof ForeignLeafType && ((ForeignLeafType)type2).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(7);
                    }
                    return threeState;
                }
                if (oldNode instanceof LeafElement) {
                    if (type2 instanceof ForeignLeafType) {
                        ThreeState threeState = ThreeState.NO;
                        if (threeState == null) {
                            MyComparator.$$$reportNull$$$0(8);
                        }
                        return threeState;
                    }
                    ThreeState threeState = ((LeafElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(9);
                    }
                    return threeState;
                }
                if (type2 instanceof ILightLazyParseableElementType) {
                    if (((TreeElement)oldNode).textMatches(token.getText())) {
                        ThreeState threeState = PsiDocumentManagerBase.isFullReparseInProgress() ? ThreeState.UNSURE : ThreeState.YES;
                        if (threeState == null) {
                            MyComparator.$$$reportNull$$$0(10);
                        }
                        return threeState;
                    }
                    ThreeState threeState = TreeUtil.isCollapsedChameleon(oldNode) ? ThreeState.NO : ThreeState.UNSURE;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(11);
                    }
                    return threeState;
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && type2 instanceof ILazyParseableElementType || oldNode.getElementType() instanceof ICustomParsingType && type2 instanceof ICustomParsingType) {
                    ThreeState threeState = ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        MyComparator.$$$reportNull$$$0(12);
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                MyComparator.$$$reportNull$$$0(13);
            }
            return threeState;
        }

        @NotNull
        private ThreeState customCompare(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            if (oldNode == null) {
                MyComparator.$$$reportNull$$$0(14);
            }
            if (newNode == null) {
                MyComparator.$$$reportNull$$$0(15);
            }
            for (CustomLanguageASTComparator customLanguageASTComparator : this.myCustomLanguageASTComparators) {
                ThreeState customComparatorResult = customLanguageASTComparator.compareAST(oldNode, newNode, this.myTreeStructure);
                if (customComparatorResult == ThreeState.UNSURE) continue;
                ThreeState threeState = customComparatorResult;
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(16);
                }
                return threeState;
            }
            if (this.myCustom != null) {
                ThreeState threeState = this.myCustom.fun(oldNode, newNode, this.myTreeStructure);
                if (threeState == null) {
                    MyComparator.$$$reportNull$$$0(17);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                MyComparator.$$$reportNull$$$0(18);
            }
            return threeState;
        }

        @Override
        public boolean typesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            IElementType n2t;
            IElementType n1t;
            if (n1 == null) {
                MyComparator.$$$reportNull$$$0(19);
            }
            if (n2 == null) {
                MyComparator.$$$reportNull$$$0(20);
            }
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).getBuilder().myWhitespaces.contains(n2.getTokenType());
            }
            if (n1 instanceof ForeignLeafPsiElement) {
                n1t = ((ForeignLeafPsiElement)n1).getForeignType();
                n2t = n2.getTokenType();
            } else {
                n1t = MyComparator.dereferenceToken(n1.getElementType());
                n2t = MyComparator.dereferenceToken(n2.getTokenType());
            }
            return Comparing.equal(n1t, n2t);
        }

        private static IElementType dereferenceToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return MyComparator.dereferenceToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        @Override
        public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 == null) {
                MyComparator.$$$reportNull$$$0(21);
            }
            if (n2 == null) {
                MyComparator.$$$reportNull$$$0(22);
            }
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
                boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
                if (isForeign1 != isForeign2) {
                    return false;
                }
                if (isForeign1) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(((Token)n2).getText());
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Objects.equals((e1 = (PsiErrorElement)((Object)n1)).getErrorDescription(), PsiBuilderImpl.getErrorMessage(n2))) {
                return false;
            }
            return ((Node)n2).tokenTextMatches(n1.getChars());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeStructure";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customLanguageASTComparators";
                    break;
                }
                case 2: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 3: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$MyComparator";
                    break;
                }
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n1";
                    break;
                }
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$MyComparator";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deepEqual";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "customCompare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deepEqual";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "customCompare";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "typesEqual";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "hashCodesEqual";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start, int end) {
            this.myStart = start;
            this.mySize = end - start;
        }

        @Override
        public IElementType get(int index) {
            return PsiBuilderImpl.this.myLexTypes[this.myStart + index];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start) {
            this.myStart = start;
        }

        @Override
        @NotNull
        public CharSequence get(int i) {
            return new CharSequenceSubSequence(PsiBuilderImpl.this.myText, PsiBuilderImpl.this.myLexStarts[this.myStart + i], PsiBuilderImpl.this.myLexStarts[this.myStart + i + 1]);
        }
    }

    private static final class ASTConverter
    implements Function<Node, ASTNode> {
        private final StartMarker myRoot;

        private ASTConverter(@NotNull StartMarker root) {
            if (root == null) {
                ASTConverter.$$$reportNull$$$0(0);
            }
            this.myRoot = root;
        }

        @Override
        public ASTNode apply(Node n) {
            if (n instanceof Token) {
                Token token = (Token)n;
                return token.getBuilder().createLeaf(token.getTokenType(), token.getStartOffsetInBuilder(), token.getEndOffsetInBuilder());
            }
            if (n instanceof ErrorItem) {
                return Factory.createErrorElement(((ErrorItem)n).myMessage);
            }
            StartMarker startMarker = (StartMarker)n;
            CompositeElement composite = n == this.myRoot ? (CompositeElement)this.myRoot.myBuilder.createRootAST(this.myRoot) : PsiBuilderImpl.createComposite(startMarker, startMarker.myBuilder.getASTFactory());
            startMarker.myBuilder.bind(startMarker, composite);
            return composite;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "ksp/com/intellij/lang/impl/PsiBuilderImpl$ASTConverter", "<init>"));
        }
    }

    private static class SingleLexemeNode
    extends Token
    implements LighterASTTokenNode {
        private int myLexemeIndex;

        private SingleLexemeNode() {
        }

        @Override
        int getStartOffsetInBuilder() {
            return this.getBuilder().myLexStarts[this.myLexemeIndex];
        }

        @Override
        int getEndOffsetInBuilder() {
            return this.getBuilder().myLexStarts[this.myLexemeIndex + 1];
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = this.getBuilder().myLexTypes[this.myLexemeIndex];
            if (iElementType == null) {
                SingleLexemeNode.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/lang/impl/PsiBuilderImpl$SingleLexemeNode", "getTokenType"));
        }
    }

    private static class TokenRangeNode
    extends TokenRange
    implements LighterASTTokenNode {
        private TokenRangeNode() {
        }
    }

    private static abstract class TokenRange
    extends Token {
        private int myTokenStart;
        private int myTokenEnd;
        private IElementType myTokenType;

        private TokenRange() {
        }

        @Override
        int getStartOffsetInBuilder() {
            return this.myTokenStart;
        }

        @Override
        int getEndOffsetInBuilder() {
            return this.myTokenEnd;
        }

        @Override
        public IElementType getTokenType() {
            return this.myTokenType;
        }

        void initToken(@NotNull IElementType type2, @NotNull StartMarker parent2, int start, int end) {
            if (type2 == null) {
                TokenRange.$$$reportNull$$$0(0);
            }
            if (parent2 == null) {
                TokenRange.$$$reportNull$$$0(1);
            }
            this.myParentNode = parent2;
            this.myTokenType = type2;
            this.myTokenStart = start;
            this.myTokenEnd = end;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$TokenRange";
            objectArray[2] = "initToken";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Token
    implements Node {
        StartMarker myParentNode;

        private Token() {
        }

        @Override
        public boolean tokenTextMatches(@NotNull CharSequence chars) {
            if (chars == null) {
                Token.$$$reportNull$$$0(0);
            }
            int start = this.getStartOffsetInBuilder();
            int end = this.getEndOffsetInBuilder();
            if (end - start != chars.length()) {
                return false;
            }
            PsiBuilderImpl builder2 = this.getBuilder();
            return builder2.myTextArray != null ? CharArrayUtil.regionMatches(builder2.myTextArray, start, end, chars) : CharArrayUtil.regionMatches(builder2.myText, start, end, chars);
        }

        @Override
        public final int getEndOffset() {
            return this.getEndOffsetInBuilder() + this.getBuilder().myOffset;
        }

        @Override
        public final int getStartOffset() {
            return this.getStartOffsetInBuilder() + this.getBuilder().myOffset;
        }

        @NotNull
        public final CharSequence getText() {
            if (this.getTokenType() instanceof TokenWrapper) {
                String string2 = ((TokenWrapper)this.getTokenType()).getValue();
                if (string2 == null) {
                    Token.$$$reportNull$$$0(1);
                }
                return string2;
            }
            CharSequence charSequence = this.getBuilder().myText.subSequence(this.getStartOffsetInBuilder(), this.getEndOffsetInBuilder());
            if (charSequence == null) {
                Token.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        @NotNull
        PsiBuilderImpl getBuilder() {
            PsiBuilderImpl psiBuilderImpl = this.myParentNode.myBuilder;
            if (psiBuilderImpl == null) {
                Token.$$$reportNull$$$0(3);
            }
            return psiBuilderImpl;
        }

        abstract int getStartOffsetInBuilder();

        abstract int getEndOffsetInBuilder();

        void clean() {
            this.myParentNode = null;
        }

        public String toString() {
            return this.getText().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$Token";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/lang/impl/PsiBuilderImpl$Token";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "tokenTextMatches";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface Node
    extends LighterASTNode {
        public boolean tokenTextMatches(@NotNull CharSequence var1);
    }
}

