/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.annotations.GwtIncompatible;
import ksp.com.google.common.annotations.J2ktIncompatible;
import ksp.com.google.common.base.Preconditions;
import ksp.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.collect.ImmutableList;
import ksp.com.google.common.collect.ImmutableSet;
import ksp.com.google.common.collect.Iterators;
import ksp.com.google.common.collect.UnmodifiableIterator;
import ksp.javax.annotation.CheckForNull;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element2) {
        this.element = Preconditions.checkNotNull(element2);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

