/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.load.java.lazy.descriptors.JavaDescriptorUtilKt;
import ksp.org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import ksp.org.jetbrains.kotlin.resolve.calls.results.PlatformOverloadsSpecificityComparator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/JvmPlatformOverloadsSpecificityComparator;", "Lksp/org/jetbrains/kotlin/resolve/calls/results/PlatformOverloadsSpecificityComparator;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isMoreSpecificShape", "", "specific", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "general", "frontend.java"})
public final class JvmPlatformOverloadsSpecificityComparator
implements PlatformOverloadsSpecificityComparator {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public JvmPlatformOverloadsSpecificityComparator(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    public boolean isMoreSpecificShape(@NotNull CallableDescriptor specific, @NotNull CallableDescriptor general) {
        Intrinsics.checkNotNullParameter((Object)specific, (String)"specific");
        Intrinsics.checkNotNullParameter((Object)general, (String)"general");
        if (!(specific instanceof PropertyDescriptor) || !(general instanceof PropertyDescriptor)) {
            return false;
        }
        if (((PropertyDescriptor)specific).getDispatchReceiverParameter() == null || ((PropertyDescriptor)general).getDispatchReceiverParameter() == null) {
            return false;
        }
        if (!(((PropertyDescriptor)specific).getContainingDeclaration() instanceof ClassDescriptor)) {
            return false;
        }
        if (!DescriptorEquivalenceForOverrides.areEquivalent$default(DescriptorEquivalenceForOverrides.INSTANCE, ((PropertyDescriptor)specific).getContainingDeclaration(), ((PropertyDescriptor)general).getContainingDeclaration(), true, false, 8, null)) {
            return false;
        }
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.PreferJavaFieldOverload)) {
            return false;
        }
        return JavaDescriptorUtilKt.isJavaField((PropertyDescriptor)specific) && !JavaDescriptorUtilKt.isJavaField((PropertyDescriptor)general);
    }
}

