/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.Named;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import ksp.org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/UselessElvisCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class UselessElvisCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!Intrinsics.areEqual((Object)((Named)resolvedCall2.getResultingDescriptor()).getName(), (Object)ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName())) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression elvisBinaryExpression = ktBinaryExpression;
        KtExpression ktExpression = elvisBinaryExpression.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = elvisBinaryExpression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        KotlinType kotlinType = context2.getTrace().getType(left);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        if (KotlinTypeKt.isError(leftType) || TypeUtilsKt.contains(leftType, (Function1<? super UnwrappedType, Boolean>)((Function1)UselessElvisCallChecker::check$lambda$0))) {
            return;
        }
        if (!TypeUtils.isNullableType(leftType)) {
            BindingTrace bindingTrace = context2.getTrace();
            ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), leftType);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            return;
        }
        DataFlowValue dataFlowValue = context2.getDataFlowValueFactory().createDataFlowValue(left, leftType, context2.getResolutionContext());
        if (context2.getDataFlowInfo().getStableNullability(dataFlowValue) == Nullability.NOT_NULL) {
            BindingTrace bindingTrace = context2.getTrace();
            ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), leftType);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            return;
        }
        if (KtPsiUtil.isNullConstant(right) && !FlexibleTypesKt.isNullabilityFlexible(leftType)) {
            BindingTrace bindingTrace = context2.getTrace();
            SimpleDiagnostic<KtBinaryExpression> simpleDiagnostic = Errors.USELESS_ELVIS_RIGHT_IS_NULL.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression));
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private static final boolean check$lambda$0(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getConstructor() instanceof TypeVariableTypeConstructor;
    }
}

