/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.reference;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import ksp.org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.CompanionObjectIntrinsicAccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.ReferenceAccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import ksp.org.jetbrains.kotlin.name.FqNameUnsafe;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtQualifiedExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import ksp.org.jetbrains.kotlin.types.KotlinType;

public final class ReferenceTranslator {
    private static final Set<FqNameUnsafe> DECLARATIONS_WITHOUT_SIDE_EFFECTS = new HashSet<FqNameUnsafe>(Arrays.asList(new FqNameUnsafe("kotlin.coroutines.experimental.intrinsics.COROUTINE_SUSPENDED"), new FqNameUnsafe("kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED"), StandardNames.FqNames.unit));

    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(1);
        }
        JsExpression jsExpression = ReferenceTranslator.getAccessTranslator(expression2, context2).translateAsGet();
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(2);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsValueReference(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(4);
        }
        JsExpression result2 = ReferenceTranslator.translateAsValueReferenceWithoutType(descriptor, context2);
        MetadataProperties.setType(result2, ReferenceTranslator.getType(descriptor));
        if (ReferenceTranslator.isValueWithoutSideEffect(descriptor)) {
            MetadataProperties.setUnit(result2, true);
            MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
            MetadataProperties.setSynthetic(result2, true);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(5);
        }
        return jsExpression;
    }

    @Nullable
    private static KotlinType getType(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(6);
        }
        if (descriptor instanceof ClassDescriptor) {
            return ((ClassDescriptor)descriptor).getDefaultType();
        }
        if (descriptor instanceof CallableDescriptor) {
            if (descriptor instanceof ValueParameterDescriptor) {
                ValueParameterDescriptor parameter2 = (ValueParameterDescriptor)descriptor;
                if (parameter2.getContainingDeclaration() instanceof AnonymousFunctionDescriptor) {
                    return DescriptorUtils.getContainingModule(descriptor).getBuiltIns().getAnyType();
                }
                if (parameter2.getContainingDeclaration() instanceof PropertySetterDescriptor) {
                    PropertySetterDescriptor setter2 = (PropertySetterDescriptor)parameter2.getContainingDeclaration();
                    return TranslationUtils.getReturnTypeForCoercion(setter2.getCorrespondingProperty(), false);
                }
            }
            return ((CallableDescriptor)descriptor).getReturnType();
        }
        return null;
    }

    @NotNull
    private static JsExpression translateAsValueReferenceWithoutType(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(8);
        }
        if (AnnotationsUtils.isNativeObject(descriptor) || AnnotationsUtils.isLibraryObject(descriptor)) {
            JsExpression jsExpression = context2.getInnerReference(descriptor);
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(9);
            }
            return jsExpression;
        }
        JsExpression alias = context2.getAliasForDescriptor(descriptor);
        if (alias != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(10);
            }
            return jsExpression;
        }
        if (ReferenceTranslator.shouldTranslateAsFQN(descriptor)) {
            JsExpression jsExpression = context2.getQualifiedReference(descriptor);
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(11);
            }
            return jsExpression;
        }
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor property = (PropertyDescriptor)descriptor;
            if (ReferenceTranslator.isLocallyAvailableDeclaration(context2, property) || ReferenceTranslator.isValueWithoutSideEffect(property)) {
                JsExpression jsExpression = context2.getInnerReference(property);
                if (jsExpression == null) {
                    ReferenceTranslator.$$$reportNull$$$0(12);
                }
                return jsExpression;
            }
            JsExpression qualifier2 = context2.getInnerReference(property.getContainingDeclaration());
            JsName name2 = context2.getNameForDescriptor(property);
            return new JsNameRef(name2, qualifier2);
        }
        if (DescriptorUtils.isObject(descriptor) || DescriptorUtils.isEnumEntry(descriptor)) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
            if (!ReferenceTranslator.isLocallyAvailableDeclaration(context2, descriptor)) {
                if (ReferenceTranslator.isValueWithoutSideEffect(classDescriptor)) {
                    JsExpression jsExpression = context2.getInnerReference(descriptor);
                    if (jsExpression == null) {
                        ReferenceTranslator.$$$reportNull$$$0(13);
                    }
                    return jsExpression;
                }
                return ReferenceTranslator.getLazyReferenceToObject(classDescriptor, context2);
            }
            JsNameRef functionRef = JsAstUtils.pureFqn(context2.getNameForObjectInstance(classDescriptor), null);
            return new JsInvocation((JsExpression)functionRef, new JsExpression[0]);
        }
        JsExpression jsExpression = context2.getInnerReference(descriptor);
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(14);
        }
        return jsExpression;
    }

    private static boolean isValueWithoutSideEffect(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(15);
        }
        return DECLARATIONS_WITHOUT_SIDE_EFFECTS.contains(DescriptorUtils.getFqName(descriptor));
    }

    @NotNull
    public static JsExpression translateAsTypeReference(@NotNull ClassDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(17);
        }
        if (AnnotationsUtils.isNativeObject(descriptor) || AnnotationsUtils.isLibraryObject(descriptor)) {
            JsExpression jsExpression = context2.getInnerReference(descriptor);
            if (jsExpression == null) {
                ReferenceTranslator.$$$reportNull$$$0(18);
            }
            return jsExpression;
        }
        if ((DescriptorUtils.isObject(descriptor) || DescriptorUtils.isEnumEntry(descriptor)) && !ReferenceTranslator.isLocallyAvailableDeclaration(context2, descriptor)) {
            return ReferenceTranslator.getPrototypeIfNecessary(descriptor, ReferenceTranslator.getLazyReferenceToObject(descriptor, context2));
        }
        JsExpression jsExpression = context2.getInnerReference(descriptor);
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(19);
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression getPrototypeIfNecessary(@NotNull ClassDescriptor descriptor, @NotNull JsExpression reference2) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(20);
        }
        if (reference2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(21);
        }
        if (DescriptorUtils.isObject(descriptor) || DescriptorUtils.isEnumEntry(descriptor)) {
            JsNameRef getPrototypeRef = JsAstUtils.pureFqn("getPrototypeOf", (JsExpression)JsAstUtils.pureFqn("Object", null));
            JsInvocation getPrototypeInvocation = new JsInvocation((JsExpression)getPrototypeRef, reference2);
            MetadataProperties.setSideEffects(getPrototypeInvocation, SideEffectKind.PURE);
            reference2 = JsAstUtils.pureFqn("constructor", (JsExpression)getPrototypeInvocation);
        }
        JsExpression jsExpression = reference2;
        if (jsExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(22);
        }
        return jsExpression;
    }

    private static boolean isLocallyAvailableDeclaration(@NotNull TranslationContext context2, @NotNull DeclarationDescriptor descriptor) {
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(23);
        }
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(24);
        }
        return context2.isFromCurrentModule(descriptor) && (!context2.isPublicInlineFunction() || !DescriptorUtilsKt.shouldBeExported(descriptor, context2.getConfig()));
    }

    @NotNull
    private static JsExpression getLazyReferenceToObject(@NotNull ClassDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(25);
        }
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(26);
        }
        DeclarationDescriptor container = descriptor.getContainingDeclaration();
        JsExpression qualifier2 = context2.getInnerReference(container);
        return new JsNameRef(context2.getNameForDescriptor(descriptor), qualifier2);
    }

    private static boolean shouldTranslateAsFQN(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            ReferenceTranslator.$$$reportNull$$$0(27);
        }
        return ReferenceTranslator.isLocalVarOrFunction(descriptor);
    }

    private static boolean isLocalVarOrFunction(DeclarationDescriptor descriptor) {
        return descriptor.getContainingDeclaration() instanceof FunctionDescriptor && !(descriptor instanceof ClassDescriptor);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TranslationContext context2) {
        if (referenceExpression == null) {
            ReferenceTranslator.$$$reportNull$$$0(28);
        }
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(29);
        }
        if (DescriptorPsiUtilsKt.isBackingFieldReference(BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), referenceExpression))) {
            BackingFieldAccessTranslator backingFieldAccessTranslator = BackingFieldAccessTranslator.newInstance(referenceExpression, context2);
            if (backingFieldAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(30);
            }
            return backingFieldAccessTranslator;
        }
        if (ReferenceTranslator.canBePropertyAccess(referenceExpression, context2)) {
            VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context2, referenceExpression, null);
            if (variableAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(31);
            }
            return variableAccessTranslator;
        }
        if (CompanionObjectIntrinsicAccessTranslator.isCompanionObjectReference(referenceExpression, context2)) {
            CompanionObjectIntrinsicAccessTranslator companionObjectIntrinsicAccessTranslator = CompanionObjectIntrinsicAccessTranslator.newInstance(referenceExpression, context2);
            if (companionObjectIntrinsicAccessTranslator == null) {
                ReferenceTranslator.$$$reportNull$$$0(32);
            }
            return companionObjectIntrinsicAccessTranslator;
        }
        ReferenceAccessTranslator referenceAccessTranslator = ReferenceAccessTranslator.newInstance(referenceExpression, context2);
        if (referenceAccessTranslator == null) {
            ReferenceTranslator.$$$reportNull$$$0(33);
        }
        return referenceAccessTranslator;
    }

    public static boolean canBePropertyAccess(@NotNull KtExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(34);
        }
        if (context2 == null) {
            ReferenceTranslator.$$$reportNull$$$0(35);
        }
        KtSimpleNameExpression simpleNameExpression = null;
        if (expression2 instanceof KtQualifiedExpression) {
            simpleNameExpression = PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression2);
        } else if (expression2 instanceof KtSimpleNameExpression) {
            simpleNameExpression = (KtSimpleNameExpression)expression2;
        }
        if (simpleNameExpression == null) {
            return false;
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), simpleNameExpression);
        return descriptor instanceof VariableDescriptor && !(descriptor instanceof ValueParameterDescriptor) && !(descriptor instanceof FakeCallableDescriptorForTypeAliasObject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 17: 
            case 23: 
            case 26: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "translateSimpleName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsValueReference";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsValueReferenceWithoutType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsTypeReference";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrototypeIfNecessary";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translateSimpleName";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "translateAsValueReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "translateAsValueReferenceWithoutType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValueWithoutSideEffect";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "translateAsTypeReference";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPrototypeIfNecessary";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLocallyAvailableDeclaration";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLazyReferenceToObject";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldTranslateAsFQN";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "canBePropertyAccess";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

