/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirQualifierPart;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\"\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\u0010\u001a\u00020\u0001*\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0012H\u0002\"\u0015\u0010\n\u001a\u00020\t*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0014"}, d2={"checkUnderscoreDiagnostics", "", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isExpression", "", "isUnderscore", "", "(Ljava/lang/CharSequence;)Z", "checkTypeRefForUnderscore", "typeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "forEachQualifierPart", "block", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/fir/types/FirQualifierPart;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnderscoreHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnderscoreHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirUnderscoreHelpersKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1069#2,2:66\n1863#3,2:68\n*S KotlinDebug\n*F\n+ 1 FirUnderscoreHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirUnderscoreHelpersKt\n*L\n39#1:66,2\n63#1:68,2\n*E\n"})
public final class FirUnderscoreHelpersKt {
    public static final void checkUnderscoreDiagnostics(@Nullable KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, boolean isExpression) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object = source;
        if (object == null || (object = ((KtSourceElement)object).getKind()) == null) {
            return;
        }
        Object sourceKind = object;
        if (sourceKind instanceof KtRealSourceElementKind || sourceKind instanceof KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess) {
            SourceNavigator $this$checkUnderscoreDiagnostics_u24lambda_u240 = SourceNavigator.Companion.forSource(source);
            boolean bl = false;
            CharSequence charSequence = $this$checkUnderscoreDiagnostics_u24lambda_u240.getRawIdentifier(source);
            boolean bl2 = charSequence != null ? FirUnderscoreHelpersKt.isUnderscore(charSequence) : false;
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, isExpression ? FirErrors.INSTANCE.getUNDERSCORE_USAGE_WITHOUT_BACKTICKS() : FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    public static final boolean isUnderscore(@NotNull CharSequence $this$isUnderscore) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isUnderscore, (String)"<this>");
            CharSequence $this$all$iv = $this$isUnderscore;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '_') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public static final void checkTypeRefForUnderscore(@Nullable FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (typeRef instanceof FirErrorTypeRef) {
                return;
            }
            FirTypeRef firTypeRef = typeRef;
            if (firTypeRef == null) break block1;
            FirUnderscoreHelpersKt.forEachQualifierPart(firTypeRef, (Function1<? super FirQualifierPart, Unit>)((Function1)arg_0 -> FirUnderscoreHelpersKt.checkTypeRefForUnderscore$lambda$2(context2, reporter, arg_0)));
        }
    }

    private static final void forEachQualifierPart(FirTypeRef $this$forEachQualifierPart, Function1<? super FirQualifierPart, Unit> block) {
        block1: {
            FirResolvedTypeRef firResolvedTypeRef = $this$forEachQualifierPart instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$forEachQualifierPart : null;
            FirTypeRef delegatedTypeRef = firResolvedTypeRef != null ? firResolvedTypeRef.getDelegatedTypeRef() : null;
            Object object = delegatedTypeRef instanceof FirUserTypeRef ? (FirUserTypeRef)delegatedTypeRef : null;
            if (object == null || (object = ((FirUserTypeRef)object).getQualifier()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                block.invoke(element$iv);
            }
        }
    }

    private static final Unit checkTypeRefForUnderscore$lambda$2(CheckerContext $context, DiagnosticReporter $reporter, FirQualifierPart qualifierPart) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$reporter, (String)"$reporter");
        Intrinsics.checkNotNullParameter((Object)qualifierPart, (String)"qualifierPart");
        FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(qualifierPart.getSource(), $context, $reporter, true);
        for (FirTypeProjection typeArgument : qualifierPart.getTypeArgumentList().getTypeArguments()) {
            if (typeArgument instanceof FirTypeProjectionWithVariance) {
                FirUnderscoreHelpersKt.checkTypeRefForUnderscore(((FirTypeProjectionWithVariance)typeArgument).getTypeRef(), $context, $reporter);
                continue;
            }
            FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(typeArgument.getSource(), $context, $reporter, true);
        }
        return Unit.INSTANCE;
    }
}

