/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cli.common.messages;

import java.util.EnumSet;
import ksp.org.jetbrains.annotations.NotNull;

public enum CompilerMessageSeverity {
    EXCEPTION,
    ERROR,
    STRONG_WARNING,
    WARNING,
    INFO,
    LOGGING,
    OUTPUT;

    public static final EnumSet<CompilerMessageSeverity> VERBOSE;

    public boolean isError() {
        return this == EXCEPTION || this == ERROR;
    }

    public boolean isWarning() {
        return this == STRONG_WARNING || this == WARNING;
    }

    @NotNull
    public String getPresentableName() {
        switch (this) {
            case EXCEPTION: {
                return "exception";
            }
            case ERROR: {
                return "error";
            }
            case STRONG_WARNING: 
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case LOGGING: {
                return "logging";
            }
            case OUTPUT: {
                return "output";
            }
        }
        throw new UnsupportedOperationException("Unknown severity: " + (Object)((Object)this));
    }

    static {
        VERBOSE = EnumSet.of(LOGGING);
    }
}

