/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.State;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.TypePathInfo;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeArgument;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeProjection;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import ksp.org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002J\u0014\u0010\u000e\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\b*\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/codegen/IrTypeAnnotationCollector;", "", "<init>", "()V", "state", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/State;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "collectTypeAnnotations", "", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/TypePathInfo;", "kotlinType", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "gatherTypeAnnotations", "", "process", "step", "", "extractAnnotations", "isCompiledToJvm8OrHigher", "", "source", "Lksp/org/jetbrains/kotlin/descriptors/SourceElement;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nIrTypeAnnotationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeAnnotationCollector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/IrTypeAnnotationCollector\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n188#2:100\n774#3:101\n865#3,2:102\n*S KotlinDebug\n*F\n+ 1 IrTypeAnnotationCollector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/IrTypeAnnotationCollector\n*L\n56#1:100\n79#1:101\n79#1:102,2\n*E\n"})
public final class IrTypeAnnotationCollector {
    @NotNull
    private final State<IrConstructorCall> state = new State(new ArrayList());

    @NotNull
    public final List<TypePathInfo<IrConstructorCall>> collectTypeAnnotations(@NotNull IrType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        this.gatherTypeAnnotations(kotlinType);
        return this.state.getResults();
    }

    /*
     * WARNING - void declaration
     */
    private final void gatherTypeAnnotations(IrType $this$gatherTypeAnnotations) {
        void $this$ifNotEmpty$iv;
        Object object = IrTypesKt.getClassOrNull($this$gatherTypeAnnotations);
        boolean bl = object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).isInner() : false;
        if (bl) {
            return;
        }
        Object object2 = this.extractAnnotations($this$gatherTypeAnnotations);
        State<IrConstructorCall> state = this.state;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List p0 = (List)$this$ifNotEmpty$iv;
            boolean bl2 = false;
            state.rememberAnnotations(p0);
        }
        if (!($this$gatherTypeAnnotations instanceof IrSimpleType)) {
            return;
        }
        object2 = ((Iterable)((IrSimpleType)$this$gatherTypeAnnotations).getArguments()).iterator();
        int n = 0;
        while (object2.hasNext()) {
            int index = n++;
            IrTypeArgument argument = (IrTypeArgument)object2.next();
            if (!(argument instanceof IrTypeProjection) || ((IrTypeProjection)argument).getVariance() != Variance.INVARIANT) continue;
            if (IrTypePredicatesKt.isArray($this$gatherTypeAnnotations) || IrTypePredicatesKt.isNullableArray($this$gatherTypeAnnotations)) {
                this.process(((IrTypeProjection)argument).getType(), "[");
                continue;
            }
            this.process(((IrTypeProjection)argument).getType(), "" + index + ';');
        }
    }

    private final void process(IrType $this$process, String step) {
        this.state.addStep(step);
        this.gatherTypeAnnotations($this$process);
        this.state.removeStep();
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrConstructorCall> extractAnnotations(IrType $this$extractAnnotations) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$extractAnnotations.getAnnotations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrConstructorCall it = (IrConstructorCall)element$iv$iv;
            boolean bl = false;
            IrClass annotationClass = IrUtilsKt.getParentAsClass(it.getSymbol().getOwner());
            if (!(!Intrinsics.areEqual((Object)annotationClass.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_DECLARATION_STUB()) && !Intrinsics.areEqual((Object)annotationClass.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || this.isCompiledToJvm8OrHigher(annotationClass))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompiledToJvm8OrHigher(SourceElement source) {
        if (!(source instanceof KotlinJvmBinarySourceElement)) return true;
        KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
        if (!(kotlinJvmBinaryClass instanceof FileBasedKotlinClass)) return false;
        FileBasedKotlinClass fileBasedKotlinClass = (FileBasedKotlinClass)kotlinJvmBinaryClass;
        if (fileBasedKotlinClass == null) return false;
        int n = fileBasedKotlinClass.getClassVersion();
        if (n < 52) return false;
        return true;
    }

    private final boolean isCompiledToJvm8OrHigher(IrClass $this$isCompiledToJvm8OrHigher) {
        return (Intrinsics.areEqual((Object)$this$isCompiledToJvm8OrHigher.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_DECLARATION_STUB()) || Intrinsics.areEqual((Object)$this$isCompiledToJvm8OrHigher.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB())) && this.isCompiledToJvm8OrHigher($this$isCompiledToJvm8OrHigher.getSource());
    }
}

