/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower.loops;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.ir.Symbols;
import ksp.org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ComparableRangeInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetLoopHeader;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.IterableLoopHeader;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ProgressionLoopHeader;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.WithIndexHeaderInfo;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.WithIndexLoopHeader;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "", "context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "scopeOwnerSymbol", "Lkotlin/Function0;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;Lkotlin/jvm/functions/Function0;)V", "symbols", "Lksp/org/jetbrains/kotlin/backend/common/ir/Symbols;", "extractHeader", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "variable", "Lksp/org/jetbrains/kotlin/ir/declarations/IrVariable;", "ir.backend.common"})
public final class HeaderProcessor {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final HeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final Function0<IrSymbol> scopeOwnerSymbol;
    @NotNull
    private final Symbols symbols;

    public HeaderProcessor(@NotNull CommonBackendContext context2, @NotNull HeaderInfoBuilder headerInfoBuilder2, @NotNull Function0<? extends IrSymbol> scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)headerInfoBuilder2, (String)"headerInfoBuilder");
        Intrinsics.checkNotNullParameter(scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        this.context = context2;
        this.headerInfoBuilder = headerInfoBuilder2;
        this.scopeOwnerSymbol = scopeOwnerSymbol;
        this.symbols = this.context.getIr().getSymbols();
    }

    @Nullable
    public final ForLoopHeader extractHeader(@NotNull IrVariable variable) {
        ForLoopHeader forLoopHeader;
        IrExpression iterable;
        Object object;
        IrExpression irExpression;
        IrCall iteratorCall;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        boolean bl = Intrinsics.areEqual((Object)variable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_ITERATOR());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!IrTypeUtilsKt.isSubtypeOfClass(variable.getType(), this.symbols.getIterator())) {
            return null;
        }
        IrExpression irExpression2 = variable.getInitializer();
        IrCall irCall = iteratorCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
        if (irCall != null) {
            IrCall $this$extractHeader_u24lambda_u240 = irCall;
            boolean bl2 = false;
            irExpression = $this$extractHeader_u24lambda_u240.getExtensionReceiver() != null ? $this$extractHeader_u24lambda_u240.getExtensionReceiver() : $this$extractHeader_u24lambda_u240.getDispatchReceiver();
        } else {
            irExpression = null;
        }
        if ((object = (iterable = irExpression)) == null || (object = (HeaderInfo)object.accept(this.headerInfoBuilder, iteratorCall)) == null) {
            return null;
        }
        Object headerInfo = object;
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)this.scopeOwnerSymbol.invoke(), variable.getStartOffset(), variable.getEndOffset());
        Object object2 = headerInfo;
        if (object2 instanceof IndexedGetHeaderInfo) {
            forLoopHeader = new IndexedGetLoopHeader((IndexedGetHeaderInfo)headerInfo, builder2, this.context);
        } else if (object2 instanceof ProgressionHeaderInfo) {
            forLoopHeader = new ProgressionLoopHeader((ProgressionHeaderInfo)headerInfo, builder2, this.context);
        } else if (object2 instanceof WithIndexHeaderInfo) {
            forLoopHeader = new WithIndexLoopHeader((WithIndexHeaderInfo)headerInfo, builder2, this.context);
        } else if (object2 instanceof IterableHeaderInfo) {
            forLoopHeader = new IterableLoopHeader((IterableHeaderInfo)headerInfo);
        } else {
            if (object2 instanceof FloatingPointRangeHeaderInfo || object2 instanceof ComparableRangeInfo) {
                throw new IllegalStateException(("Unexpected " + Reflection.getOrCreateKotlinClass(headerInfo.getClass()).getSimpleName() + " for loops").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return forLoopHeader;
    }
}

