/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lksp/org/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector;", "", "expectTopLevelClasses", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "<init>", "(Ljava/util/Map;)V", "actualClasses", "", "actualTypeAliasesWithoutExpansion", "Lksp/org/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "actualTopLevels", "Lksp/org/jetbrains/kotlin/name/CallableId;", "", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbolsToFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitedActualClasses", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "currentFile", "collect", "", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "recordMappingsForNestedClassesActualizedViaTypealias", "typealiasClassId", "actualClassSymbol", "recordActualCallable", "callableDeclaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "callableId", "Companion", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,361:1\n381#2,7:362\n678#3:369\n708#3,4:370\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n*L\n215#1:362,7\n199#1:369\n199#1:370,4\n*E\n"})
final class ActualDeclarationsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ClassId, IrClassSymbol> expectTopLevelClasses;
    @NotNull
    private final Map<ClassId, IrClassSymbol> actualClasses;
    @NotNull
    private final Map<ClassId, IrTypeAliasSymbol> actualTypeAliasesWithoutExpansion;
    @NotNull
    private final Map<CallableId, List<IrSymbol>> actualTopLevels;
    @NotNull
    private final Map<IrSymbol, IrFile> actualSymbolsToFile;
    @NotNull
    private final Set<IrClass> visitedActualClasses;
    @Nullable
    private IrFile currentFile;

    public ActualDeclarationsCollector(@NotNull Map<ClassId, ? extends IrClassSymbol> expectTopLevelClasses) {
        Intrinsics.checkNotNullParameter(expectTopLevelClasses, (String)"expectTopLevelClasses");
        this.expectTopLevelClasses = expectTopLevelClasses;
        this.actualClasses = new LinkedHashMap();
        this.actualTypeAliasesWithoutExpansion = new LinkedHashMap();
        this.actualTopLevels = new LinkedHashMap();
        this.actualSymbolsToFile = new LinkedHashMap();
        this.visitedActualClasses = new LinkedHashSet();
    }

    private final void collect(IrElement element2) {
        IrElement irElement = element2;
        if (irElement instanceof IrModuleFragment) {
            for (IrFile file2 : ((IrModuleFragment)element2).getFiles()) {
                this.collect(file2);
            }
        } else if (irElement instanceof IrFile) {
            this.currentFile = (IrFile)element2;
            for (IrDeclaration declaration2 : ((IrFile)element2).getDeclarations()) {
                this.collect(declaration2);
            }
        } else if (irElement instanceof IrTypeAlias) {
            if (!((IrTypeAlias)element2).isActual()) {
                return;
            }
            ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail((IrTypeAlias)element2);
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(((IrTypeAlias)element2).getExpandedType());
            Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            IrClassSymbol expandedTypeSymbol = (IrClassSymbol)irClassifierSymbol;
            this.actualClasses.put(classId, expandedTypeSymbol);
            this.actualTypeAliasesWithoutExpansion.put(classId, ((IrTypeAlias)element2).getSymbol());
            this.actualSymbolsToFile.put(expandedTypeSymbol, this.currentFile);
            this.actualSymbolsToFile.put(((IrTypeAlias)element2).getSymbol(), this.currentFile);
            this.collect(expandedTypeSymbol.getOwner());
            this.recordMappingsForNestedClassesActualizedViaTypealias(classId, expandedTypeSymbol);
        } else if (irElement instanceof IrClass) {
            if (((IrClass)element2).isExpect() || !this.visitedActualClasses.add((IrClass)element2)) {
                return;
            }
            this.actualClasses.put(AdditionalIrUtilsKt.getClassIdOrFail((IrClass)element2), ((IrClass)element2).getSymbol());
            this.actualSymbolsToFile.put(((IrClass)element2).getSymbol(), this.currentFile);
            for (IrDeclaration declaration3 : ((IrClass)element2).getDeclarations()) {
                this.collect(declaration3);
            }
        } else if (irElement instanceof IrDeclarationContainer) {
            for (IrDeclaration declaration4 : ((IrDeclarationContainer)element2).getDeclarations()) {
                this.collect(declaration4);
            }
        } else if (irElement instanceof IrEnumEntry) {
            this.recordActualCallable((IrDeclarationWithName)element2, AdditionalIrUtilsKt.getCallableId((IrEnumEntry)element2));
        } else if (irElement instanceof IrProperty) {
            if (((IrProperty)element2).isExpect()) {
                return;
            }
            this.recordActualCallable((IrDeclarationWithName)element2, AdditionalIrUtilsKt.getCallableId((IrProperty)element2));
        } else if (irElement instanceof IrFunction) {
            if (((IrFunction)element2).isExpect()) {
                return;
            }
            this.recordActualCallable((IrDeclarationWithName)element2, AdditionalIrUtilsKt.getCallableId((IrFunction)element2));
        }
    }

    private final void recordMappingsForNestedClassesActualizedViaTypealias(ClassId typealiasClassId, IrClassSymbol actualClassSymbol) {
        IrClassSymbol irClassSymbol = this.expectTopLevelClasses.get(typealiasClassId);
        if (irClassSymbol == null) {
            return;
        }
        IrClassSymbol expectClassSymbol = irClassSymbol;
        ActualDeclarationsCollector.recordMappingsForNestedClassesActualizedViaTypealias$recordRecursively(this, (IrClass)expectClassSymbol.getOwner(), (IrClass)actualClassSymbol.getOwner());
    }

    private final void recordActualCallable(IrDeclarationWithName callableDeclaration, CallableId callableId) {
        if (callableId.getClassId() == null) {
            List list;
            Map<CallableId, List<IrSymbol>> $this$getOrPut$iv = this.actualTopLevels;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(callableId);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(callableId, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            list.add((IrSymbol)callableDeclaration.getSymbol());
            this.actualSymbolsToFile.put(callableDeclaration.getSymbol(), this.currentFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void recordMappingsForNestedClassesActualizedViaTypealias$recordRecursively(ActualDeclarationsCollector this$0, IrClass expectClass, IrClass actualClass) {
        void $this$associateByTo$iv$iv;
        Sequence<IrClass> $this$associateBy$iv = IrUtilsKt.getNestedClasses(actualClass);
        boolean $i$f$associateBy = false;
        Sequence<IrClass> sequence2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IrClass irClass = (IrClass)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map actualNestedClassesByName = destination$iv$iv;
        for (IrClass expectNestedClass : IrUtilsKt.getNestedClasses(expectClass)) {
            IrClass actualNestedClass;
            if ((IrClass)actualNestedClassesByName.get(expectNestedClass.getName()) == null) continue;
            this$0.actualClasses.put(AdditionalIrUtilsKt.getClassIdOrFail(expectNestedClass), actualNestedClass.getSymbol());
            ActualDeclarationsCollector.recordMappingsForNestedClassesActualizedViaTypealias$recordRecursively(this$0, expectNestedClass, actualNestedClass);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector$Companion;", "", "<init>", "()V", "collectActualsFromFragments", "Lksp/org/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "fragments", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "expectTopLevelClasses", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "ir.actualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassActualizationInfo collectActualsFromFragments(@NotNull List<? extends IrModuleFragment> fragments, @NotNull Map<ClassId, ? extends IrClassSymbol> expectTopLevelClasses) {
            Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
            Intrinsics.checkNotNullParameter(expectTopLevelClasses, (String)"expectTopLevelClasses");
            ActualDeclarationsCollector collector2 = new ActualDeclarationsCollector(expectTopLevelClasses);
            for (IrModuleFragment irModuleFragment : fragments) {
                collector2.collect(irModuleFragment);
            }
            return new ClassActualizationInfo(collector2.actualClasses, collector2.actualTypeAliasesWithoutExpansion, collector2.actualTopLevels, collector2.actualSymbolsToFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

