/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.model;

import java.util.function.Consumer;
import ksp.com.intellij.injected.editor.VirtualFileWindow;
import ksp.com.intellij.model.BranchService;
import ksp.com.intellij.model.BranchableSyntheticPsiElement;
import ksp.com.intellij.model.BranchedVirtualFile;
import ksp.com.intellij.model.ModelPatch;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.UserDataHolder;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiReference;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ModelBranch
extends UserDataHolder {
    @NotNull
    public Project getProject();

    @NotNull
    public static ModelPatch performInBranch(@NotNull Project project, @NotNull Consumer<? super ModelBranch> action) {
        if (project == null) {
            ModelBranch.$$$reportNull$$$0(0);
        }
        if (action == null) {
            ModelBranch.$$$reportNull$$$0(1);
        }
        ModelPatch modelPatch = BranchService.getInstance().performInBranch(project, action);
        if (modelPatch == null) {
            ModelBranch.$$$reportNull$$$0(2);
        }
        return modelPatch;
    }

    @NotNull
    public VirtualFile findFileCopy(@NotNull VirtualFile var1);

    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T var1);

    @NotNull
    public <T extends PsiReference> T obtainReferenceCopy(@NotNull T var1);

    @Nullable
    public VirtualFile findFileByUrl(@NotNull String var1);

    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T var1);

    @Nullable
    public VirtualFile findOriginalFile(@NotNull VirtualFile var1);

    @Nullable
    public static ModelBranch getPsiBranch(@NotNull PsiElement element2) {
        if (element2 == null) {
            ModelBranch.$$$reportNull$$$0(3);
        }
        if (element2 instanceof PsiDirectory) {
            return ModelBranch.getFileBranch(((PsiDirectory)element2).getVirtualFile());
        }
        if (element2 instanceof BranchableSyntheticPsiElement) {
            return ((BranchableSyntheticPsiElement)element2).getModelBranch();
        }
        PsiFile psiFile = element2 instanceof PsiFile ? (PsiFile)element2 : element2.getContainingFile();
        return psiFile == null ? null : ModelBranch.getFileBranch(psiFile.getViewProvider().getVirtualFile());
    }

    @Nullable
    public static ModelBranch getFileBranch(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModelBranch.$$$reportNull$$$0(4);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        return file2 instanceof BranchedVirtualFile ? ((BranchedVirtualFile)file2).getBranch() : null;
    }

    public long getBranchedPsiModificationCount();

    public long getBranchedVfsStructureModificationCount();

    public void runAfterMerge(@NotNull Runnable var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/model/ModelBranch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/model/ModelBranch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "performInBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performInBranch";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiBranch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileBranch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

