/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import dagger.hilt.processor.internal.BadInputException;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import java.util.Collection;
import javax.annotation.Nullable;

public final class ProcessorErrors {
    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new BadInputException(String.valueOf(errorMessage));
        }
    }

    @FormatMethod
    public static void checkState(boolean expression, @Nullable @FormatString String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new BadInputException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression, XElement badElement, @Nullable Object errorMessage) {
        Preconditions.checkNotNull((Object)badElement);
        if (!expression) {
            throw new BadInputException(String.valueOf(errorMessage), badElement);
        }
    }

    @FormatMethod
    public static void checkState(boolean expression, XElement badElement, @Nullable @FormatString String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkNotNull((Object)badElement);
        if (!expression) {
            throw new BadInputException(String.format(errorMessageTemplate, errorMessageArgs), badElement);
        }
    }

    @FormatMethod
    public static void checkStateX(boolean expression, Collection<? extends XElement> badElements, @Nullable @FormatString String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkNotNull(badElements);
        if (!expression) {
            Preconditions.checkState((!badElements.isEmpty() ? 1 : 0) != 0);
            throw new BadInputException(String.format(errorMessageTemplate, errorMessageArgs), badElements);
        }
    }

    private ProcessorErrors() {
    }
}

