/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

enum RootType {
    ROOT(ClassNames.HILT_ANDROID_APP),
    HILT_ANDROID_TEST_ROOT(ClassNames.HILT_ANDROID_TEST),
    TEST_ROOT(ClassNames.INTERNAL_TEST_ROOT);

    private final ClassName annotation;

    private RootType(ClassName annotation) {
        this.annotation = annotation;
    }

    public boolean isTestRoot() {
        return this == TEST_ROOT;
    }

    public ClassName className() {
        return this.annotation;
    }

    public static RootType of(XTypeElement element) {
        if (element.hasAnnotation(ClassNames.HILT_ANDROID_APP)) {
            return ROOT;
        }
        if (element.hasAnnotation(ClassNames.HILT_ANDROID_TEST)) {
            return TEST_ROOT;
        }
        if (element.hasAnnotation(ClassNames.INTERNAL_TEST_ROOT)) {
            return TEST_ROOT;
        }
        throw new IllegalStateException("Unknown root type: " + element);
    }
}

