/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.AutoValue_TestRootMetadata;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;

@AutoValue
abstract class TestRootMetadata {
    TestRootMetadata() {
    }

    abstract XTypeElement testElement();

    abstract XTypeElement baseElement();

    ClassName testName() {
        return this.testElement().getClassName();
    }

    ClassName baseAppName() {
        return this.baseElement().getClassName();
    }

    ClassName appName() {
        return Processors.append(Processors.getEnclosedClassName(this.testName()), "_Application");
    }

    ClassName testInjectorName() {
        return Processors.append(Processors.getEnclosedClassName(this.testName()), "_GeneratedInjector");
    }

    static TestRootMetadata of(XProcessingEnv env, XElement element) {
        XTypeElement testElement = XElements.asTypeElement((XElement)element);
        XTypeElement baseElement = env.requireTypeElement((TypeName)ClassNames.MULTI_DEX_APPLICATION);
        ProcessorErrors.checkState(!element.hasAnnotation(ClassNames.ANDROID_ENTRY_POINT), element, (Object)"Tests cannot be annotated with @AndroidEntryPoint. Please use @HiltAndroidTest");
        ProcessorErrors.checkState(element.hasAnnotation(ClassNames.HILT_ANDROID_TEST), element, (Object)"Tests must be annotated with @HiltAndroidTest");
        return new AutoValue_TestRootMetadata(testElement, baseElement);
    }
}

