/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

public final class AggregatedElements {
    public static Optional<ClassName> aggregatedElementProxyName(XTypeElement aggregatedElement) {
        if (aggregatedElement.isPublic() && !aggregatedElement.isInternal()) {
            return Optional.empty();
        }
        ClassName name = aggregatedElement.getClassName();
        return Optional.of(name.peerClass("_" + name.simpleName()));
    }

    public static ImmutableSet<XTypeElement> unwrapProxies(ImmutableCollection<XTypeElement> aggregatedElements) {
        return (ImmutableSet)aggregatedElements.stream().map(AggregatedElements::unwrapProxy).collect(DaggerStreams.toImmutableSet());
    }

    private static XTypeElement unwrapProxy(XTypeElement element) {
        return element.hasAnnotation(ClassNames.AGGREGATED_ELEMENT_PROXY) ? XAnnotations.getAsTypeElement((XAnnotation)element.getAnnotation(ClassNames.AGGREGATED_ELEMENT_PROXY), (String)"value") : element;
    }

    public static ImmutableSet<XTypeElement> from(String aggregatingPackage, ClassName aggregatingAnnotation, XProcessingEnv env) {
        ImmutableSet aggregatedElements = (ImmutableSet)env.getTypeElementsFromPackage(aggregatingPackage).stream().filter(element -> !element.hasAnnotation(ClassNames.AGGREGATED_ELEMENT_PROXY)).collect(DaggerStreams.toImmutableSet());
        for (XTypeElement aggregatedElement : aggregatedElements) {
            ProcessorErrors.checkState(aggregatedElement.hasAnnotation(aggregatingAnnotation), (XElement)aggregatedElement, "Expected element, %s, to be annotated with @%s, but only found: %s.", aggregatedElement.getName(), aggregatingAnnotation, aggregatedElement.getAllAnnotations().stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableList()));
        }
        return aggregatedElements;
    }

    private AggregatedElements() {
    }
}

