/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;

final class AggregatedRootGenerator {
    private final TypeElement rootElement;
    private final TypeElement originatingRootElement;
    private final TypeElement rootAnnotation;
    private final ProcessingEnvironment processingEnv;

    AggregatedRootGenerator(TypeElement rootElement, TypeElement originatingRootElement, TypeElement rootAnnotation, ProcessingEnvironment processingEnv) {
        this.rootElement = rootElement;
        this.originatingRootElement = originatingRootElement;
        this.rootAnnotation = rootAnnotation;
        this.processingEnv = processingEnv;
    }

    void generate() throws IOException {
        AnnotationSpec.Builder aggregatedRootAnnotation = AnnotationSpec.builder((ClassName)ClassNames.AGGREGATED_ROOT).addMember("root", "$S", new Object[]{this.rootElement.getQualifiedName()}).addMember("rootPackage", "$S", new Object[]{ClassName.get((TypeElement)this.rootElement).packageName()}).addMember("originatingRoot", "$S", new Object[]{this.originatingRootElement.getQualifiedName()}).addMember("originatingRootPackage", "$S", new Object[]{ClassName.get((TypeElement)this.originatingRootElement).packageName()}).addMember("rootAnnotation", "$T.class", new Object[]{this.rootAnnotation});
        ClassName.get((TypeElement)this.rootElement).simpleNames().forEach(name -> aggregatedRootAnnotation.addMember("rootSimpleNames", "$S", new Object[]{name}));
        ClassName.get((TypeElement)this.originatingRootElement).simpleNames().forEach(name -> aggregatedRootAnnotation.addMember("originatingRootSimpleNames", "$S", new Object[]{name}));
        Processors.generateAggregatingClass("dagger.hilt.internal.aggregatedroot.codegen", aggregatedRootAnnotation.build(), this.rootElement, this.getClass(), this.processingEnv);
    }
}

