/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aliasof;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataGenerator;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoService(value={Processor.class})
public final class AliasOfProcessor
extends BaseProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.ALIAS_OF.toString());
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        ProcessorErrors.checkState(Processors.hasAnnotation(element, ClassNames.SCOPE), element, "%s should only be used on scopes. However, it was found annotating %s", annotation, element);
        AnnotationMirror annotationMirror = Processors.getAnnotationMirror(element, ClassNames.ALIAS_OF);
        TypeElement defineComponentScope = Processors.getAnnotationClassValue(this.getElementUtils(), annotationMirror, "value");
        new AliasOfPropagatedDataGenerator(this.getProcessingEnv(), MoreElements.asType(element), defineComponentScope).generate();
    }
}

