/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.content.Context;
import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.lifecycle.viewmodel.CreationExtras;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.ActivityRetainedLifecycle;
import dagger.hilt.android.EntryPointAccessors;
import dagger.hilt.android.components.ActivityRetainedComponent;
import dagger.hilt.android.internal.builders.ActivityRetainedComponentBuilder;
import dagger.hilt.android.internal.lifecycle.RetainedLifecycleImpl;
import dagger.hilt.android.internal.managers.SavedStateHandleHolder;
import dagger.hilt.android.scopes.ActivityRetainedScoped;
import dagger.hilt.components.SingletonComponent;
import dagger.hilt.internal.GeneratedComponentManager;

final class ActivityRetainedComponentManager
implements GeneratedComponentManager<ActivityRetainedComponent> {
    private final ViewModelStoreOwner viewModelStoreOwner;
    private final Context context;
    @Nullable
    private volatile ActivityRetainedComponent component;
    private final Object componentLock = new Object();

    ActivityRetainedComponentManager(ComponentActivity activity) {
        this.viewModelStoreOwner = activity;
        this.context = activity;
    }

    private ViewModelProvider getViewModelProvider(ViewModelStoreOwner owner, final Context context) {
        return new ViewModelProvider(owner, new ViewModelProvider.Factory(){

            @NonNull
            public <T extends ViewModel> T create(@NonNull Class<T> aClass, CreationExtras creationExtras) {
                SavedStateHandleHolder savedStateHandleHolder = new SavedStateHandleHolder(creationExtras);
                ActivityRetainedComponent component = EntryPointAccessors.fromApplication(context, ActivityRetainedComponentBuilderEntryPoint.class).retainedComponentBuilder().savedStateHandleHolder(savedStateHandleHolder).build();
                return (T)((Object)new ActivityRetainedComponentViewModel(component, savedStateHandleHolder));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityRetainedComponent generatedComponent() {
        if (this.component == null) {
            Object object = this.componentLock;
            synchronized (object) {
                if (this.component == null) {
                    this.component = this.createComponent();
                }
            }
        }
        return this.component;
    }

    public SavedStateHandleHolder getSavedStateHandleHolder() {
        return ((ActivityRetainedComponentViewModel)this.getViewModelProvider(this.viewModelStoreOwner, this.context).get(ActivityRetainedComponentViewModel.class)).getSavedStateHandleHolder();
    }

    private ActivityRetainedComponent createComponent() {
        return ((ActivityRetainedComponentViewModel)this.getViewModelProvider(this.viewModelStoreOwner, this.context).get(ActivityRetainedComponentViewModel.class)).getComponent();
    }

    static final class ActivityRetainedComponentViewModel
    extends ViewModel {
        private final ActivityRetainedComponent component;
        private final SavedStateHandleHolder savedStateHandleHolder;

        ActivityRetainedComponentViewModel(ActivityRetainedComponent component, SavedStateHandleHolder savedStateHandleHolder) {
            this.component = component;
            this.savedStateHandleHolder = savedStateHandleHolder;
        }

        ActivityRetainedComponent getComponent() {
            return this.component;
        }

        SavedStateHandleHolder getSavedStateHandleHolder() {
            return this.savedStateHandleHolder;
        }

        protected void onCleared() {
            super.onCleared();
            ActivityRetainedLifecycle lifecycle = ((ActivityRetainedLifecycleEntryPoint)EntryPoints.get((Object)this.component, ActivityRetainedLifecycleEntryPoint.class)).getActivityRetainedLifecycle();
            ((RetainedLifecycleImpl)lifecycle).dispatchOnCleared();
        }
    }

    @Module
    @InstallIn(value={ActivityRetainedComponent.class})
    static abstract class LifecycleModule {
        LifecycleModule() {
        }

        @Provides
        @ActivityRetainedScoped
        static ActivityRetainedLifecycle provideActivityRetainedLifecycle() {
            return new RetainedLifecycleImpl();
        }
    }

    @EntryPoint
    @InstallIn(value={ActivityRetainedComponent.class})
    public static interface ActivityRetainedLifecycleEntryPoint {
        public ActivityRetainedLifecycle getActivityRetainedLifecycle();
    }

    @EntryPoint
    @InstallIn(value={SingletonComponent.class})
    public static interface ActivityRetainedComponentBuilderEntryPoint {
        public ActivityRetainedComponentBuilder retainedComponentBuilder();
    }
}

