/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import android.app.Application;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.FragmentComponent;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.hilt.android.internal.lifecycle.DefaultActivityViewModelFactory;
import dagger.hilt.android.internal.lifecycle.DefaultFragmentViewModelFactory;
import dagger.hilt.android.internal.lifecycle.HiltViewModelFactory;
import dagger.hilt.android.internal.lifecycle.HiltViewModelMap;
import dagger.multibindings.Multibinds;
import java.util.Set;
import javax.inject.Inject;

public final class DefaultViewModelFactories {
    public static ViewModelProvider.Factory getActivityFactory(ComponentActivity activity) {
        return ((ActivityEntryPoint)EntryPoints.get((Object)activity, ActivityEntryPoint.class)).getHiltInternalFactoryFactory().fromActivity(activity);
    }

    public static ViewModelProvider.Factory getFragmentFactory(Fragment fragment) {
        return ((FragmentEntryPoint)EntryPoints.get((Object)fragment, FragmentEntryPoint.class)).getHiltInternalFactoryFactory().fromFragment(fragment);
    }

    private DefaultViewModelFactories() {
    }

    @EntryPoint
    @InstallIn(value={FragmentComponent.class})
    static interface FragmentEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    static interface ActivityEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    @Module
    @InstallIn(value={ActivityComponent.class})
    static interface ActivityModule {
        @Multibinds
        @HiltViewModelMap.KeySet
        public Set<String> viewModelKeys();

        @Multibinds
        @DefaultActivityViewModelFactory
        public Set<ViewModelProvider.Factory> defaultActivityViewModelFactory();

        @Multibinds
        @DefaultFragmentViewModelFactory
        public Set<ViewModelProvider.Factory> defaultFragmentViewModelFactory();
    }

    public static final class InternalFactoryFactory {
        private final Application application;
        private final Set<String> keySet;
        private final ViewModelComponentBuilder viewModelComponentBuilder;
        @Nullable
        private final ViewModelProvider.Factory defaultActivityFactory;
        @Nullable
        private final ViewModelProvider.Factory defaultFragmentFactory;

        @Inject
        InternalFactoryFactory(Application application, @HiltViewModelMap.KeySet Set<String> keySet, ViewModelComponentBuilder viewModelComponentBuilder, @DefaultActivityViewModelFactory Set<ViewModelProvider.Factory> defaultActivityFactorySet, @DefaultFragmentViewModelFactory Set<ViewModelProvider.Factory> defaultFragmentFactorySet) {
            this.application = application;
            this.keySet = keySet;
            this.viewModelComponentBuilder = viewModelComponentBuilder;
            this.defaultActivityFactory = InternalFactoryFactory.getFactoryFromSet(defaultActivityFactorySet);
            this.defaultFragmentFactory = InternalFactoryFactory.getFactoryFromSet(defaultFragmentFactorySet);
        }

        ViewModelProvider.Factory fromActivity(ComponentActivity activity) {
            return this.getHiltViewModelFactory((SavedStateRegistryOwner)activity, activity.getIntent() != null ? activity.getIntent().getExtras() : null, this.defaultActivityFactory);
        }

        ViewModelProvider.Factory fromFragment(Fragment fragment) {
            return this.getHiltViewModelFactory((SavedStateRegistryOwner)fragment, fragment.getArguments(), this.defaultFragmentFactory);
        }

        private ViewModelProvider.Factory getHiltViewModelFactory(SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs, @Nullable ViewModelProvider.Factory extensionDelegate) {
            ViewModelProvider.Factory delegate = extensionDelegate == null ? new SavedStateViewModelFactory(this.application, owner, defaultArgs) : extensionDelegate;
            return new HiltViewModelFactory(owner, defaultArgs, this.keySet, delegate, this.viewModelComponentBuilder);
        }

        @Nullable
        private static ViewModelProvider.Factory getFactoryFromSet(Set<ViewModelProvider.Factory> set) {
            if (set.isEmpty()) {
                return null;
            }
            if (set.size() > 1) {
                throw new IllegalStateException("At most one default view model factory is expected. Found " + set);
            }
            ViewModelProvider.Factory factory = set.iterator().next();
            if (factory == null) {
                throw new IllegalStateException("Default view model factory must not be null.");
            }
            return factory;
        }
    }
}

