/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.android.build.api.instrumentation.InstrumentationParameters;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 #2\u00020\u0001:\u0004#$%&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002JK\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0010\u0010\u001a\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJA\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0010\u0010 \u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010!J\f\u0010\"\u001a\u00020\t*\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "apiVersion", "", "nextClassVisitor", "classContext", "Lcom/android/build/api/instrumentation/ClassContext;", "(ILorg/objectweb/asm/ClassVisitor;Lcom/android/build/api/instrumentation/ClassContext;)V", "newSuperclassName", "", "getNewSuperclassName", "()Ljava/lang/String;", "setNewSuperclassName", "(Ljava/lang/String;)V", "oldSuperclassName", "getOldSuperclassName", "setOldSuperclassName", "hasOnReceiveBytecodeInjectionMarker", "", "visit", "", "version", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "descriptor", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "toFQName", "Companion", "Factory", "InvokeSpecialAdapter", "OnReceiveAdapter"})
public final class AndroidEntryPointClassVisitor
extends ClassVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int apiVersion;
    @NotNull
    private final ClassContext classContext;
    public String newSuperclassName;
    public String oldSuperclassName;
    @NotNull
    private static final Set<String> ANDROID_ENTRY_POINT_ANNOTATIONS;
    @NotNull
    public static final String ON_RECEIVE_METHOD_NAME = "onReceive";
    @NotNull
    public static final String ON_RECEIVE_METHOD_DESCRIPTOR = "(Landroid/content/Context;Landroid/content/Intent;)V";
    @NotNull
    public static final String ON_RECEIVE_MARKER_ANNOTATION = "dagger.hilt.android.internal.OnReceiveBytecodeInjectionMarker";

    public AndroidEntryPointClassVisitor(int apiVersion, @NotNull ClassVisitor nextClassVisitor, @NotNull ClassContext classContext) {
        Intrinsics.checkNotNullParameter((Object)nextClassVisitor, (String)"nextClassVisitor");
        Intrinsics.checkNotNullParameter((Object)classContext, (String)"classContext");
        super(apiVersion, nextClassVisitor);
        this.apiVersion = apiVersion;
        this.classContext = classContext;
    }

    @NotNull
    public final String getNewSuperclassName() {
        String string = this.newSuperclassName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"newSuperclassName");
        return null;
    }

    public final void setNewSuperclassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.newSuperclassName = string;
    }

    @NotNull
    public final String getOldSuperclassName() {
        String string = this.oldSuperclassName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"oldSuperclassName");
        return null;
    }

    public final void setOldSuperclassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.oldSuperclassName = string;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String packageName = StringsKt.substringBeforeLast$default((String)name, (char)'/', null, (int)2, null);
        String className = StringsKt.substringAfterLast$default((String)name, (char)'/', null, (int)2, null);
        this.setNewSuperclassName(packageName + "/Hilt_" + StringsKt.replace$default((String)className, (String)"$", (String)"_", (boolean)false, (int)4, null));
        String string = superName;
        if (string == null) {
            throw (Throwable)new IllegalStateException(new Function0<String>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Superclass of " + this.$name + " is null!";
                }
            }.toString());
        }
        this.setOldSuperclassName(string);
        String string2 = signature;
        String newSignature = string2 != null ? StringsKt.replaceFirst$default((String)string2, (String)this.getOldSuperclassName(), (String)this.getNewSuperclassName(), (boolean)false, (int)4, null) : null;
        super.visit(version, access, name, newSignature, this.getNewSuperclassName(), interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MethodVisitor nextMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        Intrinsics.checkNotNull((Object)nextMethodVisitor);
        InvokeSpecialAdapter invokeSpecialVisitor = new InvokeSpecialAdapter(this.apiVersion, nextMethodVisitor, Intrinsics.areEqual((Object)name, (Object)"<init>"));
        if (Intrinsics.areEqual((Object)name, (Object)ON_RECEIVE_METHOD_NAME) && Intrinsics.areEqual((Object)descriptor, (Object)ON_RECEIVE_METHOD_DESCRIPTOR) && this.hasOnReceiveBytecodeInjectionMarker()) {
            return new OnReceiveAdapter(this.apiVersion, invokeSpecialVisitor);
        }
        return invokeSpecialVisitor;
    }

    private final boolean hasOnReceiveBytecodeInjectionMarker() {
        List list;
        String newSuperclassFQName = this.toFQName(this.getNewSuperclassName());
        ClassData classData = this.classContext.loadClassData(newSuperclassFQName);
        if (classData == null || (list = classData.getClassAnnotations()) == null) {
            throw (Throwable)new IllegalStateException(("Cannot load class " + newSuperclassFQName + "!").toString());
        }
        return list.contains(ON_RECEIVE_MARKER_ANNOTATION);
    }

    private final String toFQName(String $this$toFQName) {
        return StringsKt.replace$default((String)$this$toFQName, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    static {
        Object[] objectArray = new String[]{"dagger.hilt.android.AndroidEntryPoint", "dagger.hilt.android.HiltAndroidApp"};
        ANDROID_ENTRY_POINT_ANNOTATIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassVisitor$Companion;", "", "()V", "ANDROID_ENTRY_POINT_ANNOTATIONS", "", "", "getANDROID_ENTRY_POINT_ANNOTATIONS", "()Ljava/util/Set;", "ON_RECEIVE_MARKER_ANNOTATION", "ON_RECEIVE_METHOD_DESCRIPTOR", "ON_RECEIVE_METHOD_NAME"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getANDROID_ENTRY_POINT_ANNOTATIONS() {
            return ANDROID_ENTRY_POINT_ANNOTATIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassVisitor$Factory;", "Lcom/android/build/api/instrumentation/AsmClassVisitorFactory;", "Lcom/android/build/api/instrumentation/InstrumentationParameters$None;", "()V", "createClassVisitor", "Lorg/objectweb/asm/ClassVisitor;", "classContext", "Lcom/android/build/api/instrumentation/ClassContext;", "nextClassVisitor", "isInstrumentable", "", "classData", "Lcom/android/build/api/instrumentation/ClassData;"})
    @SourceDebugExtension(value={"SMAP\nAndroidEntryPointClassVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidEntryPointClassVisitor.kt\ndagger/hilt/android/plugin/AndroidEntryPointClassVisitor$Factory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1741#2,3:224\n*S KotlinDebug\n*F\n+ 1 AndroidEntryPointClassVisitor.kt\ndagger/hilt/android/plugin/AndroidEntryPointClassVisitor$Factory\n*L\n60#1:224,3\n*E\n"})
    public static abstract class Factory
    implements AsmClassVisitorFactory<InstrumentationParameters.None> {
        @NotNull
        public ClassVisitor createClassVisitor(@NotNull ClassContext classContext, @NotNull ClassVisitor nextClassVisitor) {
            Intrinsics.checkNotNullParameter((Object)classContext, (String)"classContext");
            Intrinsics.checkNotNullParameter((Object)nextClassVisitor, (String)"nextClassVisitor");
            Object object = this.getInstrumentationContext().getApiVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return new AndroidEntryPointClassVisitor(((Number)object).intValue(), nextClassVisitor, classContext);
        }

        public boolean isInstrumentable(@NotNull ClassData classData) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)classData, (String)"classData");
                Iterable $this$any$iv = classData.getClassAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Companion.getANDROID_ENTRY_POINT_ANNOTATIONS().contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassVisitor$InvokeSpecialAdapter;", "Lorg/objectweb/asm/MethodVisitor;", "apiVersion", "", "nextClassVisitor", "isConstructor", "", "(Ldagger/hilt/android/plugin/AndroidEntryPointClassVisitor;ILorg/objectweb/asm/MethodVisitor;Z)V", "visitedSuperConstructorInvokeSpecial", "getAdaptedOwner", "", "methodRefName", "visitMethodInsn", "", "opcode", "owner", "name", "descriptor", "isInterface"})
    public final class InvokeSpecialAdapter
    extends MethodVisitor {
        private final boolean isConstructor;
        private boolean visitedSuperConstructorInvokeSpecial;

        public InvokeSpecialAdapter(@NotNull int apiVersion, MethodVisitor nextClassVisitor, boolean isConstructor) {
            Intrinsics.checkNotNullParameter((Object)nextClassVisitor, (String)"nextClassVisitor");
            super(apiVersion, nextClassVisitor);
            this.isConstructor = isConstructor;
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (opcode == 183 && Intrinsics.areEqual((Object)owner, (Object)AndroidEntryPointClassVisitor.this.getOldSuperclassName())) {
                String string = this.getAdaptedOwner(name);
                if (string == null) {
                    string = owner;
                }
                super.visitMethodInsn(opcode, string, name, descriptor, isInterface);
            } else {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        }

        private final String getAdaptedOwner(String methodRefName) {
            if (Intrinsics.areEqual((Object)methodRefName, (Object)"<init>") && this.isConstructor && !this.visitedSuperConstructorInvokeSpecial) {
                this.visitedSuperConstructorInvokeSpecial = true;
                return AndroidEntryPointClassVisitor.this.getNewSuperclassName();
            }
            if (!Intrinsics.areEqual((Object)methodRefName, (Object)"<init>")) {
                return AndroidEntryPointClassVisitor.this.getNewSuperclassName();
            }
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassVisitor$OnReceiveAdapter;", "Lorg/objectweb/asm/MethodVisitor;", "apiVersion", "", "nextClassVisitor", "(Ldagger/hilt/android/plugin/AndroidEntryPointClassVisitor;ILorg/objectweb/asm/MethodVisitor;)V", "visitCode", ""})
    public final class OnReceiveAdapter
    extends MethodVisitor {
        public OnReceiveAdapter(@NotNull int apiVersion, MethodVisitor nextClassVisitor) {
            Intrinsics.checkNotNullParameter((Object)nextClassVisitor, (String)"nextClassVisitor");
            super(apiVersion, nextClassVisitor);
        }

        public void visitCode() {
            super.visitCode();
            super.visitIntInsn(25, 0);
            super.visitIntInsn(25, 1);
            super.visitIntInsn(25, 2);
            super.visitMethodInsn(183, AndroidEntryPointClassVisitor.this.getNewSuperclassName(), AndroidEntryPointClassVisitor.ON_RECEIVE_METHOD_NAME, AndroidEntryPointClassVisitor.ON_RECEIVE_METHOD_DESCRIPTOR, false);
        }
    }
}

