/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.bindvalue;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.bindvalue.AutoValue_BindValueMetadata;
import dagger.hilt.android.processor.internal.bindvalue.AutoValue_BindValueMetadata_BindValueElement;
import dagger.hilt.android.processor.internal.bindvalue.BindValueProcessor;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtil;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtils;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@AutoValue
abstract class BindValueMetadata {
    static final ImmutableSet<ClassName> BIND_VALUE_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_VALUE);
    static final ImmutableSet<ClassName> BIND_VALUE_INTO_SET_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_VALUE_INTO_SET);
    static final ImmutableSet<ClassName> BIND_ELEMENTS_INTO_SET_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_ELEMENTS_INTO_SET);
    static final ImmutableSet<ClassName> BIND_VALUE_INTO_MAP_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_VALUE_INTO_MAP);

    BindValueMetadata() {
    }

    abstract TypeElement testElement();

    abstract ImmutableSet<BindValueElement> bindValueElements();

    static BindValueMetadata create(TypeElement testElement, Collection<Element> bindValueElements) {
        ImmutableSet.Builder elements = ImmutableSet.builder();
        for (Element element : bindValueElements) {
            elements.add((Object)BindValueElement.create(element));
        }
        return new AutoValue_BindValueMetadata(testElement, (ImmutableSet<BindValueElement>)elements.build());
    }

    @AutoValue
    static abstract class BindValueElement {
        BindValueElement() {
        }

        abstract VariableElement variableElement();

        abstract ClassName annotationName();

        abstract Optional<AnnotationMirror> qualifier();

        abstract Optional<AnnotationMirror> mapKey();

        abstract Optional<ExecutableElement> getterElement();

        static BindValueElement create(Element element) {
            Optional<AnnotationMirror> optionalMapKeys;
            Optional<ExecutableElement> propertyGetter;
            ImmutableList<ClassName> bindValues = BindValueProcessor.getBindValueAnnotations(element);
            ProcessorErrors.checkState(bindValues.size() == 1, element, "Fields can be annotated with only one of @BindValue, @BindValueIntoMap, @BindElementsIntoSet, @BindValueIntoSet. Found: %s", bindValues.stream().map(m -> "@" + m.simpleName()).collect(DaggerStreams.toImmutableList()));
            ClassName annotationClassName = (ClassName)bindValues.get(0);
            ProcessorErrors.checkState(element.getKind() == ElementKind.FIELD, element, "@%s can only be used with fields. Found: %s", annotationClassName.simpleName(), element);
            KotlinMetadataUtil metadataUtil = KotlinMetadataUtils.getMetadataUtil();
            Optional<ExecutableElement> optional = propertyGetter = metadataUtil.hasMetadata(element) ? metadataUtil.getPropertyGetter(MoreElements.asVariable(element)) : Optional.empty();
            if (propertyGetter.isPresent()) {
                ProcessorErrors.checkState(!((ExecutableElement)propertyGetter.get()).getModifiers().contains((Object)Modifier.PRIVATE), element, "@%s field getter cannot be private. Found: %s", annotationClassName.simpleName(), element);
            } else {
                ProcessorErrors.checkState(!element.getModifiers().contains((Object)Modifier.PRIVATE), element, "@%s fields cannot be private. Found: %s", annotationClassName.simpleName(), element);
            }
            ProcessorErrors.checkState(!Processors.hasAnnotation(element, ClassNames.INJECT), element, "@%s fields cannot be used with @Inject annotation. Found %s", annotationClassName.simpleName(), element);
            ImmutableList<AnnotationMirror> qualifiers = Processors.getQualifierAnnotations(element);
            ProcessorErrors.checkState(qualifiers.size() <= 1, element, "@%s fields cannot have more than one qualifier. Found %s", annotationClassName.simpleName(), qualifiers);
            ImmutableList<AnnotationMirror> mapKeys = Processors.getMapKeyAnnotations(element);
            if (BIND_VALUE_INTO_MAP_ANNOTATIONS.contains((Object)annotationClassName)) {
                ProcessorErrors.checkState(mapKeys.size() == 1, element, "@BindValueIntoMap fields must have exactly one @MapKey. Found %s", mapKeys);
                optionalMapKeys = Optional.of((AnnotationMirror)mapKeys.get(0));
            } else {
                ProcessorErrors.checkState(mapKeys.isEmpty(), element, "@MapKey can only be used on @BindValueIntoMap fields, not @%s fields", annotationClassName.simpleName());
                optionalMapKeys = Optional.empty();
            }
            ImmutableList<AnnotationMirror> scopes = Processors.getScopeAnnotations(element);
            ProcessorErrors.checkState(scopes.isEmpty(), element, "@%s fields cannot be scoped. Found %s", annotationClassName.simpleName(), scopes);
            return new AutoValue_BindValueMetadata_BindValueElement((VariableElement)element, annotationClassName, qualifiers.isEmpty() ? Optional.empty() : Optional.of((AnnotationMirror)qualifiers.get(0)), optionalMapKeys, propertyGetter);
        }
    }
}

