/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.MoreTypes;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.ElementDescriptors;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public final class BroadcastReceiverGenerator {
    private static final String ON_RECEIVE_DESCRIPTOR = "onReceive(Landroid/content/Context;Landroid/content/Intent;)V";
    private final ProcessingEnvironment env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public BroadcastReceiverGenerator(ProcessingEnvironment env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).addOriginatingElement((Element)this.metadata.element()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers()).addMethod(this.onReceiveMethod());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyConstructors(this.metadata.baseElement(), builder);
        this.metadata.baseElement().getTypeParameters().stream().map(TypeVariableName::get).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addInjectionMethods(this.metadata, builder);
        Generators.copyLintAnnotations(this.metadata.element(), builder);
        Generators.copySuppressAnnotations(this.metadata.element(), builder);
        if (this.metadata.requiresBytecodeInjection() && !BroadcastReceiverGenerator.isOnReceiveImplemented(this.metadata.baseElement())) {
            builder.addField(FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)"onReceiveBytecodeInjectionMarker", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("false", new Object[0]).build());
        }
        JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build().writeTo(this.env.getFiler());
    }

    private static boolean isOnReceiveImplemented(TypeElement typeElement) {
        boolean isImplemented = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().anyMatch(methodElement -> ElementDescriptors.getMethodDescriptor(methodElement).equals(ON_RECEIVE_DESCRIPTOR) && !methodElement.getModifiers().contains((Object)Modifier.ABSTRACT));
        if (isImplemented) {
            return true;
        }
        if (typeElement.getSuperclass().getKind() != TypeKind.NONE) {
            return BroadcastReceiverGenerator.isOnReceiveImplemented(MoreTypes.asTypeElement(typeElement.getSuperclass()));
        }
        return false;
    }

    private MethodSpec onReceiveMethod() throws IOException {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"onReceive").addAnnotation(Override.class).addAnnotation(AndroidClassNames.CALL_SUPER).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)AndroidClassNames.CONTEXT, (String)"context", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)AndroidClassNames.INTENT, (String)"intent", (Modifier[])new Modifier[0]).build()).addStatement("inject(context)", new Object[0]);
        if (this.metadata.overridesAndroidEntryPointClass()) {
            method.addStatement("super.onReceive(context, intent)", new Object[0]);
        } else {
            ExecutableElement onReceiveElement = (ExecutableElement)Iterables.getOnlyElement(MoreTypes.findMethods(this.env.getElementUtils().getTypeElement(AndroidClassNames.BROADCAST_RECEIVER.toString()), "onReceive"));
            MoreTypes.findInheritedMethod(this.env.getTypeUtils(), this.metadata.baseElement(), onReceiveElement).filter(onReceive -> !onReceive.getModifiers().contains((Object)Modifier.ABSTRACT)).ifPresent(onReceive -> method.addStatement("super.onReceive(context, intent)", new Object[0]));
        }
        return method.build();
    }
}

