package dagger.hilt.processor.internal;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_ComponentDescriptor extends ComponentDescriptor {

  private final ClassName component;

  private final ImmutableSet<ClassName> scopes;

  private final Optional<ClassName> creator;

  private final Optional<ComponentDescriptor> parent;

  private AutoValue_ComponentDescriptor(
      ClassName component,
      ImmutableSet<ClassName> scopes,
      Optional<ClassName> creator,
      Optional<ComponentDescriptor> parent) {
    this.component = component;
    this.scopes = scopes;
    this.creator = creator;
    this.parent = parent;
  }

  @Override
  public ClassName component() {
    return component;
  }

  @Override
  public ImmutableSet<ClassName> scopes() {
    return scopes;
  }

  @Override
  public Optional<ClassName> creator() {
    return creator;
  }

  @Override
  public Optional<ComponentDescriptor> parent() {
    return parent;
  }

  @Override
  public String toString() {
    return "ComponentDescriptor{"
        + "component=" + component + ", "
        + "scopes=" + scopes + ", "
        + "creator=" + creator + ", "
        + "parent=" + parent
        + "}";
  }

  static final class Builder implements ComponentDescriptor.Builder {
    private ClassName component;
    private ImmutableSet<ClassName> scopes;
    private Optional<ClassName> creator = Optional.empty();
    private Optional<ComponentDescriptor> parent = Optional.empty();
    Builder() {
    }
    @Override
    public ComponentDescriptor.Builder component(ClassName component) {
      if (component == null) {
        throw new NullPointerException("Null component");
      }
      this.component = component;
      return this;
    }
    @Override
    public ComponentDescriptor.Builder scopes(ImmutableSet<ClassName> scopes) {
      if (scopes == null) {
        throw new NullPointerException("Null scopes");
      }
      this.scopes = scopes;
      return this;
    }
    @Override
    public ComponentDescriptor.Builder scopes(ClassName... scopes) {
      this.scopes = ImmutableSet.copyOf(scopes);
      return this;
    }
    @Override
    public ComponentDescriptor.Builder creator(ClassName creator) {
      this.creator = Optional.of(creator);
      return this;
    }
    @Override
    public ComponentDescriptor.Builder parent(ComponentDescriptor parent) {
      this.parent = Optional.of(parent);
      return this;
    }
    @Override
    public ComponentDescriptor build() {
      if (this.component == null
          || this.scopes == null) {
        StringBuilder missing = new StringBuilder();
        if (this.component == null) {
          missing.append(" component");
        }
        if (this.scopes == null) {
          missing.append(" scopes");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ComponentDescriptor(
          this.component,
          this.scopes,
          this.creator,
          this.parent);
    }
  }

}
