/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.base.Joiner;
import com.google.common.base.Utf8;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

final class ComponentGenerator {
    private static final Joiner JOINER = Joiner.on((String)".");
    private static final Comparator<ClassName> SIMPLE_NAME_SORTER = Comparator.comparing(c -> JOINER.join((Iterable)c.simpleNames())).thenComparing(ClassName::compareTo);
    private static final Comparator<TypeName> TYPE_NAME_SORTER = Comparator.comparing(TypeName::toString);
    private final ProcessingEnvironment processingEnv;
    private final ClassName name;
    private final Optional<ClassName> superclass;
    private final ImmutableList<ClassName> modules;
    private final ImmutableList<TypeName> entryPoints;
    private final ImmutableCollection<ClassName> scopes;
    private final ImmutableList<AnnotationSpec> extraAnnotations;
    private final ClassName componentAnnotation;
    private final Optional<TypeSpec> componentBuilder;

    public ComponentGenerator(ProcessingEnvironment processingEnv, ClassName name, Optional<ClassName> superclass, Set<? extends ClassName> modules, Set<? extends TypeName> entryPoints, ImmutableCollection<ClassName> scopes, ImmutableList<AnnotationSpec> extraAnnotations, ClassName componentAnnotation, Optional<TypeSpec> componentBuilder) {
        this.processingEnv = processingEnv;
        this.name = name;
        this.superclass = superclass;
        this.modules = (ImmutableList)modules.stream().sorted(SIMPLE_NAME_SORTER).collect(DaggerStreams.toImmutableList());
        this.entryPoints = (ImmutableList)entryPoints.stream().sorted(TYPE_NAME_SORTER).collect(DaggerStreams.toImmutableList());
        this.scopes = scopes;
        this.extraAnnotations = extraAnnotations;
        this.componentAnnotation = componentAnnotation;
        this.componentBuilder = componentBuilder;
    }

    public TypeSpec.Builder typeSpecBuilder() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(this.getComponentAnnotation());
        this.componentBuilder.ifPresent(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
        this.scopes.forEach(arg_0 -> ((TypeSpec.Builder)builder).addAnnotation(arg_0));
        this.addEntryPoints(builder);
        this.superclass.ifPresent(arg_0 -> ((TypeSpec.Builder)builder).superclass(arg_0));
        builder.addAnnotations(this.extraAnnotations);
        return builder;
    }

    private AnnotationSpec getComponentAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)this.componentAnnotation);
        this.modules.forEach(module -> builder.addMember("modules", "$T.class", new Object[]{module}));
        return builder.build();
    }

    private void addEntryPoints(TypeSpec.Builder builder) throws IOException {
        int i;
        int currBytes = 0;
        ArrayList<Integer> partitionIndexes = new ArrayList<Integer>();
        partitionIndexes.add(0);
        for (i = 0; i < this.entryPoints.size(); ++i) {
            int nextBytes = Utf8.encodedLength((CharSequence)((TypeName)this.entryPoints.get(i)).toString());
            if (currBytes + nextBytes > 60000) {
                partitionIndexes.add(i);
                currBytes = 0;
            }
            currBytes += nextBytes;
        }
        partitionIndexes.add(this.entryPoints.size());
        if (partitionIndexes.size() <= 2) {
            builder.addSuperinterfaces(this.entryPoints);
        } else {
            for (i = 1; i < partitionIndexes.size(); ++i) {
                int startIndex = (Integer)partitionIndexes.get(i - 1);
                int endIndex = (Integer)partitionIndexes.get(i);
                builder.addSuperinterface((TypeName)this.createPartitionInterface((List<TypeName>)this.entryPoints.subList(startIndex, endIndex), i));
            }
        }
    }

    private ClassName createPartitionInterface(List<TypeName> partition, int partitionIndex) throws IOException {
        ClassName partitionName = Processors.append(Processors.getEnclosedClassName(this.name), "_EntryPointPartition" + partitionIndex);
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)partitionName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addSuperinterfaces(partition);
        Processors.addGeneratedAnnotation(builder, this.processingEnv, ClassNames.ROOT_PROCESSOR.toString());
        JavaFile.builder((String)this.name.packageName(), (TypeSpec)builder.build()).build().writeTo(this.processingEnv.getFiler());
        return partitionName;
    }
}

