/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.DefineComponents;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtils;
import dagger.internal.codegen.extension.DaggerStreams;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;

public final class Components {
    public static ImmutableSet<ComponentDescriptor> getComponentDescriptors(Elements elements, Element element) {
        DefineComponents defineComponents = DefineComponents.create();
        return (ImmutableSet)Components.getComponents(elements, element).stream().map(component -> elements.getTypeElement(component.canonicalName())).map(defineComponents::componentDescriptor).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableSet<ClassName> getComponents(Elements elements, Element element) {
        if (!Processors.hasAnnotation(element, ClassNames.INSTALL_IN) && !Processors.hasAnnotation(element, ClassNames.TEST_INSTALL_IN)) {
            Element enclosing = element.getEnclosingElement();
            if (enclosing != null && MoreElements.isType(enclosing) && MoreElements.isType(element) && Processors.hasAnnotation(enclosing, ClassNames.MODULE) && KotlinMetadataUtils.getMetadataUtil().isCompanionObjectClass(MoreElements.asType(element))) {
                return Components.getComponents(elements, enclosing);
            }
            if (Processors.hasErrorTypeAnnotation(element)) {
                throw new BadInputException("Error annotation found on element " + element + ". Look above for compilation errors", element);
            }
            throw new BadInputException(String.format("An @InstallIn annotation is required for: %s.", element), element);
        }
        ImmutableSet<ClassName> components = Components.getHiltInstallInComponents(elements, element);
        return components;
    }

    public static AnnotationSpec getInstallInAnnotationSpec(ImmutableSet<ClassName> components) {
        Preconditions.checkArgument((!components.isEmpty() ? 1 : 0) != 0);
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.INSTALL_IN);
        components.forEach(component -> builder.addMember("value", "$T.class", new Object[]{component}));
        return builder.build();
    }

    private static ImmutableSet<ClassName> getHiltInstallInComponents(Elements elements, Element element) {
        Preconditions.checkArgument((Processors.hasAnnotation(element, ClassNames.INSTALL_IN) || Processors.hasAnnotation(element, ClassNames.TEST_INSTALL_IN) ? 1 : 0) != 0);
        ImmutableSet components = ImmutableSet.copyOf(Processors.hasAnnotation(element, ClassNames.INSTALL_IN) ? Processors.getAnnotationClassValues(elements, Processors.getAnnotationMirror(element, ClassNames.INSTALL_IN), "value") : Processors.getAnnotationClassValues(elements, Processors.getAnnotationMirror(element, ClassNames.TEST_INSTALL_IN), "components"));
        ImmutableSet undefinedComponents = (ImmutableSet)components.stream().filter(component -> !Processors.hasAnnotation((Element)component, ClassNames.DEFINE_COMPONENT)).collect(DaggerStreams.toImmutableSet());
        ProcessorErrors.checkState(undefinedComponents.isEmpty(), element, "@InstallIn, can only be used with @DefineComponent-annotated classes, but found: %s", undefinedComponents);
        return (ImmutableSet)components.stream().map(ClassName::get).collect(DaggerStreams.toImmutableSet());
    }

    private Components() {
    }
}

