/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public final class FragmentGenerator {
    private static final FieldSpec COMPONENT_CONTEXT_FIELD = FieldSpec.builder((TypeName)AndroidClassNames.CONTEXT_WRAPPER, (String)"componentContext", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    private static final FieldSpec DISABLE_GET_CONTEXT_FIX_FIELD = FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)"disableGetContextFix", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    private final ProcessingEnvironment env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public FragmentGenerator(ProcessingEnvironment env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)this.createTypeSpec()).build().writeTo(this.env.getFiler());
    }

    TypeSpec createTypeSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).addOriginatingElement((Element)this.metadata.element()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers()).addField(COMPONENT_CONTEXT_FIELD).addMethod(FragmentGenerator.onAttachContextMethod()).addMethod(FragmentGenerator.onAttachActivityMethod()).addMethod(this.initializeComponentContextMethod()).addMethod(this.getContextMethod()).addMethod(this.inflatorMethod());
        if (HiltCompilerOptions.useFragmentGetContextFix(this.env)) {
            builder.addField(DISABLE_GET_CONTEXT_FIX_FIELD);
        }
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyLintAnnotations(this.metadata.element(), builder);
        Generators.copySuppressAnnotations(this.metadata.element(), builder);
        Generators.copyConstructors(this.metadata.baseElement(), builder);
        this.metadata.baseElement().getTypeParameters().stream().map(TypeVariableName::get).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addComponentOverride(this.metadata, builder);
        Generators.addInjectionMethods(this.metadata, builder);
        if (!this.metadata.overridesAndroidEntryPointClass()) {
            builder.addMethod(this.getDefaultViewModelProviderFactory());
        }
        return builder.build();
    }

    private static MethodSpec onAttachContextMethod() {
        return MethodSpec.methodBuilder((String)"onAttach").addAnnotation(Override.class).addAnnotation(AndroidClassNames.CALL_SUPER).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)AndroidClassNames.CONTEXT, "context", new Modifier[0]).addStatement("super.onAttach(context)", new Object[0]).addStatement("initializeComponentContext()", new Object[0]).addStatement("inject()", new Object[0]).build();
    }

    private static MethodSpec onAttachActivityMethod() {
        return MethodSpec.methodBuilder((String)"onAttach").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.SUPPRESS_WARNINGS).addMember("value", "\"deprecation\"", new Object[0]).build()).addAnnotation(AndroidClassNames.CALL_SUPER).addAnnotation(AndroidClassNames.MAIN_THREAD).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)AndroidClassNames.ACTIVITY, "activity", new Modifier[0]).addStatement("super.onAttach(activity)", new Object[0]).addStatement("$T.checkState($N == null || $T.findActivity($N) == activity, $S)", new Object[]{ClassNames.PRECONDITIONS, COMPONENT_CONTEXT_FIELD, AndroidClassNames.FRAGMENT_COMPONENT_MANAGER, COMPONENT_CONTEXT_FIELD, "onAttach called multiple times with different Context! Hilt Fragments should not be retained."}).addStatement("initializeComponentContext()", new Object[0]).addStatement("inject()", new Object[0]).build();
    }

    private MethodSpec initializeComponentContextMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initializeComponentContext").addModifiers(new Modifier[]{Modifier.PRIVATE}).beginControlFlow("if ($N == null)", new Object[]{COMPONENT_CONTEXT_FIELD}).addComment("Note: The LayoutInflater provided by this componentContext may be different from super Fragment's because we getting it from base context instead of cloning from the super Fragment's LayoutInflater.", new Object[0]).addStatement("$N = $T.createContextWrapper(super.getContext(), this)", new Object[]{COMPONENT_CONTEXT_FIELD, this.metadata.componentManager()});
        if (HiltCompilerOptions.useFragmentGetContextFix(this.env)) {
            builder.addStatement("$N = $T.isFragmentGetContextFixDisabled(super.getContext())", new Object[]{DISABLE_GET_CONTEXT_FIX_FIELD, AndroidClassNames.FRAGMENT_GET_CONTEXT_FIX});
        }
        return builder.endControlFlow().build();
    }

    private MethodSpec getContextMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getContext").returns((TypeName)AndroidClassNames.CONTEXT).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (HiltCompilerOptions.useFragmentGetContextFix(this.env)) {
            builder.beginControlFlow("if (super.getContext() == null && !$N)", new Object[]{DISABLE_GET_CONTEXT_FIX_FIELD});
        } else {
            builder.beginControlFlow("if (super.getContext() == null && $N == null)", new Object[]{COMPONENT_CONTEXT_FIELD});
        }
        return builder.addStatement("return null", new Object[0]).endControlFlow().addStatement("initializeComponentContext()", new Object[0]).addStatement("return $N", new Object[]{COMPONENT_CONTEXT_FIELD}).build();
    }

    private MethodSpec inflatorMethod() {
        return MethodSpec.methodBuilder((String)"onGetLayoutInflater").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)AndroidClassNames.BUNDLE, "savedInstanceState", new Modifier[0]).returns((TypeName)AndroidClassNames.LAYOUT_INFLATER).addStatement("$T inflater = super.onGetLayoutInflater(savedInstanceState)", new Object[]{AndroidClassNames.LAYOUT_INFLATER}).addStatement("return $T.from($T.createContextWrapper(inflater, this))", new Object[]{AndroidClassNames.LAYOUT_INFLATER, this.metadata.componentManager()}).build();
    }

    private MethodSpec getDefaultViewModelProviderFactory() {
        return MethodSpec.methodBuilder((String)"getDefaultViewModelProviderFactory").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)AndroidClassNames.VIEW_MODEL_PROVIDER_FACTORY).addStatement("return $T.getFragmentFactory(this, super.getDefaultViewModelProviderFactory())", new Object[]{AndroidClassNames.DEFAULT_VIEW_MODEL_FACTORIES}).build();
    }
}

