/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponentClassesMetadata;
import dagger.hilt.processor.internal.earlyentrypoint.AggregatedEarlyEntryPointMetadata;
import dagger.hilt.processor.internal.generatesrootinput.GeneratesRootInputs;
import dagger.hilt.processor.internal.root.AggregatedRootGenerator;
import dagger.hilt.processor.internal.root.AggregatedRootMetadata;
import dagger.hilt.processor.internal.root.ComponentTreeDepsGenerator;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.ProcessedRootSentinelGenerator;
import dagger.hilt.processor.internal.root.ProcessedRootSentinelMetadata;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootType;
import dagger.hilt.processor.internal.root.TestInjectorGenerator;
import dagger.hilt.processor.internal.root.TestRootMetadata;
import dagger.hilt.processor.internal.root.ir.AggregatedDepsIr;
import dagger.hilt.processor.internal.root.ir.AggregatedEarlyEntryPointIr;
import dagger.hilt.processor.internal.root.ir.AggregatedRootIr;
import dagger.hilt.processor.internal.root.ir.AggregatedUninstallModulesIr;
import dagger.hilt.processor.internal.root.ir.AliasOfPropagatedDataIr;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIr;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIrCreator;
import dagger.hilt.processor.internal.root.ir.DefineComponentClassesIr;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

public final class RootProcessor
extends BaseProcessor {
    private static final Comparator<TypeElement> QUALIFIED_NAME_COMPARATOR = Comparator.comparing(TypeElement::getQualifiedName, (n1, n2) -> n1.toString().compareTo(n2.toString()));
    private boolean processed;
    private GeneratesRootInputs generatesRootInputs;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.generatesRootInputs = new GeneratesRootInputs(processingEnvironment);
    }

    public ImmutableSet<String> additionalProcessingOptions() {
        return HiltCompilerOptions.useAggregatingRootProcessor(this.getProcessingEnv()) ? ImmutableSet.of((Object)IncrementalAnnotationProcessorType.AGGREGATING.getProcessorOption()) : ImmutableSet.of((Object)IncrementalAnnotationProcessorType.ISOLATING.getProcessorOption());
    }

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.builder().addAll((Iterable)Arrays.stream(RootType.values()).map(rootType -> rootType.className().toString()).collect(DaggerStreams.toImmutableSet())).build();
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        TypeElement rootElement = MoreElements.asType(element);
        RootType rootType = RootType.of(rootElement);
        if (rootType.isTestRoot()) {
            new TestInjectorGenerator(this.getProcessingEnv(), TestRootMetadata.of(this.getProcessingEnv(), rootElement)).generate();
        }
        TypeElement originatingRootElement = Root.create(rootElement, this.getProcessingEnv()).originatingRootElement();
        new AggregatedRootGenerator(rootElement, originatingRootElement, annotation, this.getProcessingEnv()).generate();
    }

    @Override
    public void postRoundProcess(RoundEnvironment roundEnv) throws Exception {
        if (!HiltCompilerOptions.useAggregatingRootProcessor(this.getProcessingEnv())) {
            return;
        }
        ImmutableSet<Element> newElements = this.generatesRootInputs.getElementsToWaitFor(roundEnv);
        if (this.processed) {
            Preconditions.checkState((boolean)newElements.isEmpty(), (String)"Found extra modules after compilation: %s\n(If you are adding an annotation processor that generates root input for hilt, the annotation must be annotated with @dagger.hilt.GeneratesRootInput.\n)", newElements);
        } else if (newElements.isEmpty()) {
            this.processed = true;
            ImmutableList<TypeElement> rootsToProcess = this.rootsToProcess();
            if (rootsToProcess.isEmpty()) {
                return;
            }
            ComponentTreeDepsGenerator componentTreeDepsGenerator = new ComponentTreeDepsGenerator(this.getProcessingEnv());
            for (ComponentTreeDepsMetadata metadata : this.componentTreeDepsMetadatas(rootsToProcess)) {
                componentTreeDepsGenerator.generate(metadata);
            }
            for (TypeElement rootElement : rootsToProcess) {
                new ProcessedRootSentinelGenerator(rootElement, this.getProcessingEnv()).generate();
            }
        }
    }

    private ImmutableList<TypeElement> rootsToProcess() {
        ImmutableSet allRoots = (ImmutableSet)AggregatedRootMetadata.from(this.processingEnv).stream().map(metadata -> Root.create(metadata.rootElement(), this.getProcessingEnv())).collect(DaggerStreams.toImmutableSet());
        ImmutableSet processedRoots = (ImmutableSet)ProcessedRootSentinelMetadata.from(this.getElementUtils()).stream().flatMap(metadata -> metadata.rootElements().stream()).map(rootElement -> Root.create(rootElement, this.getProcessingEnv())).collect(DaggerStreams.toImmutableSet());
        ImmutableSet rootsToProcess = (ImmutableSet)allRoots.stream().filter(root -> !processedRoots.contains(root)).collect(DaggerStreams.toImmutableSet());
        ImmutableSet rootElementsToProcess = (ImmutableSet)rootsToProcess.stream().map(Root::element).sorted(QUALIFIED_NAME_COMPARATOR).collect(DaggerStreams.toImmutableSet());
        ImmutableSet appRootElementsToProcess = (ImmutableSet)rootsToProcess.stream().filter(root -> !root.isTestRoot()).map(Root::element).sorted(QUALIFIED_NAME_COMPARATOR).collect(DaggerStreams.toImmutableSet());
        if (!appRootElementsToProcess.isEmpty()) {
            ImmutableSet testRootElementsToProcess = (ImmutableSet)rootsToProcess.stream().filter(Root::isTestRoot).map(Root::element).sorted(QUALIFIED_NAME_COMPARATOR).collect(DaggerStreams.toImmutableSet());
            ProcessorErrors.checkState(testRootElementsToProcess.isEmpty(), "Cannot process test roots and app roots in the same compilation unit:\n\tApp root in this compilation unit: %s\n\tTest roots in this compilation unit: %s", appRootElementsToProcess, testRootElementsToProcess);
            ProcessorErrors.checkState(appRootElementsToProcess.size() == 1, "Cannot process multiple app roots in the same compilation unit: %s", appRootElementsToProcess);
        }
        if (!HiltCompilerOptions.isCrossCompilationRootValidationDisabled((ImmutableSet<TypeElement>)rootElementsToProcess, this.getProcessingEnv())) {
            ImmutableSet processedTestRootElements = (ImmutableSet)allRoots.stream().filter(Root::isTestRoot).filter(root -> !rootsToProcess.contains(root)).map(Root::element).sorted(QUALIFIED_NAME_COMPARATOR).collect(DaggerStreams.toImmutableSet());
            ProcessorErrors.checkState(processedTestRootElements.isEmpty(), "Cannot process new roots when there are test roots from a previous compilation unit:\n\tTest roots from previous compilation unit: %s\n\tAll roots from this compilation unit: %s", processedTestRootElements, rootElementsToProcess);
            ImmutableSet processedAppRootElements = (ImmutableSet)allRoots.stream().filter(root -> !root.isTestRoot()).filter(root -> !rootsToProcess.contains(root)).map(Root::element).sorted(QUALIFIED_NAME_COMPARATOR).collect(DaggerStreams.toImmutableSet());
            ProcessorErrors.checkState(processedAppRootElements.isEmpty() || appRootElementsToProcess.isEmpty(), "Cannot process app roots in this compilation unit since there are app roots in a previous compilation unit:\n\tApp roots in previous compilation unit: %s\n\tApp roots in this compilation unit: %s", processedAppRootElements, appRootElementsToProcess);
        }
        return (ImmutableList)rootsToProcess.stream().map(Root::element).collect(DaggerStreams.toImmutableList());
    }

    private ImmutableSet<ComponentTreeDepsMetadata> componentTreeDepsMetadatas(ImmutableList<TypeElement> rootElementsToProcess) {
        ImmutableSet aggregatedRootMetadatas = (ImmutableSet)AggregatedRootMetadata.from(this.processingEnv).stream().filter(metadata -> rootElementsToProcess.contains((Object)metadata.rootElement())).collect(DaggerStreams.toImmutableSet());
        boolean isTest = aggregatedRootMetadatas.stream().anyMatch(metadata -> metadata.rootType().isTestRoot());
        ImmutableSet aggregatedRoots = (ImmutableSet)aggregatedRootMetadatas.stream().map(AggregatedRootMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet defineComponentDeps = (ImmutableSet)DefineComponentClassesMetadata.from(this.getElementUtils()).stream().map(DefineComponentClassesMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aliasOfDeps = (ImmutableSet)AliasOfPropagatedDataMetadata.from(this.getElementUtils()).stream().map(AliasOfPropagatedDataMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedDeps = (ImmutableSet)AggregatedDepsMetadata.from(this.getElementUtils()).stream().map(AggregatedDepsMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedUninstallModulesDeps = (ImmutableSet)AggregatedUninstallModulesMetadata.from(this.getElementUtils()).stream().map(AggregatedUninstallModulesMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedEarlyEntryPointDeps = (ImmutableSet)AggregatedEarlyEntryPointMetadata.from(this.getElementUtils()).stream().map(AggregatedEarlyEntryPointMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        Set<ComponentTreeDepsIr> componentTreeDeps = ComponentTreeDepsIrCreator.components(isTest, HiltCompilerOptions.isSharedTestComponentsEnabled(this.processingEnv), (Set<AggregatedRootIr>)aggregatedRoots, (Set<DefineComponentClassesIr>)defineComponentDeps, (Set<AliasOfPropagatedDataIr>)aliasOfDeps, (Set<AggregatedDepsIr>)aggregatedDeps, (Set<AggregatedUninstallModulesIr>)aggregatedUninstallModulesDeps, (Set<AggregatedEarlyEntryPointIr>)aggregatedEarlyEntryPointDeps);
        return (ImmutableSet)componentTreeDeps.stream().map(it -> ComponentTreeDepsMetadata.from(it, this.getElementUtils())).collect(DaggerStreams.toImmutableSet());
    }
}

