/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;

public final class HiltCompilerOptions {
    public static boolean isAndroidSuperclassValidationDisabled(TypeElement element, ProcessingEnvironment env) {
        BooleanOption option = BooleanOption.DISABLE_ANDROID_SUPERCLASS_VALIDATION;
        return option.get(env);
    }

    public static boolean isCrossCompilationRootValidationDisabled(ImmutableSet<TypeElement> rootElements, ProcessingEnvironment env) {
        BooleanOption option = BooleanOption.DISABLE_CROSS_COMPILATION_ROOT_VALIDATION;
        return option.get(env);
    }

    public static boolean isModuleInstallInCheckDisabled(ProcessingEnvironment env) {
        return BooleanOption.DISABLE_MODULES_HAVE_INSTALL_IN_CHECK.get(env);
    }

    public static boolean isSharedTestComponentsEnabled(ProcessingEnvironment env) {
        return BooleanOption.SHARE_TEST_COMPONENTS.get(env);
    }

    public static boolean useAggregatingRootProcessor(ProcessingEnvironment env) {
        return BooleanOption.USE_AGGREGATING_ROOT_PROCESSOR.get(env);
    }

    public static boolean useFragmentGetContextFix(ProcessingEnvironment env) {
        return BooleanOption.USE_FRAGMENT_GET_CONTEXT_FIX.get(env);
    }

    public static Set<String> getProcessorOptions() {
        return Arrays.stream(BooleanOption.values()).map(BooleanOption::getQualifiedName).collect(Collectors.toSet());
    }

    private static enum BooleanOption {
        DISABLE_ANDROID_SUPERCLASS_VALIDATION("android.internal.disableAndroidSuperclassValidation", false),
        USE_AGGREGATING_ROOT_PROCESSOR("internal.useAggregatingRootProcessor", true),
        DISABLE_CROSS_COMPILATION_ROOT_VALIDATION("disableCrossCompilationRootValidation", false),
        DISABLE_MODULES_HAVE_INSTALL_IN_CHECK("disableModulesHaveInstallInCheck", false),
        SHARE_TEST_COMPONENTS("shareTestComponents", false),
        USE_FRAGMENT_GET_CONTEXT_FIX("android.useFragmentGetContextFix", false);

        private final String name;
        private final boolean defaultValue;

        private BooleanOption(String name, boolean defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        boolean get(ProcessingEnvironment env) {
            String value = env.getOptions().get(this.getQualifiedName());
            if (value == null) {
                return this.defaultValue;
            }
            return Boolean.parseBoolean(value);
        }

        String getQualifiedName() {
            return "dagger.hilt." + this.name;
        }
    }
}

