/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ProducerToken {
    @Nullable
    private final Class<?> classToken;
    @Nullable
    private final String methodName;

    private ProducerToken(@Nullable Class<?> classToken, @Nullable String methodName) {
        this.classToken = classToken;
        this.methodName = methodName;
    }

    public static ProducerToken create(Class<?> classToken) {
        return new ProducerToken((Class)Preconditions.checkNotNull(classToken), null);
    }

    public static ProducerToken create(String methodName) {
        return new ProducerToken(null, (String)Preconditions.checkNotNull((Object)methodName));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProducerToken) {
            ProducerToken that = (ProducerToken)o;
            return Objects.equals(this.classToken, that.classToken) && Objects.equals(this.methodName, that.methodName);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.classToken);
        h *= 1000003;
        return h ^= Objects.hashCode(this.methodName);
    }

    public String toString() {
        if (this.methodName != null) {
            return this.methodName;
        }
        if (this.classToken != null) {
            return this.classToken.getCanonicalName();
        }
        throw new IllegalStateException();
    }
}

