/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.CancellationListener;
import dagger.producers.internal.Producers;
import java.util.Map;
import javax.inject.Provider;

public final class MapOfProducerProducer<K, V>
extends AbstractProducer<Map<K, Producer<V>>> {
    private final ImmutableMap<K, Producer<V>> contributingMap;
    private static final Function<Producer<?>, Producer<?>> TO_DEPENDENCY_VIEW = new Function<Producer<?>, Producer<?>>(){

        public Producer<?> apply(Producer<?> input) {
            return Producers.nonCancellationPropagatingViewOf(input);
        }
    };

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    private MapOfProducerProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        this.contributingMap = contributingMap;
    }

    @Override
    public ListenableFuture<Map<K, Producer<V>>> compute() {
        return Futures.immediateFuture(this.contributingMap);
    }

    @Override
    public Producer<Map<K, Producer<V>>> newDependencyView() {
        return this.newTransformedValuesView(MapOfProducerProducer.toDependencyView());
    }

    @Override
    public Producer<Map<K, Producer<V>>> newEntryPointView(CancellationListener cancellationListener) {
        return this.newTransformedValuesView(MapOfProducerProducer.toEntryPointView(cancellationListener));
    }

    private Producer<Map<K, Producer<V>>> newTransformedValuesView(Function<Producer<V>, Producer<V>> valueTransformationFunction) {
        return dagger.producers.Producers.immediateProducer(ImmutableMap.copyOf((Map)Maps.transformValues(this.contributingMap, valueTransformationFunction)));
    }

    private static <T> Function<Producer<T>, Producer<T>> toDependencyView() {
        return TO_DEPENDENCY_VIEW;
    }

    private static <T> Function<Producer<T>, Producer<T>> toEntryPointView(final CancellationListener cancellationListener) {
        return new Function<Producer<T>, Producer<T>>(){

            public Producer<T> apply(Producer<T> input) {
                return Producers.entryPointViewOf(input, cancellationListener);
            }
        };
    }

    public static final class Builder<K, V> {
        private final ImmutableMap.Builder<K, Producer<V>> mapBuilder;

        private Builder(int size) {
            this.mapBuilder = ImmutableMap.builderWithExpectedSize((int)size);
        }

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(producerOfValue, (Object)"producer of value");
            this.mapBuilder.put(key, producerOfValue);
            return this;
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(providerOfValue, (Object)"provider of value");
            this.mapBuilder.put(key, Producers.producerFromProvider(providerOfValue));
            return this;
        }

        public Builder<K, V> putAll(Producer<Map<K, Producer<V>>> mapProducerProducer) {
            this.mapBuilder.putAll((Map)((MapOfProducerProducer)mapProducerProducer).contributingMap);
            return this;
        }

        public MapOfProducerProducer<K, V> build() {
            return new MapOfProducerProducer(this.mapBuilder.build());
        }
    }
}

