/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.internal.Producers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Provider;

public final class MapOfProducedProducer<K, V>
extends AbstractProducer<Map<K, Produced<V>>> {
    private final Map<K, Producer<V>> contributingMap;
    private static final Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Produced<Object>>>> ENTRY_UNWRAPPER = new Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Produced<Object>>>>(){

        public ListenableFuture<Map.Entry<Object, Produced<Object>>> apply(final Map.Entry<Object, Producer<Object>> entry) {
            return Futures.transform(Producers.createFutureProduced(entry.getValue().get()), (Function)new Function<Produced<Object>, Map.Entry<Object, Produced<Object>>>(){

                public Map.Entry<Object, Produced<Object>> apply(Produced<Object> value) {
                    return Maps.immutableEntry(entry.getKey(), value);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    };

    private MapOfProducedProducer(Map<K, Producer<V>> contributingMap) {
        this.contributingMap = contributingMap;
    }

    @Override
    public ListenableFuture<Map<K, Produced<V>>> compute() {
        return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)Iterables.transform(this.contributingMap.entrySet(), MapOfProducedProducer.entryUnwrapper())), (Function)new Function<List<Map.Entry<K, Produced<V>>>, Map<K, Produced<V>>>(){

            public Map<K, Produced<V>> apply(List<Map.Entry<K, Produced<V>>> entries) {
                return ImmutableMap.copyOf(entries);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static <K, V> Function<Map.Entry<K, Producer<V>>, ListenableFuture<Map.Entry<K, Produced<V>>>> entryUnwrapper() {
        return ENTRY_UNWRAPPER;
    }

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    public static final class Builder<K, V> {
        private final ImmutableMap.Builder<K, Producer<V>> mapBuilder;

        private Builder(int size) {
            this.mapBuilder = ImmutableMap.builderWithExpectedSize((int)size);
        }

        public MapOfProducedProducer<K, V> build() {
            return new MapOfProducedProducer((Map)this.mapBuilder.build());
        }

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(producerOfValue, (Object)"producer of value");
            this.mapBuilder.put(key, producerOfValue);
            return this;
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(providerOfValue, (Object)"provider of value");
            this.mapBuilder.put(key, Producers.producerFromProvider(providerOfValue));
            return this;
        }

        public Builder<K, V> putAll(Producer<Map<K, Produced<V>>> mapOfProducedProducer) {
            this.mapBuilder.putAll(((MapOfProducedProducer)mapOfProducedProducer).contributingMap);
            return this;
        }
    }
}

