/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.HasBindingMembers;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.MembersInjectorRequestFulfillment;
import dagger.internal.codegen.ProducerFieldRequestFulfillment;
import dagger.internal.codegen.ProviderFieldRequestFulfillment;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.RequestFulfillment;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SimpleMethodRequestFulfillment;
import java.util.Map;

final class RequestFulfillmentRegistry {
    private final ImmutableMap<BindingKey, ResolvedBindings> resolvedBindingsMap;
    private final HasBindingMembers hasBindingMembers;
    private final Map<BindingKey, RequestFulfillment> requestFulfillments;

    RequestFulfillmentRegistry(ImmutableMap<BindingKey, ResolvedBindings> resolvedBindingsMap, HasBindingMembers hasBindingMembers) {
        this.resolvedBindingsMap = resolvedBindingsMap;
        this.hasBindingMembers = hasBindingMembers;
        this.requestFulfillments = Maps.newLinkedHashMapWithExpectedSize((int)resolvedBindingsMap.size());
    }

    RequestFulfillment getRequestFulfillment(BindingKey bindingKey) {
        return this.requestFulfillments.computeIfAbsent(bindingKey, this::createRequestFulfillment);
    }

    private RequestFulfillment createRequestFulfillment(BindingKey bindingKey) {
        MemberSelect memberSelect = this.hasBindingMembers.getMemberSelect(bindingKey);
        ResolvedBindings resolvedBindings = (ResolvedBindings)this.resolvedBindingsMap.get((Object)bindingKey);
        switch (resolvedBindings.bindingType()) {
            case MEMBERS_INJECTION: {
                return new MembersInjectorRequestFulfillment(bindingKey, memberSelect);
            }
            case PRODUCTION: {
                return new ProducerFieldRequestFulfillment(bindingKey, memberSelect);
            }
            case PROVISION: {
                ProvisionBinding provisionBinding = (ProvisionBinding)resolvedBindings.contributionBinding();
                ProviderFieldRequestFulfillment providerFieldRequestFulfillment = new ProviderFieldRequestFulfillment(bindingKey, memberSelect);
                if (provisionBinding.implicitDependencies().isEmpty() && !provisionBinding.scope().isPresent() && !provisionBinding.requiresModuleInstance() && provisionBinding.bindingElement().isPresent() && (provisionBinding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) || provisionBinding.bindingKind().equals((Object)ContributionBinding.Kind.PROVISION))) {
                    return new SimpleMethodRequestFulfillment(bindingKey, provisionBinding, providerFieldRequestFulfillment, this);
                }
                return providerFieldRequestFulfillment;
            }
        }
        throw new AssertionError();
    }
}

