/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AutoValue_OptionalType;
import dagger.internal.codegen.Key;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;

abstract class OptionalType {
    private static final TypeVisitor<com.google.common.base.Optional<OptionalKind>, Void> OPTIONAL_KIND = new SimpleTypeVisitor8<com.google.common.base.Optional<OptionalKind>, Void>(com.google.common.base.Optional.absent()){

        @Override
        public com.google.common.base.Optional<OptionalKind> visitDeclared(DeclaredType t, Void p) {
            for (OptionalKind optionalKind : OptionalKind.values()) {
                Name qualifiedName = MoreElements.asType(t.asElement()).getQualifiedName();
                if (!qualifiedName.contentEquals(optionalKind.clazz.getCanonicalName())) continue;
                return com.google.common.base.Optional.of((Object)((Object)optionalKind));
            }
            return com.google.common.base.Optional.absent();
        }
    };

    OptionalType() {
    }

    @Deprecated
    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredOptionalType();

    DeclaredType declaredOptionalType() {
        return (DeclaredType)this.wrappedDeclaredOptionalType().get();
    }

    OptionalKind kind() {
        return (OptionalKind)((Object)this.declaredOptionalType().accept(OPTIONAL_KIND, null).get());
    }

    TypeMirror valueType() {
        return this.declaredOptionalType().getTypeArguments().get(0);
    }

    static boolean isOptional(TypeMirror type) {
        return type.accept(OPTIONAL_KIND, null).isPresent();
    }

    static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type());
    }

    static OptionalType from(TypeMirror type) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type), (String)"%s must be an Optional", (Object)type);
        return new AutoValue_OptionalType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type)));
    }

    static OptionalType from(Key key) {
        return OptionalType.from(key.type());
    }

    static enum OptionalKind {
        GUAVA_OPTIONAL(com.google.common.base.Optional.class, "absent"),
        JDK_OPTIONAL(Optional.class, "empty");

        private final Class<?> clazz;
        private final String absentFactoryMethodName;

        private OptionalKind(Class<?> clazz, String absentFactoryMethodName) {
            this.clazz = clazz;
            this.absentFactoryMethodName = absentFactoryMethodName;
        }

        ParameterizedTypeName of(TypeName valueType) {
            return ParameterizedTypeName.get(ClassName.get(this.clazz), valueType);
        }

        CodeBlock absentValueExpression() {
            return CodeBlock.of("$T.$L()", this.clazz, this.absentFactoryMethodName);
        }

        CodeBlock presentExpression(CodeBlock value) {
            return CodeBlock.of("$T.of($L)", this.clazz, value);
        }
    }
}

