/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.MembersInjectors;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.Proxies;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

final class FactoryGenerator
extends SourceFileGenerator<ProvisionBinding> {
    private final CompilerOptions compilerOptions;
    private final InjectValidator injectValidator;

    FactoryGenerator(Filer filer, Elements elements, CompilerOptions compilerOptions, InjectValidator injectValidator) {
        super(filer, elements);
        this.compilerOptions = compilerOptions;
        this.injectValidator = injectValidator;
    }

    @Override
    ClassName nameGeneratedType(ProvisionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProvisionBinding binding) {
        return binding.bindingElement();
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ProvisionBinding binding) {
        Optional createMethod;
        boolean factoryHasTypeParameters;
        com.google.common.base.Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        com.google.common.base.Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        if (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) && !this.injectValidator.isValidType(binding.contributedType())) {
            return Optional.absent();
        }
        TypeName providedTypeName = TypeName.get(binding.contributedType());
        ParameterizedTypeName factoryTypeName = TypeNames.factoryOf(providedTypeName);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder(generatedTypeName).addModifiers(Modifier.FINAL);
        boolean bl = factoryHasTypeParameters = (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) || binding.requiresModuleInstance()) && !typeParameters.isEmpty();
        if (factoryHasTypeParameters) {
            factoryBuilder.addTypeVariables((Iterable<TypeVariableName>)typeParameters);
        }
        Optional constructorBuilder = Optional.absent();
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        ImmutableMap.Builder fieldsBuilder = ImmutableMap.builder();
        switch (binding.factoryCreationStrategy()) {
            case SINGLETON_INSTANCE: {
                FieldSpec.Builder instanceFieldBuilder = FieldSpec.builder(generatedTypeName, "INSTANCE", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("new $T()", generatedTypeName);
                if (factoryHasTypeParameters) {
                    instanceFieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
                }
                factoryBuilder.addField(instanceFieldBuilder.build());
                break;
            }
            case CLASS_CONSTRUCTOR: {
                constructorBuilder = Optional.of((Object)MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC));
                if (binding.requiresModuleInstance()) {
                    this.addConstructorParameterAndTypeField(TypeName.get(((TypeElement)binding.bindingTypeElement().get()).asType()), "module", factoryBuilder, (MethodSpec.Builder)constructorBuilder.get());
                }
                for (Map.Entry entry : SourceFiles.generateBindingFieldsForDependencies(binding).entrySet()) {
                    BindingKey bindingKey = (BindingKey)entry.getKey();
                    FrameworkField bindingField = (FrameworkField)entry.getValue();
                    FieldSpec field = this.addConstructorParameterAndTypeField(bindingField.type(), uniqueFieldNames.getUniqueName(bindingField.name()), factoryBuilder, (MethodSpec.Builder)constructorBuilder.get());
                    fieldsBuilder.put((Object)bindingKey, (Object)field);
                }
                break;
            }
            case DELEGATE: {
                return Optional.absent();
            }
            default: {
                throw new AssertionError();
            }
        }
        ImmutableMap fields = fieldsBuilder.build();
        factoryBuilder.addModifiers(Modifier.PUBLIC).addSuperinterface(factoryTypeName);
        switch (binding.bindingKind()) {
            case INJECTION: 
            case PROVISION: {
                MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(factoryTypeName);
                if (factoryHasTypeParameters) {
                    createMethodBuilder.addTypeVariables((Iterable<TypeVariableName>)typeParameters);
                }
                UnmodifiableIterator params = constructorBuilder.isPresent() ? ((MethodSpec.Builder)constructorBuilder.get()).build().parameters : ImmutableList.of();
                createMethodBuilder.addParameters((Iterable<ParameterSpec>)params);
                switch (binding.factoryCreationStrategy()) {
                    case SINGLETON_INSTANCE: {
                        if (factoryHasTypeParameters) {
                            createMethodBuilder.addStatement("return ($T) INSTANCE", TypeNames.FACTORY);
                            createMethodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, AnnotationSpecs.Suppression.UNCHECKED));
                            break;
                        }
                        createMethodBuilder.addStatement("return INSTANCE", new Object[0]);
                        break;
                    }
                    case CLASS_CONSTRUCTOR: {
                        createMethodBuilder.addStatement("return new $T($L)", SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(Lists.transform((List)params, input -> CodeBlock.of("$N", input))));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                createMethod = Optional.of((Object)createMethodBuilder.build());
                break;
            }
            default: {
                createMethod = Optional.absent();
            }
        }
        if (constructorBuilder.isPresent()) {
            factoryBuilder.addMethod(((MethodSpec.Builder)constructorBuilder.get()).build());
        }
        ArrayList parameters = Lists.newArrayList();
        for (DependencyRequest dependency : binding.explicitDependencies()) {
            parameters.add(SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$N", fields.get((Object)dependency.bindingKey())), dependency.kind()));
        }
        CodeBlock parametersCodeBlock = CodeBlocks.makeParametersCodeBlock(parameters);
        MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder("get").returns(providedTypeName).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC);
        if (binding.bindingKind().equals((Object)ContributionBinding.Kind.PROVISION)) {
            CodeBlock.Builder providesMethodInvocationBuilder = CodeBlock.builder();
            if (binding.requiresModuleInstance()) {
                providesMethodInvocationBuilder.add("module", new Object[0]);
            } else {
                providesMethodInvocationBuilder.add("$T", ClassName.get((TypeElement)binding.bindingTypeElement().get()));
            }
            providesMethodInvocationBuilder.add(".$L($L)", ((Element)binding.bindingElement().get()).getSimpleName(), parametersCodeBlock);
            CodeBlock providesMethodInvocation = providesMethodInvocationBuilder.build();
            if (binding.nullableType().isPresent() || this.compilerOptions.nullableValidationKind().equals((Object)Diagnostic.Kind.WARNING)) {
                if (binding.nullableType().isPresent()) {
                    getMethodBuilder.addAnnotation((ClassName)TypeName.get((TypeMirror)binding.nullableType().get()));
                }
                getMethodBuilder.addStatement("return $L", providesMethodInvocation);
            } else {
                getMethodBuilder.addStatement("return $T.checkNotNull($L, $S)", Preconditions.class, providesMethodInvocation, "Cannot return null from a non-@Nullable @Provides method");
            }
        } else if (binding.membersInjectionRequest().isPresent()) {
            getMethodBuilder.addStatement("return $T.injectMembers($N, new $T($L))", MembersInjectors.class, fields.get((Object)((DependencyRequest)binding.membersInjectionRequest().get()).bindingKey()), providedTypeName, parametersCodeBlock);
        } else {
            getMethodBuilder.addStatement("return new $T($L)", providedTypeName, parametersCodeBlock);
        }
        factoryBuilder.addMethod(getMethodBuilder.build());
        if (createMethod.isPresent()) {
            factoryBuilder.addMethod((MethodSpec)createMethod.get());
        }
        FactoryGenerator.proxyMethodFor(binding).asSet().forEach(factoryBuilder::addMethod);
        return Optional.of((Object)factoryBuilder);
    }

    private static Optional<MethodSpec> proxyMethodFor(ProvisionBinding binding) {
        ExecutableElement executableElement = MoreElements.asExecutable((Element)binding.bindingElement().get());
        if (binding.membersInjectionRequest().isPresent() || !Proxies.shouldGenerateProxy(executableElement)) {
            return Optional.absent();
        }
        return Optional.of((Object)Proxies.createProxy(executableElement));
    }

    @CanIgnoreReturnValue
    private FieldSpec addConstructorParameterAndTypeField(TypeName typeName, String variableName, TypeSpec.Builder factoryBuilder, MethodSpec.Builder constructorBuilder) {
        FieldSpec field = FieldSpec.builder(typeName, variableName, Modifier.PRIVATE, Modifier.FINAL).build();
        factoryBuilder.addField(field);
        ParameterSpec parameter = ParameterSpec.builder(typeName, variableName, new Modifier[0]).build();
        constructorBuilder.addParameter(parameter);
        constructorBuilder.addCode("assert $1N != null; this.$2N = $1N;", parameter, field);
        return field;
    }
}

