/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.TypeNames;
import java.util.Iterator;
import java.util.Spliterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

final class CodeBlocks {
    static CodeBlock makeParametersCodeBlock(Iterable<CodeBlock> codeBlocks) {
        return CodeBlocks.join(codeBlocks, ", ");
    }

    static CodeBlock concat(Iterable<CodeBlock> codeBlocks) {
        return CodeBlocks.join(codeBlocks, "\n");
    }

    static CodeBlock.Builder join(CodeBlock.Builder builder, Iterable<CodeBlock> codeBlocks, String delimiter) {
        Iterator<CodeBlock> iterator = codeBlocks.iterator();
        while (iterator.hasNext()) {
            builder.add(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.add(delimiter, new Object[0]);
        }
        return builder;
    }

    static CodeBlock join(Iterable<CodeBlock> codeBlocks, String delimiter) {
        return CodeBlocks.join(CodeBlock.builder(), codeBlocks, delimiter).build();
    }

    static FluentIterable<CodeBlock> toCodeBlocks(Iterable<? extends TypeMirror> typeMirrors) {
        return FluentIterable.from(typeMirrors).transform(typeMirror -> CodeBlock.of("$T", typeMirror));
    }

    static CodeBlock stringLiteral(String toWrap) {
        return CodeBlock.of("$S", toWrap);
    }

    static CodeBlock javadocLinkTo(ExecutableElement executableElement) {
        CodeBlock.Builder builder = CodeBlock.builder().add("{@link $T#", executableElement.getEnclosingElement());
        switch (executableElement.getKind()) {
            case METHOD: {
                builder.add("$L", executableElement.getSimpleName());
                break;
            }
            case CONSTRUCTOR: {
                builder.add("$L", executableElement.getEnclosingElement().getSimpleName());
                break;
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                throw new IllegalArgumentException("cannot create a javadoc link to an initializer: " + executableElement);
            }
            default: {
                throw new AssertionError((Object)executableElement.toString());
            }
        }
        builder.add("(", new Object[0]);
        Spliterator<TypeName> rawTypesSpliterator = executableElement.getParameters().stream().map(Element::asType).map(TypeName::get).map(TypeNames::rawTypeName).spliterator();
        rawTypesSpliterator.tryAdvance(first -> builder.add("$T", first));
        rawTypesSpliterator.forEachRemaining(remaining -> builder.add(", $T", remaining));
        return builder.add(")}", new Object[0]).build();
    }

    private CodeBlocks() {
    }
}

