/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;

final class CanReleaseReferencesValidator {
    CanReleaseReferencesValidator() {
    }

    ValidationReport<TypeElement> validate(TypeElement annotatedElement) {
        ValidationReport.Builder<TypeElement> report = ValidationReport.about(annotatedElement);
        this.checkNoSourceRetention(annotatedElement, report);
        return report.build();
    }

    private void checkNoSourceRetention(TypeElement annotatedElement, ValidationReport.Builder<TypeElement> report) {
        Optional<AnnotationMirror> retention = MoreElements.getAnnotationMirror(annotatedElement, Retention.class);
        if (retention.isPresent() && this.getRetentionPolicy((AnnotationMirror)retention.get()).equals((Object)RetentionPolicy.SOURCE)) {
            report.addError("@CanReleaseReferences annotations must not have SOURCE retention", report.getSubject(), (AnnotationMirror)retention.get());
        }
    }

    private RetentionPolicy getRetentionPolicy(AnnotationMirror retention) {
        return AnnotationMirrors.getAnnotationValue(retention, "value").accept(new SimpleAnnotationValueVisitor7<RetentionPolicy, Void>(){

            @Override
            public RetentionPolicy visitEnumConstant(VariableElement element, Void p) {
                return RetentionPolicy.valueOf(element.getSimpleName().toString());
            }
        }, null);
    }
}

