/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.OptionalBinding;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.AutoValue_OptionalFactories_PresentFactorySpec;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.GeneratedImplementation;
import dagger.internal.codegen.writing.PerGeneratedFile;
import dagger.internal.codegen.writing.TopLevel;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

final class OptionalFactories {
    private final PerGeneratedFileCache perGeneratedFileCache;
    private final GeneratedImplementation topLevelImplementation;

    @Inject
    OptionalFactories(PerGeneratedFileCache perGeneratedFileCache, @TopLevel GeneratedImplementation topLevelImplementation) {
        this.perGeneratedFileCache = perGeneratedFileCache;
        this.topLevelImplementation = topLevelImplementation;
    }

    XCodeBlock absentOptionalProvider(OptionalBinding binding) {
        Verify.verify((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Absent optional bindings should be provisions: %s", (Object)binding);
        OptionalType.OptionalKind optionalKind = OptionalType.from(binding.key()).kind();
        return XCodeBlock.of("%N()", this.perGeneratedFileCache.absentOptionalProviderMethods.computeIfAbsent(optionalKind, kind -> {
            XFunSpec method = this.absentOptionalProviderMethod((OptionalType.OptionalKind)((Object)kind));
            this.topLevelImplementation.addMethod(ComponentImplementation.MethodSpecKind.ABSENT_OPTIONAL_METHOD, method);
            return method;
        }));
    }

    private XFunSpec absentOptionalProviderMethod(OptionalType.OptionalKind optionalKind) {
        XTypeName typeVariable = XTypeNames.getTypeVariableName("T");
        return XFunSpecs.methodBuilder(String.format("absent%sProvider", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, optionalKind.name()))).addModifiers(Modifier.PRIVATE, Modifier.STATIC).addTypeVariable(typeVariable).returns(XTypeNames.daggerProviderOf(optionalKind.of(typeVariable))).addJavadoc("Returns a {@link %T} that returns {@code %L}.", XTypeNames.DAGGER_PROVIDER, optionalKind.absentValueExpression()).addCode("%L // safe covariant cast\n", XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.UNCHECKED, new XAnnotationSpecs.Suppression[0])).addStatement("%1T provider = (%1T) %2N", XTypeNames.daggerProviderOf(optionalKind.of(typeVariable)), this.perGeneratedFileCache.absentOptionalProviderFields.computeIfAbsent(optionalKind, kind -> {
            XPropertySpec field = this.absentOptionalProviderField((OptionalType.OptionalKind)((Object)kind));
            this.topLevelImplementation.addField(ComponentImplementation.FieldSpecKind.ABSENT_OPTIONAL_FIELD, field);
            return field;
        })).addStatement("return provider", new Object[0]).build();
    }

    private XPropertySpec absentOptionalProviderField(OptionalType.OptionalKind optionalKind) {
        return XPropertySpecs.builder(String.format("ABSENT_%s_PROVIDER", optionalKind.name()), XTypeNames.DAGGER_PROVIDER, Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.RAWTYPES, new XAnnotationSpecs.Suppression[0])).initializer("%T.create(%L)", XTypeNames.INSTANCE_FACTORY, optionalKind.absentValueExpression()).addJavadoc("A {@link %T} that returns {@code %L}.", XTypeNames.DAGGER_PROVIDER, optionalKind.absentValueExpression()).build();
    }

    XCodeBlock presentOptionalFactory(OptionalBinding binding, XCodeBlock delegateFactory) {
        return XCodeBlock.of("%N.of(%L)", this.perGeneratedFileCache.presentFactoryClasses.computeIfAbsent(PresentFactorySpec.of(binding), spec -> {
            XTypeSpec type = this.presentOptionalFactoryClass((PresentFactorySpec)spec);
            this.topLevelImplementation.addType(ComponentImplementation.TypeSpecKind.PRESENT_FACTORY, type);
            return type;
        }).getName(), delegateFactory);
    }

    private XTypeSpec presentOptionalFactoryClass(PresentFactorySpec spec) {
        XPropertySpec delegateField = XPropertySpecs.of("delegate", spec.delegateType(), Modifier.PRIVATE, Modifier.FINAL);
        XParameterSpec delegateParameter = XParameterSpecs.of("delegate", delegateField.getType());
        XTypeSpecs.Builder factoryClassBuilder = XTypeSpecs.classBuilder(spec.factoryClassName()).addTypeVariable(spec.typeVariable()).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addJavadoc("A {@code %T} that uses a delegate {@code %T}.", spec.factoryType(), delegateField.getType());
        spec.superclass().ifPresent(factoryClassBuilder::superclass);
        spec.superinterface().ifPresent(factoryClassBuilder::addSuperinterface);
        return factoryClassBuilder.addProperty(delegateField).addFunction(XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(delegateParameter).addCode("this.%N = %T.checkNotNull(%N);", delegateField, XTypeNames.DAGGER_PRECONDITIONS, delegateParameter.getName()).build()).addFunction(this.presentOptionalFactoryGetMethod(spec, delegateField)).addFunction(XFunSpecs.methodBuilder("of").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addTypeVariable(spec.typeVariable()).returns(spec.factoryType()).addParameter(delegateParameter).addStatement("return %L", XCodeBlock.ofNewInstance(this.topLevelImplementation.name().nestedClass(spec.factoryClassName()).parametrizedBy(spec.typeVariable()), "%N", delegateParameter.getName())).build()).build();
    }

    private XFunSpec presentOptionalFactoryGetMethod(PresentFactorySpec spec, XPropertySpec delegateField) {
        XFunSpec.Builder getMethodBuilder = XFunSpec.builder(spec.factoryMethodName(), VisibilityModifier.PUBLIC, false, true, false);
        switch (spec.frameworkType()) {
            case PROVIDER: {
                return getMethodBuilder.returns(spec.optionalType()).addCode("return %L;", spec.optionalKind().presentExpression(FrameworkType.PROVIDER.to(spec.valueKind(), XCodeBlock.of("%N", delegateField)))).build();
            }
            case PRODUCER_NODE: {
                getMethodBuilder.returns(XTypeNames.listenableFutureOf(spec.optionalType()));
                switch (spec.valueKind()) {
                    case FUTURE: 
                    case PRODUCER: {
                        return getMethodBuilder.addCode("return %T.immediateFuture(%L);", XTypeNames.FUTURES, spec.optionalKind().presentExpression(FrameworkType.PRODUCER_NODE.to(spec.valueKind(), XCodeBlock.of("%N", delegateField)))).build();
                    }
                    case INSTANCE: {
                        return getMethodBuilder.addCode("return %L;", OptionalFactories.transformFutureToOptional(spec.optionalKind(), spec.typeVariable(), XCodeBlock.of("%N.get()", delegateField))).build();
                    }
                    case PRODUCED: {
                        return getMethodBuilder.addCode("return %L;", OptionalFactories.transformFutureToOptional(spec.optionalKind(), spec.valueType(), XCodeBlock.of("%T.createFutureProduced(%N.get())", XTypeNames.PRODUCERS, delegateField))).build();
                    }
                }
                throw new UnsupportedOperationException(spec.factoryType() + " objects are not supported");
            }
        }
        throw new AssertionError((Object)spec.frameworkType());
    }

    private static XCodeBlock transformFutureToOptional(OptionalType.OptionalKind optionalKind, XTypeName inputType, XCodeBlock inputFuture) {
        XTypeName superInterface = XTypeNames.GUAVA_FUNCTION.parametrizedBy(inputType, optionalKind.of(inputType));
        return XCodeBlock.of("%T.transform(%L, %L, %T.directExecutor())", XTypeNames.FUTURES, inputFuture, XTypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(superInterface).addFunction(XFunSpec.builder("apply", VisibilityModifier.PUBLIC, false, true, false).returns(optionalKind.of(inputType)).addParameter("input", inputType).addStatement("return %L", optionalKind.presentExpression(XCodeBlock.of("input", new Object[0]))).build()).build(), XTypeNames.MORE_EXECUTORS);
    }

    @PerGeneratedFile
    static final class PerGeneratedFileCache {
        private final Map<PresentFactorySpec, XTypeSpec> presentFactoryClasses = new TreeMap<PresentFactorySpec, XTypeSpec>(Comparator.comparing(PresentFactorySpec::valueKind).thenComparing(PresentFactorySpec::frameworkType).thenComparing(PresentFactorySpec::optionalKind));
        private final Map<OptionalType.OptionalKind, XFunSpec> absentOptionalProviderMethods = new TreeMap<OptionalType.OptionalKind, XFunSpec>();
        private final Map<OptionalType.OptionalKind, XPropertySpec> absentOptionalProviderFields = new TreeMap<OptionalType.OptionalKind, XPropertySpec>();

        @Inject
        PerGeneratedFileCache() {
        }
    }

    @AutoValue
    static abstract class PresentFactorySpec {
        PresentFactorySpec() {
        }

        abstract FrameworkType frameworkType();

        abstract OptionalType.OptionalKind optionalKind();

        abstract RequestKind valueKind();

        XTypeName typeVariable() {
            return XTypeNames.getTypeVariableName("T");
        }

        XTypeName valueType() {
            return RequestKinds.requestTypeName(this.valueKind(), this.typeVariable());
        }

        XTypeName optionalType() {
            return this.optionalKind().of(this.valueType());
        }

        XTypeName factoryType() {
            return this.frameworkType().frameworkClassOf(this.optionalType());
        }

        XTypeName delegateType() {
            return this.frameworkType().frameworkClassOf(this.typeVariable());
        }

        Optional<XTypeName> superclass() {
            switch (this.frameworkType()) {
                case PRODUCER_NODE: {
                    return Optional.of(XTypeNames.abstractProducerOf(this.optionalType()));
                }
            }
            return Optional.empty();
        }

        Optional<XTypeName> superinterface() {
            switch (this.frameworkType()) {
                case PROVIDER: {
                    return Optional.of(this.factoryType());
                }
            }
            return Optional.empty();
        }

        String factoryMethodName() {
            switch (this.frameworkType()) {
                case PROVIDER: {
                    return "get";
                }
                case PRODUCER_NODE: {
                    return "compute";
                }
            }
            throw new AssertionError((Object)this.frameworkType());
        }

        String factoryClassName() {
            return "Present" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.optionalKind().name()) + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.valueKind().toString()) + this.frameworkType().frameworkClassName().getSimpleName();
        }

        private static PresentFactorySpec of(OptionalBinding binding) {
            return new AutoValue_OptionalFactories_PresentFactorySpec(FrameworkType.forBindingType(binding.bindingType()), OptionalType.from(binding.key()).kind(), ((DependencyRequest)Iterables.getOnlyElement(binding.dependencies())).kind());
        }
    }
}

