/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class BindingElementValidator<E extends XElement> {
    private static final ImmutableSet<XClassName> MULTIBINDING_ANNOTATIONS = ImmutableSet.of((Object)XTypeNames.INTO_SET, (Object)XTypeNames.ELEMENTS_INTO_SET, (Object)XTypeNames.INTO_MAP);
    private final AllowsMultibindings allowsMultibindings;
    private final AllowsScoping allowsScoping;
    private final Map<E, ValidationReport> cache = new HashMap<E, ValidationReport>();
    private final InjectionAnnotations injectionAnnotations;

    protected BindingElementValidator(AllowsMultibindings allowsMultibindings, AllowsScoping allowsScoping, InjectionAnnotations injectionAnnotations) {
        this.allowsMultibindings = allowsMultibindings;
        this.allowsScoping = allowsScoping;
        this.injectionAnnotations = injectionAnnotations;
    }

    public final ValidationReport validate(E element) {
        return Util.reentrantComputeIfAbsent(this.cache, element, this::validateUncached);
    }

    private ValidationReport validateUncached(E element) {
        return this.elementValidator(element).validate();
    }

    @FormatMethod
    protected final String bindingElements(String ruleFormat, Object ... args) {
        return new Formatter().format("%s ", this.bindingElements()).format(ruleFormat, args).toString();
    }

    protected abstract String bindingElements();

    protected abstract String bindingElementTypeVerb();

    protected String badTypeMessage() {
        return this.bindingElements("must %s a primitive, an array, a type variable, or a declared type", this.bindingElementTypeVerb());
    }

    protected String elementsIntoSetNotASetMessage() {
        return this.bindingElements("annotated with @ElementsIntoSet must %s a Set", this.bindingElementTypeVerb());
    }

    protected String elementsIntoSetRawSetMessage() {
        return this.bindingElements("annotated with @ElementsIntoSet cannot %s a raw Set", this.bindingElementTypeVerb());
    }

    protected abstract ElementValidator elementValidator(E var1);

    static enum AllowsScoping {
        NO_SCOPING,
        ALLOWS_SCOPING;

    }

    static enum AllowsMultibindings {
        NO_MULTIBINDINGS,
        ALLOWS_MULTIBINDINGS;


        private boolean allowsMultibindings() {
            return this == ALLOWS_MULTIBINDINGS;
        }
    }

    protected static abstract class ElementValidator {
        private final E element;
        protected final ValidationReport.Builder report;
        private final ImmutableSet<XAnnotation> qualifiers;
        final /* synthetic */ BindingElementValidator this$0;

        protected ElementValidator(E element) {
            this.this$0 = this$0;
            this.element = element;
            this.report = ValidationReport.about(element);
            this.qualifiers = ((BindingElementValidator)this$0).injectionAnnotations.getQualifiers((XElement)element);
        }

        private ValidationReport validate() {
            this.checkType();
            this.checkQualifiers();
            this.checkMapKeys();
            this.checkMultibindingAnnotations();
            this.checkScopes();
            this.checkAdditionalProperties();
            return this.report.build();
        }

        protected void checkAdditionalProperties() {
        }

        protected abstract Optional<XType> bindingElementType();

        protected void checkType() {
            switch (ContributionType.fromBindingElement(this.element)) {
                case UNIQUE: {
                    this.bindingElementType().ifPresent(this::checkKeyType);
                    this.checkFrameworkType();
                    this.checkAssistedType();
                    this.bindingElementType().ifPresent(this::checkDisallowedType);
                    break;
                }
                case SET: {
                    this.bindingElementType().ifPresent(this::checkSetValueFrameworkType);
                    break;
                }
                case MAP: {
                    this.bindingElementType().ifPresent(this::checkMapValueFrameworkType);
                    break;
                }
                case SET_VALUES: {
                    this.checkSetValuesType();
                }
            }
        }

        protected void checkKeyType(XType keyType) {
            if (XTypeKt.isVoid(keyType)) {
                this.report.addError(this.this$0.bindingElements("must %s a value (not void)", this.this$0.bindingElementTypeVerb()));
            } else if (!(XTypes.isPrimitive(keyType) || XTypes.isDeclared(keyType) || XTypeKt.isArray(keyType) || XTypes.isTypeVariable(keyType))) {
                this.report.addError(this.this$0.badTypeMessage());
            }
        }

        private void checkAssistedType() {
            if (this.qualifiers.isEmpty() && this.bindingElementType().isPresent() && XTypes.isDeclared(this.bindingElementType().get())) {
                XTypeElement keyElement = this.bindingElementType().get().getTypeElement();
                if (AssistedInjectionAnnotations.isAssistedInjectionType(keyElement)) {
                    this.report.addError("Dagger does not support providing @AssistedInject types.", keyElement);
                }
                if (AssistedInjectionAnnotations.isAssistedFactoryType(keyElement)) {
                    this.report.addError("Dagger does not support providing @AssistedFactory types.", keyElement);
                }
            }
        }

        protected void checkSetValuesType() {
            this.bindingElementType().ifPresent(this::checkSetValuesType);
        }

        protected final void checkSetValuesType(XType type) {
            if (!SetType.isSet(type)) {
                this.report.addError(this.this$0.elementsIntoSetNotASetMessage());
            } else {
                SetType setType = SetType.from(type);
                if (setType.isRawType()) {
                    this.report.addError(this.this$0.elementsIntoSetRawSetMessage());
                } else {
                    this.checkSetValueFrameworkType(setType.elementType());
                }
            }
        }

        private void checkQualifiers() {
            if (this.qualifiers.size() > 1) {
                for (XAnnotation qualifier : this.qualifiers) {
                    this.report.addError(this.this$0.bindingElements("may not use more than one @Qualifier", new Object[0]), (XElement)this.element, qualifier);
                }
            }
        }

        private void checkMapKeys() {
            if (!this.this$0.allowsMultibindings.allowsMultibindings()) {
                return;
            }
            ImmutableSet<XAnnotation> mapKeys = MapKeys.getMapKeys(this.element);
            if (ContributionType.fromBindingElement(this.element).equals((Object)ContributionType.MAP)) {
                switch (mapKeys.size()) {
                    case 0: {
                        this.report.addError(this.this$0.bindingElements("of type map must declare a map key", new Object[0]));
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.report.addError(this.this$0.bindingElements("may not have more than one map key", new Object[0]));
                        break;
                    }
                }
            } else if (!mapKeys.isEmpty()) {
                this.report.addError(this.this$0.bindingElements("of non map type cannot declare a map key", new Object[0]));
            }
        }

        private void checkMultibindingAnnotations() {
            ImmutableSet<XAnnotation> multibindingAnnotations = XElements.getAllAnnotations(this.element, (Collection<XClassName>)MULTIBINDING_ANNOTATIONS);
            switch (this.this$0.allowsMultibindings.ordinal()) {
                case 0: {
                    for (XAnnotation annotation : multibindingAnnotations) {
                        this.report.addError(this.this$0.bindingElements("cannot have multibinding annotations", new Object[0]), (XElement)this.element, annotation);
                    }
                    break;
                }
                case 1: {
                    if (multibindingAnnotations.size() <= 1) break;
                    for (XAnnotation annotation : multibindingAnnotations) {
                        this.report.addError(this.this$0.bindingElements("cannot have more than one multibinding annotation", new Object[0]), (XElement)this.element, annotation);
                    }
                    break;
                }
            }
        }

        private void checkScopes() {
            ImmutableSet<Scope> scopes = this.this$0.injectionAnnotations.getScopes((XElement)this.element);
            String error = null;
            switch (this.this$0.allowsScoping.ordinal()) {
                case 1: {
                    if (scopes.size() <= 1) {
                        return;
                    }
                    error = this.this$0.bindingElements("cannot use more than one @Scope", new Object[0]);
                    break;
                }
                case 0: {
                    error = this.this$0.bindingElements("cannot be scoped", new Object[0]);
                }
            }
            Verify.verifyNotNull(error);
            for (Scope scope : scopes) {
                this.report.addError(error, (XElement)this.element, scope.scopeAnnotation().xprocessing());
            }
        }

        private void checkFrameworkType() {
            if (this.bindingElementType().filter(FrameworkTypes::isFrameworkType).isPresent()) {
                this.report.addError(this.this$0.bindingElements("must not %s framework types: %s", this.this$0.bindingElementTypeVerb(), XTypes.toStableString(this.bindingElementType().get())));
            }
        }

        private void checkSetValueFrameworkType(XType bindingType) {
            this.checkKeyType(bindingType);
            if (FrameworkTypes.isSetValueFrameworkType(bindingType)) {
                this.report.addError(this.this$0.bindingElements("with @IntoSet/@ElementsIntoSet must not %s framework types: %s", this.this$0.bindingElementTypeVerb(), XTypes.toStableString(bindingType)));
            }
            this.checkDisallowedType(bindingType);
        }

        private void checkMapValueFrameworkType(XType bindingType) {
            this.checkKeyType(bindingType);
            if (FrameworkTypes.isMapValueFrameworkType(bindingType)) {
                this.report.addError(this.this$0.bindingElements("with @IntoMap must not %s framework types: %s", this.this$0.bindingElementTypeVerb(), XTypes.toStableString(bindingType)));
            }
            this.checkDisallowedType(bindingType);
        }

        private void checkDisallowedType(XType bindingType) {
            if (FrameworkTypes.isDisallowedType(bindingType)) {
                this.report.addError(this.this$0.bindingElements("must not %s disallowed types: %s", this.this$0.bindingElementTypeVerb(), XTypes.toStableString(this.bindingElementType().get())));
            }
        }
    }
}

