/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.collect.Streams;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import com.squareup.kotlinpoet.CodeBlock;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.stream.Collector;
import javax.lang.model.element.Modifier;

public final class XCodeBlocks {
    public static XCodeBlock toXPoet(com.squareup.javapoet.CodeBlock codeBlock) {
        return XConverters.toXPoet(codeBlock, CodeBlock.of((String)"", (Object[])new Object[0]));
    }

    public static Collector<XCodeBlock, ?, XCodeBlock> toParametersCodeBlock() {
        return XCodeBlocks.joining(", ");
    }

    public static Collector<XCodeBlock, ?, XCodeBlock> toConcatenatedCodeBlock() {
        return XCodeBlocks.joining("\n", "", "\n");
    }

    public static XCodeBlock makeParametersCodeBlock(Iterable<XCodeBlock> codeBlocks) {
        return Streams.stream(codeBlocks).collect(XCodeBlocks.toParametersCodeBlock());
    }

    public static XCodeBlock parameterNames(Iterable<XParameterSpec> parameters) {
        return Streams.stream(parameters).map(p -> XCodeBlock.of("%N", p.getName())).collect(XCodeBlocks.toParametersCodeBlock());
    }

    public static XCodeBlock concat(Iterable<XCodeBlock> codeBlocks) {
        return Streams.stream(codeBlocks).collect(XCodeBlocks.toConcatenatedCodeBlock());
    }

    public static XCodeBlock anonymousProvider(XExpression expression) {
        return XCodeBlocks.anonymousProvider(expression.type().asTypeName(), XCodeBlock.of("return %L;", expression.codeBlock()));
    }

    public static XCodeBlock anonymousProvider(XTypeName providedType, XCodeBlock body) {
        return XCodeBlocks.toXPoet(com.squareup.javapoet.CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass(XConverters.toJavaPoet(XTypeNames.daggerProviderOf(providedType))).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(XConverters.toJavaPoet(providedType)).addCode(XConverters.toJavaPoet(body)).build()).build()}));
    }

    public static XCodeBlock cast(XCodeBlock expression, XClassName castTo) {
        return XCodeBlock.ofCast(castTo, expression);
    }

    public static XCodeBlock type(XType type) {
        return XCodeBlock.of("%T", type.asTypeName());
    }

    public static XCodeBlock staticReferenceOf(XTypeElement typeElement) {
        if (typeElement.isKotlinObject() && !typeElement.isCompanionObject()) {
            XCodeBlock.Builder builder = XCodeBlock.builder();
            XConverters.toJavaPoet(builder).add("$T.INSTANCE", new Object[]{XConverters.toJavaPoet(typeElement.asClassName())});
            XConverters.toKotlinPoet(builder).add("%T", new Object[]{XConverters.toKotlinPoet(typeElement.asClassName())});
            return builder.build();
        }
        return XCodeBlock.of("%T", typeElement.asClassName());
    }

    public static XCodeBlock stringLiteral(String toWrap) {
        return XCodeBlock.of("%S", toWrap);
    }

    public static XCodeBlock join(Iterable<XCodeBlock> codeBlocks, String separator) {
        return Streams.stream(codeBlocks).collect(XCodeBlocks.joining(separator));
    }

    public static Collector<XCodeBlock, ?, XCodeBlock> joining(String separator) {
        return Collector.of(() -> new XCodeBlockJoiner(separator, XCodeBlock.builder()), XCodeBlockJoiner::add, XCodeBlockJoiner::merge, XCodeBlockJoiner::join, new Collector.Characteristics[0]);
    }

    public static Collector<XCodeBlock, ?, XCodeBlock> joining(String separator, String prefix, String suffix) {
        XCodeBlock.Builder builder = XCodeBlock.builder();
        if (prefix != null && !prefix.isEmpty()) {
            builder.add("%L", prefix);
        }
        return Collector.of(() -> new XCodeBlockJoiner(separator, builder), XCodeBlockJoiner::add, XCodeBlockJoiner::merge, joiner -> {
            if (suffix != null && !suffix.isEmpty()) {
                builder.add("%L", suffix);
            }
            return joiner.join();
        }, new Collector.Characteristics[0]);
    }

    public static boolean isEmpty(XCodeBlock codeBlock) {
        return XConverters.toJavaPoet(codeBlock).isEmpty();
    }

    public static XCodeBlock ofJavaClassLiteral(XTypeName typeName) {
        XCodeBlock.Builder builder = XCodeBlock.builder();
        XConverters.toJavaPoet(builder).add("$T.class", new Object[]{XConverters.toJavaPoet(typeName)});
        XConverters.toKotlinPoet(builder).add("%T::class.java", new Object[]{XConverters.toKotlinPoet(typeName)});
        return builder.build();
    }

    public static XCodeBlock ofLocalVal(String name, XTypeName typeName, String format, Object ... args) {
        return XCodeBlocks.ofLocalVal(name, typeName, XCodeBlock.of(format, args));
    }

    public static XCodeBlock ofLocalVal(String name, XTypeName typeName, XCodeBlock initialization) {
        return XCodeBlock.builder().addLocalVariable(name, typeName, false, initialization).build();
    }

    public static XCodeBlock ofLocalVar(String name, XTypeName typeName, String format, Object ... args) {
        return XCodeBlocks.ofLocalVar(name, typeName, XCodeBlock.of(format, args));
    }

    public static XCodeBlock ofLocalVar(String name, XTypeName typeName, XCodeBlock initialization) {
        return XCodeBlock.builder().addLocalVariable(name, typeName, true, initialization).build();
    }

    private XCodeBlocks() {
    }

    private static final class XCodeBlockJoiner {
        private final String delimiter;
        private final XCodeBlock.Builder builder;
        private boolean first = true;

        XCodeBlockJoiner(String delimiter, XCodeBlock.Builder builder) {
            this.delimiter = delimiter;
            this.builder = builder;
        }

        @CanIgnoreReturnValue
        XCodeBlockJoiner add(XCodeBlock codeBlock) {
            if (!this.first) {
                if (!XConverters.toKotlinPoet(codeBlock).isEmpty()) {
                    XConverters.toKotlinPoet(this.builder).add(this.delimiter, new Object[0]);
                }
                if (!XConverters.toJavaPoet(codeBlock).isEmpty()) {
                    XConverters.toJavaPoet(this.builder).add(this.delimiter, new Object[0]);
                }
            }
            this.first = false;
            if (!XConverters.toKotlinPoet(codeBlock).isEmpty()) {
                XConverters.toKotlinPoet(this.builder).add(XConverters.toKotlinPoet(codeBlock));
            }
            if (!XConverters.toJavaPoet(codeBlock).isEmpty()) {
                XConverters.toJavaPoet(this.builder).add(XConverters.toJavaPoet(codeBlock));
            }
            return this;
        }

        @CanIgnoreReturnValue
        XCodeBlockJoiner merge(XCodeBlockJoiner other) {
            this.add(other.builder.build());
            return this;
        }

        XCodeBlock join() {
            return this.builder.build();
        }
    }
}

