/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@PerComponentImplementation
final class MembersInjectionMethods {
    private final Map<Key, XExpression> injectMethodExpressions = new LinkedHashMap<Key, XExpression>();
    private final ComponentImplementation componentImplementation;
    private final ComponentRequestRepresentations bindingExpressions;
    private final BindingGraph graph;
    private final CompilerOptions compilerOptions;
    private final XProcessingEnv processingEnv;

    @Inject
    MembersInjectionMethods(ComponentImplementation componentImplementation, ComponentRequestRepresentations bindingExpressions, BindingGraph graph, CompilerOptions compilerOptions, XProcessingEnv processingEnv) {
        this.componentImplementation = componentImplementation;
        this.bindingExpressions = bindingExpressions;
        this.graph = graph;
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
    }

    XExpression getInjectExpression(Key key, XCodeBlock instance, XClassName requestingClass) {
        Binding binding = this.graph.localMembersInjectionBinding(key).isPresent() ? this.graph.localMembersInjectionBinding(key).get() : this.graph.localContributionBinding(key).get();
        XExpression expression = Util.reentrantComputeIfAbsent(this.injectMethodExpressions, key, k -> this.injectMethodExpression(binding));
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(binding);
        return XExpression.create(expression.type(), shardImplementation.name().equals(requestingClass) ? XCodeBlock.of("%L(%L)", expression.codeBlock(), instance) : XCodeBlock.of("%L.%L(%L)", shardImplementation.shardFieldReference(), expression.codeBlock(), instance));
    }

    private XExpression injectMethodExpression(Binding binding) {
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(binding);
        XType keyType = binding.key().type().xprocessing();
        XType membersInjectedType = Accessibility.isTypeAccessibleFrom(keyType, shardImplementation.name().getPackageName()) ? keyType : this.processingEnv.requireType(XTypeName.ANY_OBJECT);
        String bindingTypeName = XElements.getSimpleName(binding.bindingTypeElement().get());
        String methodName = shardImplementation.getUniqueMethodName("inject" + bindingTypeName);
        String instanceName = shardImplementation.getUniqueFieldName("instance");
        XTypeName instanceTypeName = membersInjectedType.asTypeName();
        XFunSpecs.Builder methodBuilder = XFunSpecs.methodBuilder(methodName).addModifiers(Modifier.PRIVATE).returns(instanceTypeName).addParameter(instanceName, instanceTypeName);
        XTypeElement canIgnoreReturnValue = this.processingEnv.findTypeElement("com.google.errorprone.annotations.CanIgnoreReturnValue");
        if (canIgnoreReturnValue != null) {
            methodBuilder.addAnnotation(canIgnoreReturnValue.asClassName());
        }
        XCodeBlock instance = XCodeBlock.of("%N", instanceName);
        XCodeBlock invokeInjectionSites = InjectionMethods.InjectionSiteMethod.invokeAll(binding, shardImplementation.name(), instance, membersInjectedType, request -> this.bindingExpressions.getDependencyArgumentExpression((DependencyRequest)request, shardImplementation.name()).codeBlock(), this.compilerOptions);
        methodBuilder.addCode(invokeInjectionSites).addStatement("return %L", instance);
        XFunSpec method = methodBuilder.build();
        shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.MEMBERS_INJECTION_METHOD, method);
        return XExpression.create(membersInjectedType, XCodeBlock.of("%N", method));
    }
}

