/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

final class InjectionMethods {
    private InjectionMethods() {
    }

    private static ImmutableList<XTypeName> methodTypeArguments(Binding binding, CompilerOptions compilerOptions) {
        return InjectionMethods.methodTypeArguments(binding, Optional.empty(), compilerOptions);
    }

    private static ImmutableList<XTypeName> methodTypeArguments(Binding binding, MembersInjectionBinding.InjectionSite injectionSite, CompilerOptions compilerOptions) {
        return InjectionMethods.methodTypeArguments(binding, Optional.of(injectionSite), compilerOptions);
    }

    private static ImmutableList<XTypeName> methodTypeArguments(Binding binding, Optional<MembersInjectionBinding.InjectionSite> injectionSite, CompilerOptions compilerOptions) {
        if (!InjectionMethods.requiresMethodTypeArguments(binding, compilerOptions)) {
            return ImmutableList.of();
        }
        XTypeElement enclosingTypeElement = injectionSite.map(MembersInjectionBinding.InjectionSite::enclosingTypeElement).orElse(binding.bindingTypeElement().get());
        if (enclosingTypeElement.getTypeParameters().isEmpty()) {
            return ImmutableList.of();
        }
        XType unresolvedType = enclosingTypeElement.getType();
        XType resolvedType = XTypes.asMemberOf(enclosingTypeElement, binding.contributingModule().isPresent() ? binding.contributingModule().get().getType() : binding.key().type().xprocessing());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < resolvedType.getTypeArguments().size(); ++i) {
            XType typeArgument = resolvedType.getTypeArguments().get(i);
            if (Accessibility.isTypePubliclyAccessible(typeArgument)) {
                builder.add((Object)typeArgument.asTypeName());
                continue;
            }
            XType unresolvedTypeArgument = unresolvedType.getTypeArguments().get(i);
            builder.add((Object)XTypeNames.replaceTypeVariablesWithBounds(unresolvedTypeArgument.asTypeName()));
        }
        return builder.build();
    }

    private static boolean requiresMethodTypeArguments(Binding binding, CompilerOptions compilerOptions) {
        return false;
    }

    private static XCodeBlock invokeMethod(String methodName, ImmutableList<XTypeName> typeArguments, ImmutableList<XCodeBlock> parameters, XClassName enclosingClass, XClassName requestingClass) {
        XCodeBlock.Builder builder = XCodeBlock.builder();
        if (!enclosingClass.equals(requestingClass)) {
            builder.add("%T.", enclosingClass);
        } else if (!typeArguments.isEmpty()) {
            XConverters.toJavaPoet(builder).add("$T.", new Object[]{XConverters.toJavaPoet(enclosingClass)});
        }
        if (typeArguments.isEmpty()) {
            builder.add("%N", methodName);
        } else {
            XCodeBlock typeParametersCodeBlock = typeArguments.stream().map(typeParameter -> XCodeBlock.of("%T", typeParameter)).collect(XCodeBlocks.toParametersCodeBlock());
            XConverters.toJavaPoet(builder).add("<$L>$N", new Object[]{XConverters.toJavaPoet(typeParametersCodeBlock), methodName});
            XConverters.toKotlinPoet(builder).add("%N<%L>", new Object[]{methodName, XConverters.toKotlinPoet(typeParametersCodeBlock)});
        }
        builder.add("(%L)", XCodeBlocks.makeParametersCodeBlock(parameters));
        return builder.build();
    }

    static XCodeBlock copyParameters(XFunSpecs.Builder methodBuilder, UniqueNameSet parameterNameSet, List<? extends XVariableElement> parameters, CompilerOptions compilerOptions) {
        return parameters.stream().map(parameter -> {
            String name = parameterNameSet.getUniqueName(XElementKt.isMethodParameter(parameter) ? XElements.asMethodParameter(parameter).getJvmName() : XElements.getSimpleName(parameter));
            boolean isTypeNameAccessible = Accessibility.isRawTypePubliclyAccessible(parameter.getType());
            return InjectionMethods.copyParameter(methodBuilder, name, parameter.getType().asTypeName(), Nullability.of(parameter), isTypeNameAccessible, compilerOptions);
        }).collect(XCodeBlocks.toParametersCodeBlock());
    }

    static XCodeBlock copyParameter(XFunSpecs.Builder methodBuilder, String name, XTypeName typeName, Nullability nullability, boolean isTypeNameAccessible, CompilerOptions compilerOptions) {
        return InjectionMethods.copyParameterInternal(methodBuilder, name, typeName, isTypeNameAccessible, XTypeName.ANY_OBJECT.copy(true), nullability, compilerOptions);
    }

    static XCodeBlock copyFrameworkParameter(XFunSpecs.Builder methodBuilder, String name, XTypeName typeName, Nullability nullability, boolean isTypeNameAccessible, CompilerOptions compilerOptions) {
        return InjectionMethods.copyParameterInternal(methodBuilder, name, typeName, isTypeNameAccessible, XTypeNames.asClassName(typeName.getRawTypeName()).parametrizedBy(XTypeName.ANY_WILDCARD), nullability, compilerOptions);
    }

    private static XCodeBlock copyParameterInternal(XFunSpecs.Builder methodBuilder, String name, XTypeName typeName, boolean isTypeNameAccessible, XTypeName accessibleTypeName, Nullability nullability, CompilerOptions compilerOptions) {
        methodBuilder.addParameter(XParameterSpecs.of(name, isTypeNameAccessible ? typeName : accessibleTypeName, nullability, compilerOptions));
        return isTypeNameAccessible ? XCodeBlock.of("%L", name) : XCodeBlock.ofCast(typeName, XCodeBlock.of("%L", name));
    }

    static final class InjectionSiteMethod {
        InjectionSiteMethod() {
        }

        static XCodeBlock invokeAll(Binding binding, XClassName generatedTypeName, XCodeBlock instanceCodeBlock, XType instanceType, Function<DependencyRequest, XCodeBlock> dependencyUsage, CompilerOptions compilerOptions) {
            return InjectionSiteMethod.injectionSites(binding).stream().map(injectionSite -> {
                XType injectSiteType = injectionSite.enclosingTypeElement().getType();
                XCodeBlock maybeCastedInstance = instanceType.asTypeName().equals(XTypeName.ANY_OBJECT) && Accessibility.isRawTypeAccessible(injectSiteType, generatedTypeName.getPackageName()) ? XCodeBlock.ofCast(XConverters.toXPoet(XTypes.erasedTypeName(injectSiteType)), instanceCodeBlock) : instanceCodeBlock;
                return XCodeBlock.of("%L;", InjectionSiteMethod.invoke(binding, injectionSite, generatedTypeName, maybeCastedInstance, dependencyUsage, compilerOptions));
            }).collect(XCodeBlocks.toConcatenatedCodeBlock());
        }

        private static XCodeBlock invoke(Binding binding, MembersInjectionBinding.InjectionSite injectionSite, XClassName generatedTypeName, XCodeBlock instanceCodeBlock, Function<DependencyRequest, XCodeBlock> dependencyUsage, CompilerOptions compilerOptions) {
            ImmutableList arguments = ImmutableList.builder().add((Object)instanceCodeBlock).addAll((Iterable)injectionSite.dependencies().stream().map(dependencyUsage).collect(DaggerStreams.toImmutableList())).build();
            XTypeElement enclosingTypeElement = injectionSite.enclosingTypeElement();
            XClassName enclosingClass = SourceFiles.membersInjectorNameForType(enclosingTypeElement);
            String methodName = SourceFiles.membersInjectorMethodName(injectionSite);
            return InjectionMethods.invokeMethod(methodName, (ImmutableList<XTypeName>)InjectionMethods.methodTypeArguments(binding, injectionSite, compilerOptions), (ImmutableList<XCodeBlock>)arguments, enclosingClass, generatedTypeName);
        }

        private static ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites(Binding binding) {
            switch (binding.kind()) {
                case INJECTION: {
                    return ((InjectionBinding)binding).injectionSites();
                }
                case ASSISTED_INJECTION: {
                    return ((AssistedInjectionBinding)binding).injectionSites();
                }
                case MEMBERS_INJECTION: {
                    return ((MembersInjectionBinding)binding).injectionSites();
                }
            }
            throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
        }
    }

    static final class ProvisionMethod {
        ProvisionMethod() {
        }

        static XCodeBlock invoke(ContributionBinding binding, Function<DependencyRequest, XCodeBlock> injectedDependencyUsage, Function<XExecutableParameterElement, XCodeBlock> assistedDependencyUsage, XClassName requestingClass, Optional<XCodeBlock> moduleReference, CompilerOptions compilerOptions) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            moduleReference.ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            ProvisionMethod.invokeArguments(binding, injectedDependencyUsage, assistedDependencyUsage).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            XClassName enclosingClass = SourceFiles.generatedClassNameForBinding(binding);
            String methodName = SourceFiles.generatedProxyMethodName(binding);
            return InjectionMethods.invokeMethod(methodName, (ImmutableList<XTypeName>)InjectionMethods.methodTypeArguments(binding, compilerOptions), (ImmutableList<XCodeBlock>)arguments.build(), enclosingClass, requestingClass);
        }

        static ImmutableList<XCodeBlock> invokeArguments(ContributionBinding binding, Function<DependencyRequest, XCodeBlock> injectedDependencyUsage, Function<XExecutableParameterElement, XCodeBlock> assistedDependencyUsage) {
            ImmutableMap dependencyRequestMap = (ImmutableMap)ProvisionMethod.provisionDependencies(binding).stream().collect(DaggerStreams.toImmutableMap(request -> XElements.asMethodParameter(request.requestElement().get().xprocessing()), request -> request));
            ImmutableList.Builder arguments = ImmutableList.builder();
            XExecutableElement method = XElements.asExecutable(binding.bindingElement().get());
            for (XExecutableParameterElement parameter : method.getParameters()) {
                if (AssistedInjectionAnnotations.isAssistedParameter(parameter)) {
                    arguments.add((Object)assistedDependencyUsage.apply(parameter));
                    continue;
                }
                if (dependencyRequestMap.containsKey((Object)parameter)) {
                    DependencyRequest request2 = (DependencyRequest)dependencyRequestMap.get((Object)parameter);
                    arguments.add((Object)injectedDependencyUsage.apply(request2));
                    continue;
                }
                throw new AssertionError((Object)("Unexpected parameter: " + parameter));
            }
            return arguments.build();
        }

        private static ImmutableSet<DependencyRequest> provisionDependencies(ContributionBinding binding) {
            switch (binding.kind()) {
                case INJECTION: {
                    return ((InjectionBinding)binding).constructorDependencies();
                }
                case ASSISTED_INJECTION: {
                    return ((AssistedInjectionBinding)binding).constructorDependencies();
                }
                case PROVISION: {
                    return ((ProvisionBinding)binding).dependencies();
                }
            }
            throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
        }
    }
}

