/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class MethodSignatureFormatter
extends Formatter<XExecutableElement> {
    private static final XClassName JET_BRAINS_NOT_NULL = XClassName.get("org.jetbrains.annotations", "NotNull");
    private static final XClassName JET_BRAINS_NULLABLE = XClassName.get("org.jetbrains.annotations", "Nullable");
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    MethodSignatureFormatter(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    public Formatter<XMethodElement> typedFormatter(final XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type));
        return new Formatter<XMethodElement>(){

            @Override
            public String format(XMethodElement method) {
                return MethodSignatureFormatter.this.format(method, method.asMemberOf(type), XElements.closestEnclosingTypeElement(method), true);
            }
        };
    }

    @Override
    public String format(XExecutableElement method) {
        return this.format(method, Optional.empty());
    }

    public String format(XExecutableElement method, Optional<XType> container) {
        return this.format(method, container, true);
    }

    private String format(XExecutableElement method, Optional<XType> container, boolean includeReturnType) {
        return container.isPresent() ? this.format(method, method.asMemberOf(container.get()), container.get().getTypeElement(), includeReturnType) : this.format(method, method.getExecutableType(), XElements.closestEnclosingTypeElement(method), includeReturnType);
    }

    private String format(XExecutableElement method, XExecutableType methodType, XTypeElement container, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        ImmutableList<String> formattedAnnotations = MethodSignatureFormatter.formatedAnnotations(method);
        if (!formattedAnnotations.isEmpty()) {
            builder.append(String.join((CharSequence)" ", formattedAnnotations)).append(" ");
        }
        if (XElements.getSimpleName(method).contentEquals("<init>")) {
            builder.append(container.getQualifiedName());
        } else {
            if (includeReturnType) {
                builder.append(MethodSignatureFormatter.nameOfType(((XMethodType)methodType).getReturnType())).append(' ');
            }
            builder.append(container.getQualifiedName()).append('.').append(XElements.getSimpleName(method));
        }
        builder.append('(');
        Preconditions.checkState((method.getParameters().size() == methodType.getParameterTypes().size() ? 1 : 0) != 0);
        Iterator<XExecutableParameterElement> parameters = method.getParameters().iterator();
        Iterator<XType> parameterTypes = methodType.getParameterTypes().iterator();
        int i = 0;
        while (parameters.hasNext()) {
            if (i > 0) {
                builder.append(", ");
            }
            this.appendParameter(builder, parameters.next(), parameterTypes.next());
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    public String formatWithoutReturnType(XExecutableElement method) {
        return this.format(method, Optional.empty(), false);
    }

    private void appendParameter(StringBuilder builder, XVariableElement parameter, XType parameterType) {
        this.injectionAnnotations.getQualifier(parameter).ifPresent(qualifier -> builder.append(MethodSignatureFormatter.formatAnnotation(qualifier)).append(' '));
        builder.append(MethodSignatureFormatter.nameOfType(parameterType));
    }

    private static String nameOfType(XType type) {
        return DiagnosticFormatting.stripCommonTypePrefixes(XTypes.toStableString(type));
    }

    private static ImmutableList<String> formatedAnnotations(XExecutableElement executableElement) {
        Nullability nullability = Nullability.of(executableElement);
        ImmutableList formattedAnnotations = (ImmutableList)Streams.concat((Stream[])new Stream[]{executableElement.getAllAnnotations().stream().filter(annotation -> !XAnnotations.asClassName(annotation).equals(JET_BRAINS_NOT_NULL)).map(MethodSignatureFormatter::formatAnnotation), nullability.nullableAnnotations().stream().filter(annotation -> !annotation.equals(JET_BRAINS_NOT_NULL)).map(annotation -> String.format("@%s", annotation.getCanonicalName()))}).distinct().collect(DaggerStreams.toImmutableList());
        if (nullability.isKotlinTypeNullable()) {
            if (nullability.nullableAnnotations().stream().noneMatch(JET_BRAINS_NULLABLE::equals) && XConverters.getProcessingEnv(executableElement).findTypeElement(JET_BRAINS_NULLABLE) != null) {
                formattedAnnotations = ImmutableList.builder().addAll((Iterable)formattedAnnotations).add((Object)String.format("@%s", JET_BRAINS_NULLABLE.getCanonicalName())).build();
            }
        }
        return formattedAnnotations;
    }

    private static String formatAnnotation(XAnnotation annotation) {
        return DiagnosticFormatting.stripCommonTypePrefixes(XAnnotations.toString(annotation));
    }
}

