/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_BindingGraphImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_BindingNodeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_ComponentNodeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_DaggerAnnotationImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_DaggerElementImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_DaggerExecutableElementImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_DaggerTypeElementImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_DaggerTypeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_DependencyEdgeImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_MissingBindingImpl;
import dagger.internal.codegen.validation.AutoValue_SpiModelBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingKind;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerExecutableElement;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DaggerType;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.Scope;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class SpiModelBindingGraphConverter {
    private SpiModelBindingGraphConverter() {
    }

    public static dagger.spi.model.DiagnosticReporter toSpiModel(DiagnosticReporter reporter) {
        return DiagnosticReporterImpl.create(reporter);
    }

    public static dagger.spi.model.BindingGraph toSpiModel(BindingGraph graph, XProcessingEnv env) {
        return BindingGraphImpl.create(graph, env);
    }

    private static ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge> toSpiModel(Network<BindingGraph.Node, BindingGraph.Edge> internalNetwork, XProcessingEnv env) {
        MutableNetwork network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        ImmutableMap fromInternalNodes = (ImmutableMap)internalNetwork.nodes().stream().collect(DaggerStreams.toImmutableMap(node -> node, node -> SpiModelBindingGraphConverter.toSpiModel(node, env)));
        for (BindingGraph.Node node2 : fromInternalNodes.values()) {
            network.addNode((Object)node2);
        }
        for (BindingGraph.Edge edge : internalNetwork.edges()) {
            EndpointPair edgePair = internalNetwork.incidentNodes((Object)edge);
            network.addEdge((Object)((BindingGraph.Node)fromInternalNodes.get(edgePair.source())), (Object)((BindingGraph.Node)fromInternalNodes.get(edgePair.target())), (Object)SpiModelBindingGraphConverter.toSpiModel(edge, env));
        }
        return ImmutableNetwork.copyOf((Network)network);
    }

    private static BindingGraph.Node toSpiModel(BindingGraph.Node node, XProcessingEnv env) {
        if (node instanceof Binding) {
            return BindingNodeImpl.create((Binding)node, env);
        }
        if (node instanceof BindingGraph.ComponentNode) {
            return ComponentNodeImpl.create((BindingGraph.ComponentNode)node, env);
        }
        if (node instanceof BindingGraph.MissingBinding) {
            return MissingBindingImpl.create((BindingGraph.MissingBinding)node, env);
        }
        throw new IllegalStateException("Unhandled node type: " + node.getClass());
    }

    private static BindingGraph.Edge toSpiModel(BindingGraph.Edge edge, XProcessingEnv env) {
        if (edge instanceof BindingGraph.DependencyEdge) {
            return DependencyEdgeImpl.create((BindingGraph.DependencyEdge)edge, env);
        }
        if (edge instanceof BindingGraph.ChildFactoryMethodEdge) {
            return ChildFactoryMethodEdgeImpl.create((BindingGraph.ChildFactoryMethodEdge)edge, env);
        }
        if (edge instanceof BindingGraph.SubcomponentCreatorBindingEdge) {
            return SubcomponentCreatorBindingEdgeImpl.create((BindingGraph.SubcomponentCreatorBindingEdge)edge, env);
        }
        throw new IllegalStateException("Unhandled edge type: " + edge.getClass());
    }

    private static dagger.spi.model.Key toSpiModel(Key key) {
        Key.Builder builder = dagger.spi.model.Key.builder((DaggerType)SpiModelBindingGraphConverter.toSpiModel(key.type().xprocessing())).qualifier(key.qualifier().map(qualifier -> SpiModelBindingGraphConverter.toSpiModel(qualifier.xprocessing())));
        if (key.multibindingContributionIdentifier().isPresent()) {
            return builder.multibindingContributionIdentifier(SpiModelBindingGraphConverter.toSpiModel(key.multibindingContributionIdentifier().get().contributingModule().xprocessing()), SpiModelBindingGraphConverter.toSpiModel(key.multibindingContributionIdentifier().get().bindingMethod().xprocessing())).build();
        }
        return builder.build().withoutMultibindingContributionIdentifier();
    }

    private static BindingKind toSpiModel(dagger.internal.codegen.model.BindingKind bindingKind) {
        return BindingKind.valueOf((String)bindingKind.name());
    }

    private static dagger.spi.model.RequestKind toSpiModel(RequestKind requestKind) {
        return dagger.spi.model.RequestKind.valueOf((String)requestKind.name());
    }

    private static DependencyRequest toSpiModel(dagger.internal.codegen.model.DependencyRequest request) {
        DependencyRequest.Builder builder = DependencyRequest.builder().kind(SpiModelBindingGraphConverter.toSpiModel(request.kind())).key(SpiModelBindingGraphConverter.toSpiModel(request.key())).isNullable(request.isNullable());
        request.requestElement().ifPresent(e -> builder.requestElement(SpiModelBindingGraphConverter.toSpiModel(e.xprocessing())));
        return builder.build();
    }

    private static Scope toSpiModel(dagger.internal.codegen.model.Scope scope) {
        return Scope.scope((DaggerAnnotation)SpiModelBindingGraphConverter.toSpiModel(scope.scopeAnnotation().xprocessing()));
    }

    private static ComponentPath toSpiModel(dagger.internal.codegen.model.ComponentPath path) {
        return ComponentPath.create((Iterable)((Iterable)path.components().stream().map(component -> SpiModelBindingGraphConverter.toSpiModel(component.xprocessing())).collect(DaggerStreams.toImmutableList())));
    }

    private static DaggerTypeElement toSpiModel(XTypeElement typeElement) {
        return DaggerTypeElementImpl.from(typeElement);
    }

    private static DaggerType toSpiModel(XType type) {
        return DaggerTypeImpl.from(type);
    }

    static DaggerAnnotation toSpiModel(XAnnotation annotation) {
        return DaggerAnnotationImpl.from(annotation);
    }

    private static DaggerElement toSpiModel(XElement element) {
        return DaggerElementImpl.from(element);
    }

    private static DaggerExecutableElement toSpiModel(XExecutableElement executableElement) {
        return DaggerExecutableElementImpl.from(executableElement);
    }

    static DaggerProcessingEnv toSpiModel(XProcessingEnv env) {
        return DaggerProcessingEnvImpl.from(env);
    }

    private static BindingGraph.ComponentNode toInternal(BindingGraph.ComponentNode componentNode) {
        return ((ComponentNodeImpl)componentNode).internalDelegate();
    }

    private static BindingGraph.MaybeBinding toInternal(BindingGraph.MaybeBinding maybeBinding) {
        if (maybeBinding instanceof MissingBindingImpl) {
            return ((MissingBindingImpl)maybeBinding).internalDelegate();
        }
        if (maybeBinding instanceof BindingNodeImpl) {
            return ((BindingNodeImpl)maybeBinding).internalDelegate();
        }
        throw new IllegalStateException("Unhandled binding type: " + maybeBinding.getClass());
    }

    private static BindingGraph.DependencyEdge toInternal(BindingGraph.DependencyEdge dependencyEdge) {
        return ((DependencyEdgeImpl)dependencyEdge).internalDelegate();
    }

    private static BindingGraph.ChildFactoryMethodEdge toInternal(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge) {
        return ((ChildFactoryMethodEdgeImpl)childFactoryMethodEdge).internalDelegate();
    }

    private static void checkIsJavac(DaggerProcessingEnv.Backend backend) {
        Preconditions.checkState((backend == DaggerProcessingEnv.Backend.JAVAC ? 1 : 0) != 0, (String)"Expected JAVAC backend but was: %s", (Object)backend);
    }

    private static void checkIsKsp(DaggerProcessingEnv.Backend backend) {
        Preconditions.checkState((backend == DaggerProcessingEnv.Backend.KSP ? 1 : 0) != 0, (String)"Expected KSP backend but was: %s", (Object)backend);
    }

    private static DaggerProcessingEnv.Backend getBackend(XProcessingEnv env) {
        switch (env.getBackend()) {
            case JAVAC: {
                return DaggerProcessingEnv.Backend.JAVAC;
            }
            case KSP: {
                return DaggerProcessingEnv.Backend.KSP;
            }
        }
        throw new AssertionError((Object)String.format("Unexpected backend %s", new Object[]{env.getBackend()}));
    }

    private static final class DiagnosticReporterImpl
    extends dagger.spi.model.DiagnosticReporter {
        private final DiagnosticReporter delegate;

        static DiagnosticReporterImpl create(DiagnosticReporter reporter) {
            return new DiagnosticReporterImpl(reporter);
        }

        DiagnosticReporterImpl(DiagnosticReporter delegate) {
            this.delegate = delegate;
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String message) {
            this.delegate.reportComponent(diagnosticKind, SpiModelBindingGraphConverter.toInternal(componentNode), message);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.delegate.reportBinding(diagnosticKind, SpiModelBindingGraphConverter.toInternal(binding), message);
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.delegate.reportDependency(diagnosticKind, SpiModelBindingGraphConverter.toInternal(dependencyEdge), message);
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.delegate.reportSubcomponentFactoryMethod(diagnosticKind, SpiModelBindingGraphConverter.toInternal(childFactoryMethodEdge), message);
        }
    }

    @AutoValue
    static abstract class BindingGraphImpl
    extends dagger.spi.model.BindingGraph {
        private ImmutableMap<ComponentPath, BindingGraph.ComponentNode> componentNodesByPath;

        BindingGraphImpl() {
        }

        static dagger.spi.model.BindingGraph create(BindingGraph bindingGraph, XProcessingEnv env) {
            AutoValue_SpiModelBindingGraphConverter_BindingGraphImpl bindingGraphImpl = new AutoValue_SpiModelBindingGraphConverter_BindingGraphImpl((ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge>)SpiModelBindingGraphConverter.toSpiModel((Network<BindingGraph.Node, BindingGraph.Edge>)bindingGraph.network(), env), bindingGraph.isFullBindingGraph(), DaggerProcessingEnv.Backend.valueOf((String)env.getBackend().name()));
            bindingGraphImpl.componentNodesByPath = (ImmutableMap)bindingGraphImpl.componentNodes().stream().collect(DaggerStreams.toImmutableMap(BindingGraph.ComponentNode::componentPath, node -> node));
            return bindingGraphImpl;
        }

        public Optional<BindingGraph.ComponentNode> componentNode(ComponentPath componentPath) {
            return this.componentNodesByPath.containsKey((Object)componentPath) ? Optional.of((BindingGraph.ComponentNode)this.componentNodesByPath.get((Object)componentPath)) : Optional.empty();
        }

        @Memoized
        public ImmutableSetMultimap<Class<? extends BindingGraph.Node>, ? extends BindingGraph.Node> nodesByClass() {
            return super.nodesByClass();
        }

        @Memoized
        protected ImmutableNetwork<BindingGraph.Node, BindingGraph.DependencyEdge> dependencyGraph() {
            return super.dependencyGraph();
        }
    }

    @AutoValue
    static abstract class BindingNodeImpl
    implements dagger.spi.model.Binding {
        BindingNodeImpl() {
        }

        static dagger.spi.model.Binding create(Binding binding, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_BindingNodeImpl(SpiModelBindingGraphConverter.toSpiModel(binding.key()), SpiModelBindingGraphConverter.toSpiModel(binding.componentPath()), (ImmutableSet<DependencyRequest>)((ImmutableSet)binding.dependencies().stream().map(x$0 -> SpiModelBindingGraphConverter.toSpiModel(x$0)).collect(DaggerStreams.toImmutableSet())), binding.bindingElement().map(element -> SpiModelBindingGraphConverter.toSpiModel(element.xprocessing())), binding.contributingModule().map(module -> SpiModelBindingGraphConverter.toSpiModel(module.xprocessing())), binding.requiresModuleInstance(), binding.scope().map(x$0 -> SpiModelBindingGraphConverter.toSpiModel(x$0)), binding.isNullable(), binding.isProduction(), SpiModelBindingGraphConverter.toSpiModel(binding.kind()), binding);
        }

        abstract Binding internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class ComponentNodeImpl
    implements BindingGraph.ComponentNode {
        ComponentNodeImpl() {
        }

        static BindingGraph.ComponentNode create(BindingGraph.ComponentNode componentNode, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_ComponentNodeImpl(SpiModelBindingGraphConverter.toSpiModel(componentNode.componentPath()), componentNode.isSubcomponent(), componentNode.isRealComponent(), (ImmutableSet<DependencyRequest>)((ImmutableSet)componentNode.entryPoints().stream().map(x$0 -> SpiModelBindingGraphConverter.toSpiModel(x$0)).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<Scope>)((ImmutableSet)componentNode.scopes().stream().map(x$0 -> SpiModelBindingGraphConverter.toSpiModel(x$0)).collect(DaggerStreams.toImmutableSet())), componentNode);
        }

        abstract BindingGraph.ComponentNode internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class MissingBindingImpl
    extends BindingGraph.MissingBinding {
        MissingBindingImpl() {
        }

        static BindingGraph.MissingBinding create(BindingGraph.MissingBinding missingBinding, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_MissingBindingImpl(SpiModelBindingGraphConverter.toSpiModel(missingBinding.componentPath()), SpiModelBindingGraphConverter.toSpiModel(missingBinding.key()), missingBinding);
        }

        abstract BindingGraph.MissingBinding internalDelegate();

        @Memoized
        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    @AutoValue
    static abstract class DependencyEdgeImpl
    implements BindingGraph.DependencyEdge {
        DependencyEdgeImpl() {
        }

        static BindingGraph.DependencyEdge create(BindingGraph.DependencyEdge dependencyEdge, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_DependencyEdgeImpl(SpiModelBindingGraphConverter.toSpiModel(dependencyEdge.dependencyRequest()), dependencyEdge.isEntryPoint(), dependencyEdge);
        }

        abstract BindingGraph.DependencyEdge internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class ChildFactoryMethodEdgeImpl
    implements BindingGraph.ChildFactoryMethodEdge {
        ChildFactoryMethodEdgeImpl() {
        }

        static BindingGraph.ChildFactoryMethodEdge create(BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_ChildFactoryMethodEdgeImpl(SpiModelBindingGraphConverter.toSpiModel(childFactoryMethodEdge.factoryMethod().xprocessing()), childFactoryMethodEdge);
        }

        abstract BindingGraph.ChildFactoryMethodEdge internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class SubcomponentCreatorBindingEdgeImpl
    implements BindingGraph.SubcomponentCreatorBindingEdge {
        SubcomponentCreatorBindingEdgeImpl() {
        }

        static BindingGraph.SubcomponentCreatorBindingEdge create(BindingGraph.SubcomponentCreatorBindingEdge subcomponentCreatorBindingEdge, XProcessingEnv env) {
            return new AutoValue_SpiModelBindingGraphConverter_SubcomponentCreatorBindingEdgeImpl((ImmutableSet<DaggerTypeElement>)((ImmutableSet)subcomponentCreatorBindingEdge.declaringModules().stream().map(module -> SpiModelBindingGraphConverter.toSpiModel(module.xprocessing())).collect(DaggerStreams.toImmutableSet())), subcomponentCreatorBindingEdge);
        }

        abstract BindingGraph.SubcomponentCreatorBindingEdge internalDelegate();

        public final String toString() {
            return this.internalDelegate().toString();
        }
    }

    @AutoValue
    static abstract class DaggerTypeElementImpl
    extends DaggerTypeElement {
        DaggerTypeElementImpl() {
        }

        public static DaggerTypeElement from(XTypeElement element) {
            return new AutoValue_SpiModelBindingGraphConverter_DaggerTypeElementImpl(element);
        }

        abstract XTypeElement element();

        public TypeElement javac() {
            SpiModelBindingGraphConverter.checkIsJavac(this.backend());
            return XConverters.toJavac(this.element());
        }

        public KSClassDeclaration ksp() {
            SpiModelBindingGraphConverter.checkIsKsp(this.backend());
            return XConverters.toKS(this.element());
        }

        public DaggerProcessingEnv.Backend backend() {
            return SpiModelBindingGraphConverter.getBackend(XConverters.getProcessingEnv(this.element()));
        }

        public final String toString() {
            return XElements.toStableString(this.element());
        }
    }

    @AutoValue
    static abstract class DaggerTypeImpl
    extends DaggerType {
        DaggerTypeImpl() {
        }

        public static DaggerType from(XType type) {
            return new AutoValue_SpiModelBindingGraphConverter_DaggerTypeImpl((Equivalence.Wrapper<XType>)XTypes.equivalence().wrap((Object)type));
        }

        abstract Equivalence.Wrapper<XType> type();

        public TypeMirror javac() {
            SpiModelBindingGraphConverter.checkIsJavac(this.backend());
            return XConverters.toJavac((XType)this.type().get());
        }

        public KSType ksp() {
            SpiModelBindingGraphConverter.checkIsKsp(this.backend());
            return XConverters.toKS((XType)this.type().get());
        }

        public DaggerProcessingEnv.Backend backend() {
            return SpiModelBindingGraphConverter.getBackend(XConverters.getProcessingEnv((XType)this.type().get()));
        }

        public final String toString() {
            return XTypes.toStableString((XType)this.type().get());
        }
    }

    @AutoValue
    static abstract class DaggerAnnotationImpl
    extends DaggerAnnotation {
        DaggerAnnotationImpl() {
        }

        public static DaggerAnnotation from(XAnnotation annotation) {
            return new AutoValue_SpiModelBindingGraphConverter_DaggerAnnotationImpl((Equivalence.Wrapper<XAnnotation>)XAnnotations.equivalence().wrap((Object)annotation));
        }

        abstract Equivalence.Wrapper<XAnnotation> annotation();

        public DaggerTypeElement annotationTypeElement() {
            return DaggerTypeElementImpl.from(((XAnnotation)this.annotation().get()).getTypeElement());
        }

        public AnnotationMirror javac() {
            SpiModelBindingGraphConverter.checkIsJavac(this.backend());
            return XConverters.toJavac((XAnnotation)this.annotation().get());
        }

        public KSAnnotation ksp() {
            SpiModelBindingGraphConverter.checkIsKsp(this.backend());
            return XConverters.toKS((XAnnotation)this.annotation().get());
        }

        public DaggerProcessingEnv.Backend backend() {
            return SpiModelBindingGraphConverter.getBackend(XConverters.getProcessingEnv((XAnnotation)this.annotation().get()));
        }

        public final String toString() {
            return XAnnotations.toStableString((XAnnotation)this.annotation().get());
        }
    }

    @AutoValue
    static abstract class DaggerElementImpl
    extends DaggerElement {
        DaggerElementImpl() {
        }

        public static DaggerElement from(XElement element) {
            return new AutoValue_SpiModelBindingGraphConverter_DaggerElementImpl(element);
        }

        abstract XElement element();

        public Element javac() {
            SpiModelBindingGraphConverter.checkIsJavac(this.backend());
            return XConverters.toJavac(this.element());
        }

        public KSAnnotated ksp() {
            SpiModelBindingGraphConverter.checkIsKsp(this.backend());
            return XConverters.toKS(this.element());
        }

        public DaggerProcessingEnv.Backend backend() {
            return SpiModelBindingGraphConverter.getBackend(XConverters.getProcessingEnv(this.element()));
        }

        public final String toString() {
            return XElements.toStableString(this.element());
        }
    }

    @AutoValue
    static abstract class DaggerExecutableElementImpl
    extends DaggerExecutableElement {
        DaggerExecutableElementImpl() {
        }

        public static DaggerExecutableElement from(XExecutableElement executableElement) {
            return new AutoValue_SpiModelBindingGraphConverter_DaggerExecutableElementImpl(executableElement);
        }

        abstract XExecutableElement executableElement();

        public ExecutableElement javac() {
            SpiModelBindingGraphConverter.checkIsJavac(this.backend());
            return XConverters.toJavac(this.executableElement());
        }

        public KSDeclaration ksp() {
            SpiModelBindingGraphConverter.checkIsKsp(this.backend());
            return XElementKt.isMethod(this.executableElement()) && XElements.asMethod(this.executableElement()).isKotlinPropertyMethod() ? (KSPropertyDeclaration)XConverters.toKS((XElement)this.executableElement()) : XConverters.toKS(this.executableElement());
        }

        public DaggerProcessingEnv.Backend backend() {
            return SpiModelBindingGraphConverter.getBackend(XConverters.getProcessingEnv(this.executableElement()));
        }

        public final String toString() {
            return XElements.toStableString(this.executableElement());
        }
    }

    private static class DaggerProcessingEnvImpl
    extends DaggerProcessingEnv {
        private final XProcessingEnv env;

        public static DaggerProcessingEnv from(XProcessingEnv env) {
            return new DaggerProcessingEnvImpl(env);
        }

        DaggerProcessingEnvImpl(XProcessingEnv env) {
            this.env = env;
        }

        public ProcessingEnvironment javac() {
            SpiModelBindingGraphConverter.checkIsJavac(this.backend());
            return XConverters.toJavac(this.env);
        }

        public SymbolProcessorEnvironment ksp() {
            SpiModelBindingGraphConverter.checkIsKsp(this.backend());
            return XConverters.toKS(this.env);
        }

        public Resolver resolver() {
            return XConverters.toKSResolver(this.env);
        }

        public DaggerProcessingEnv.Backend backend() {
            return SpiModelBindingGraphConverter.getBackend(this.env);
        }
    }
}

