/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import java.util.Set;
import javax.inject.Inject;

final class InjectProcessingStep
extends TypeCheckingProcessingStep<XElement> {
    private final InjectBindingRegistry injectBindingRegistry;
    private final Set<XElement> processedElements = Sets.newHashSet();

    @Inject
    InjectProcessingStep(InjectBindingRegistry injectBindingRegistry) {
        this.injectBindingRegistry = injectBindingRegistry;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.builder().addAll(XTypeNames.injectTypeNames()).add((Object)XTypeNames.ASSISTED_INJECT).build();
    }

    @Override
    protected boolean requiresPreValidation() {
        return false;
    }

    @Override
    protected void process(XElement injectElement, ImmutableSet<XClassName> annotations) {
        if (this.processedElements.contains(injectElement)) {
            return;
        }
        if (XElementKt.isConstructor(injectElement)) {
            this.injectBindingRegistry.tryRegisterInjectConstructor(XElements.asConstructor(injectElement));
        } else if (XElementKt.isField(injectElement)) {
            this.injectBindingRegistry.tryRegisterInjectField(XElements.asField(injectElement));
        } else if (XElementKt.isMethod(injectElement)) {
            this.injectBindingRegistry.tryRegisterInjectMethod(XElements.asMethod(injectElement));
        }
        this.processedElements.add(injectElement);
    }
}

