/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.MultibindingFactoryCreationExpression;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;

final class MapFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final XProcessingEnv processingEnv;
    private final ComponentImplementation componentImplementation;
    private final BindingGraph graph;
    private final MultiboundMapBinding binding;
    private final boolean useLazyClassKey;

    @AssistedInject
    MapFactoryCreationExpression(@Assisted MultiboundMapBinding binding, XProcessingEnv processingEnv, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, BindingGraph graph) {
        super(binding, componentImplementation, componentRequestRepresentations);
        this.processingEnv = processingEnv;
        this.binding = (MultiboundMapBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = componentImplementation;
        this.graph = graph;
        this.useLazyClassKey = MapKeys.useLazyClassKey(binding, graph);
    }

    @Override
    public XCodeBlock creationExpression() {
        XClassName mapFactoryClassName = SourceFiles.mapFactoryClassName(this.binding);
        XCodeBlock.Builder builder = XCodeBlock.builder().add("%T.", new Object[]{mapFactoryClassName});
        XTypeName valueTypeName = XTypeName.ANY_OBJECT;
        if (!this.useRawType()) {
            MapType mapType = MapType.from(this.binding.key());
            valueTypeName = mapType.unwrappedFrameworkValueType().asTypeName();
            builder.add("<%T, %T>", new Object[]{this.useLazyClassKey ? XTypeName.STRING : mapType.keyType().asTypeName(), valueTypeName});
        }
        builder.add("builder(%L)", new Object[]{this.binding.dependencies().size()});
        for (DependencyRequest dependency : this.binding.dependencies()) {
            ContributionBinding contributionBinding = this.graph.contributionBinding(dependency.key());
            builder.add(".put(%L, %L)", new Object[]{this.useLazyClassKey ? MapKeys.getLazyClassMapKeyExpression(this.graph.contributionBinding(dependency.key())) : MapKeys.getMapKeyExpression(contributionBinding, this.componentImplementation.name(), this.processingEnv), this.multibindingDependencyExpression(dependency)});
        }
        XCodeBlock creationExpression = builder.add(".build()", new Object[0]).build();
        return this.useLazyClassKey ? XCodeBlock.of((String)"%T.<%T>of(%L)", (Object[])new Object[]{MapFactoryCreationExpression.lazyMapFactoryClassName(this.binding), valueTypeName, creationExpression}) : creationExpression;
    }

    private static XClassName lazyMapFactoryClassName(MultiboundMapBinding binding) {
        MapType mapType = MapType.from(binding.key());
        switch (binding.bindingType()) {
            case PROVISION: {
                return mapType.valuesAreProvider() ? XTypeNames.LAZY_CLASS_KEY_MAP_PROVIDER_FACTORY : XTypeNames.LAZY_CLASS_KEY_MAP_FACTORY;
            }
            case PRODUCTION: {
                return mapType.valuesAreFrameworkType() ? (mapType.valuesAreTypeOf(XTypeNames.PRODUCER) ? XTypeNames.LAZY_MAP_OF_PRODUCER_PRODUCER : XTypeNames.LAZY_MAP_OF_PRODUCED_PRODUCER) : XTypeNames.LAZY_MAP_PRODUCER;
            }
        }
        throw new IllegalArgumentException(binding.bindingType().toString());
    }

    @AssistedFactory
    static interface Factory {
        public MapFactoryCreationExpression create(MultiboundMapBinding var1);
    }
}

