/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.kotlinpoet.TypeName;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.List;
import java.util.Optional;

public final class FrameworkField {
    private final String name;
    private final XTypeName type;

    public static FrameworkField create(String fieldName, XClassName frameworkClassName, XType type) {
        return FrameworkField.createInternal(fieldName, frameworkClassName, Optional.of(type), Nullability.NOT_NULLABLE);
    }

    public static FrameworkField forBinding(ContributionBinding binding, Optional<XClassName> frameworkClassName) {
        return FrameworkField.createInternal(FrameworkField.bindingName(binding), frameworkClassName.orElse(binding.frameworkType().frameworkClassName()), FrameworkField.bindingType(binding), binding.nullability());
    }

    private static String bindingName(ContributionBinding binding) {
        if (binding.bindingElement().isPresent()) {
            String name = FrameworkField.bindingElementName(binding.bindingElement().get());
            return binding.kind().equals((Object)BindingKind.MEMBERS_INJECTOR) ? name + "MembersInjector" : name;
        }
        return KeyVariableNamer.name(binding.key());
    }

    private static Optional<XType> bindingType(ContributionBinding binding) {
        if (binding.contributionType().isMultibinding()) {
            return Optional.of(binding.contributedType());
        }
        if (MapType.isMapOfProvider(binding.contributedType())) {
            return Optional.empty();
        }
        return Optional.of(binding.key().type().xprocessing());
    }

    private static FrameworkField createInternal(String fieldName, XClassName frameworkClassName, Optional<XType> type, Nullability nullability) {
        XTypeName fieldType = type.map(XType::asTypeName).map(typeName -> XConverters.toXPoet((com.squareup.javapoet.TypeName)XTypeNameKt.toJavaPoet((XTypeName)typeName).annotated((List)nullability.typeUseNullableAnnotations().stream().map(XConverters::toJavaPoet).map(AnnotationSpec::builder).map(AnnotationSpec.Builder::build).collect(DaggerStreams.toImmutableList())), (TypeName)XTypeNameKt.toKotlinPoet((XTypeName)typeName))).map(xva$0 -> frameworkClassName.parametrizedBy(new XTypeName[]{xva$0})).orElse((XTypeName)frameworkClassName);
        return new FrameworkField(FrameworkField.frameworkFieldName(fieldName, frameworkClassName), fieldType);
    }

    private static String frameworkFieldName(String fieldName, XClassName frameworkClassName) {
        String suffix = (String)Iterables.getLast((Iterable)frameworkClassName.getSimpleNames());
        return fieldName.endsWith(suffix) ? fieldName : fieldName + suffix;
    }

    private static String bindingElementName(XElement bindingElement) {
        if (XElementKt.isConstructor((XElement)bindingElement)) {
            return FrameworkField.bindingElementName(bindingElement.getEnclosingElement());
        }
        if (XElementKt.isMethod((XElement)bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        if (XElementKt.isTypeElement((XElement)bindingElement)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName(bindingElement));
        }
        if (XElementKt.isMethodParameter((XElement)bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        throw new IllegalArgumentException("Unexpected binding " + bindingElement);
    }

    FrameworkField(String name, XTypeName type) {
        this.name = name;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public XTypeName type() {
        return this.type;
    }
}

